/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class CentroidViewer
extends JPanel
implements IViewer {
    public static final Color DEF_CLUSTER_COLOR = Color.lightGray;
    protected static final Color bColor = new Color(0, 0, 128);
    protected JMenuItem setOverallMaxMenuItem;
    protected JMenuItem setClusterMaxMenuItem;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    protected static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String TOGGLE_REF_LINE_CMD = "toggle-ref-line-cmd";
    protected Color centroidColor = Color.magenta;
    protected Experiment experiment;
    protected IFramework framework;
    protected IData data;
    protected int clusterIndex;
    protected int[][] clusters;
    protected float maxYValue;
    protected float maxClusterValue;
    protected float maxExperimentValue;
    protected boolean gradientToggle = true;
    protected int yRangeOption;
    public static int USE_EXPERIMENT_MAX = 0;
    public static int USE_CLUSTER_MAX = 1;
    protected boolean drawValues = true;
    protected boolean drawVariances = true;
    protected boolean drawCodes = true;
    private boolean drawMarks = true;
    protected boolean isAntiAliasing = false;
    protected boolean gradientColors;
    protected float[][] means;
    protected float[][] variances;
    protected float[][] codes;
    protected float minValue;
    protected float maxValue;
    public static Color missingColor = new Color(128, 128, 128);
    public static BufferedImage posColorImage;
    public static BufferedImage negColorImage;
    protected boolean drawReferenceBlock = false;
    protected int xref = 0;
    protected int yref = 0;
    protected int currExpRefLine;
    protected boolean showRefLine = false;

    public CentroidViewer(Experiment experiment, int[][] nArray) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.clusters = nArray;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.maxExperimentValue = experiment.getMaxAbsValue();
        this.yRangeOption = USE_EXPERIMENT_MAX;
        this.addMouseMotionListener(new GraphListener());
    }

    public void setMeans(float[][] fArray) {
        this.means = fArray;
    }

    public void toggleGradient() {
        this.gradientToggle = !this.gradientToggle;
    }

    public void setVariances(float[][] fArray) {
        this.variances = fArray;
    }

    public void setCodes(float[][] fArray) {
        this.codes = fArray;
    }

    public void setDrawMarks(boolean bl) {
        this.drawMarks = bl;
    }

    public void setDrawVariances(boolean bl) {
        this.drawVariances = bl;
    }

    public void setDrawValues(boolean bl) {
        this.drawValues = bl;
    }

    public void setDrawCodes(boolean bl) {
        this.drawCodes = bl;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.setData(iFramework.getData());
        this.setAntiAliasing(iFramework.getDisplayMenu().isAntiAliasing());
        Object object = iFramework.getUserObject();
        if (object instanceof CentroidUserObject) {
            this.setClusterIndex(((CentroidUserObject)object).getClusterIndex());
            this.setMode(((CentroidUserObject)object).getMode());
        } else {
            this.setMode((Integer)object);
        }
        this.updateValues(this.getCluster());
        this.maxValue = Math.abs(iFramework.getDisplayMenu().getMaxRatioScale());
        this.minValue = -Math.abs(iFramework.getDisplayMenu().getMinRatioScale());
        posColorImage = iFramework.getDisplayMenu().getPositiveGradientImage();
        negColorImage = iFramework.getDisplayMenu().getNegativeGradientImage();
        this.setGradient(iFramework.getDisplayMenu().getColorGradientState());
    }

    public boolean checkGradient() {
        boolean bl = true;
        for (int i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.clusters[i].length; ++j) {
                try {
                    if (this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.clusters[i][j])) == null) continue;
                    bl = false;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public void setGradient(boolean bl) {
        this.gradientColors = bl;
        this.gradientToggle = bl;
    }

    private Color getColor(float f) {
        if (Float.isNaN(f)) {
            return missingColor;
        }
        float f2 = f < 0.0f ? this.minValue : this.maxValue;
        int n = (int)(255.0f * f / f2);
        n = n > 255 ? 255 : n;
        int n2 = f < 0.0f ? negColorImage.getRGB(255 - n, 0) : posColorImage.getRGB(n, 0);
        return new Color(n2);
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
        this.updateValues(this.getCluster());
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    protected int getProbe(int n) {
        return this.clusters[this.clusterIndex][n];
    }

    public void setMode(int n) {
        switch (n) {
            case 0: {
                this.setDrawVariances(true);
                this.setDrawValues(false);
                break;
            }
            case 1: {
                this.setDrawVariances(false);
                this.setDrawValues(true);
            }
        }
    }

    private void updateValues(int[] nArray) {
        this.maxClusterValue = this.calculateMaxValue(nArray);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getArrayMappedToData(), this.experiment, 0);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getArrayMappedToData(), this.experiment, 0);
        this.onDataChanged(this.data);
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getArrayMappedToData(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    private int[] getArrayMappedToData() {
        int[] nArray = this.getCluster();
        if (nArray == null || nArray.length < 1) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setYRangeOption(int n) {
        if (n != USE_EXPERIMENT_MAX) {
            if (n != USE_CLUSTER_MAX) {
                this.yRangeOption = USE_EXPERIMENT_MAX;
                return;
            }
        }
        this.yRangeOption = n;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        this.paint((Graphics2D)graphics, rectangle, true);
    }

    public void subPaint(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        super.paint(graphics2D);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        super.paint(graphics2D);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (n4 < 5 || n5 < 5) {
            return;
        }
        int n6 = n3 + Math.round((float)n5 / 2.0f);
        int n7 = this.experiment.getNumberOfSamples();
        if (this.yRangeOption == USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float f = (float)n5 / (2.0f * this.maxYValue);
        float f2 = (float)n4 / (float)(n7 - 1);
        int n8 = (int)this.maxYValue + 1;
        if (this.drawVariances) {
            graphics2D.setColor(bColor);
            for (n = 0; n < n7; ++n) {
                if (Float.isNaN(this.means[this.clusterIndex][n]) || Float.isNaN(this.variances[this.clusterIndex][n]) || this.variances[this.clusterIndex][n] < 0.0f) continue;
                graphics2D.drawLine(n2 + Math.round((float)n * f2), n6 - Math.round((this.means[this.clusterIndex][n] - this.variances[this.clusterIndex][n]) * f), n2 + Math.round((float)n * f2), n6 - Math.round((this.means[this.clusterIndex][n] + this.variances[this.clusterIndex][n]) * f));
                graphics2D.drawLine(n2 + Math.round((float)n * f2) - 3, n6 - Math.round((this.means[this.clusterIndex][n] - this.variances[this.clusterIndex][n]) * f), n2 + Math.round((float)n * f2) + 3, n6 - Math.round((this.means[this.clusterIndex][n] - this.variances[this.clusterIndex][n]) * f));
                graphics2D.drawLine(n2 + Math.round((float)n * f2) - 3, n6 - Math.round((this.means[this.clusterIndex][n] + this.variances[this.clusterIndex][n]) * f), n2 + Math.round((float)n * f2) + 3, n6 - Math.round((this.means[this.clusterIndex][n] + this.variances[this.clusterIndex][n]) * f));
            }
        }
        if (this.drawValues) {
            n = 0;
            Color color = null;
            float f3 = this.maxExperimentValue * f / 20.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < n7 - 1; ++i) {
                for (int j = 0; j < this.getCluster().length; ++j) {
                    float f4 = this.experiment.get(this.getProbe(j), i);
                    float f5 = this.experiment.get(this.getProbe(j), i + 1);
                    if (Float.isNaN(f4) || Float.isNaN(f5)) continue;
                    if (!this.gradientColors) {
                        color = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.getProbe(j)));
                        color = color == null ? DEF_CLUSTER_COLOR : color;
                        graphics2D.setColor(color);
                        graphics2D.drawLine(n2 + Math.round((float)i * f2), n6 - Math.round(f4 * f), n2 + Math.round((float)(i + 1) * f2), n6 - Math.round(f5 * f));
                        continue;
                    }
                    float f6 = (f5 - f4) * f;
                    int n9 = Math.abs(f6) > f3 ? Math.abs((int)(f6 / f3)) : 1;
                    float f7 = f6 / (float)n9;
                    for (int k = 0; k < n9; ++k) {
                        graphics2D.setColor(this.getColor(f4 + (float)k * f7 / f));
                        graphics2D.drawLine(n2 + Math.round((float)i * f2 + (float)k / (float)n9 * f2), n6 - Math.round(f4 * f + (float)k * f7), n2 + Math.round((float)i * f2 + ((float)k + 1.0f) / (float)n9 * f2), n6 - Math.round(f4 * f + ((float)k + 1.0f) * f7));
                    }
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            graphics2D.setColor(Color.gray);
            for (n = 0; n < n7 - 1; ++n) {
                graphics2D.drawLine(n2 + Math.round((float)n * f2), n6 - Math.round(this.codes[this.clusterIndex][n] * f), n2 + Math.round((float)(n + 1) * f2), n6 - Math.round(this.codes[this.clusterIndex][n + 1] * f));
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n2, n6, n2 + n4, n6);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            graphics2D.setColor(this.centroidColor);
            for (n = 0; n < n7 - 1; ++n) {
                if (Float.isNaN(this.means[this.clusterIndex][n]) || Float.isNaN(this.means[this.clusterIndex][n + 1])) continue;
                graphics2D.drawLine(n2 + Math.round((float)n * f2), n6 - Math.round(this.means[this.clusterIndex][n] * f), n2 + Math.round((float)(n + 1) * f2), n6 - Math.round(this.means[this.clusterIndex][n + 1] * f));
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n2, n3, n4, n5);
        for (n = 1; n < n7 - 1; ++n) {
            graphics2D.drawLine(n2 + Math.round((float)n * f2), n3 + n5 - 5, n2 + Math.round((float)n * f2), n3 + n5);
            graphics2D.drawLine(n2 + Math.round((float)n * f2), n3, n2 + Math.round((float)n * f2), n3 + 5);
        }
        for (n = 1; n < n8; ++n) {
            graphics2D.drawLine(n2, n6 - Math.round((float)n * f), n2 + 5, n6 - Math.round((float)n * f));
            graphics2D.drawLine(n2, n6 + Math.round((float)n * f), n2 + 5, n6 + Math.round((float)n * f));
        }
        graphics2D.setColor(bColor);
        if (bl) {
            int n10;
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (n10 = 1; n10 < n8; ++n10) {
                String string = String.valueOf(n10);
                int n11 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, n2 - 10 - n11, n6 + 5 - Math.round((float)n10 * f));
                string = String.valueOf(-n10);
                n11 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, n2 - 10 - n11, n6 + 5 + Math.round((float)n10 * f));
            }
            graphics2D.rotate(-1.5707963267948966);
            n10 = this.getNamesWidth(fontMetrics);
            for (int i = 0; i < n7; ++i) {
                graphics2D.drawString(this.data.getSampleName(this.experiment.getSampleIndex(i)), -n5 - n3 - 10 - n10, n2 + Math.round((float)i * f2) + 3);
            }
            graphics2D.rotate(1.5707963267948966);
        }
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            graphics2D.setColor(bColor);
            for (int i = 0; i < n7; ++i) {
                if (Float.isNaN(this.means[this.clusterIndex][i])) continue;
                graphics2D.fillOval(n2 + Math.round((float)i * f2) - 3, n6 - Math.round(this.means[this.clusterIndex][i] * f) - 3, 6, 6);
            }
        }
        if (this.showRefLine && this.drawReferenceBlock) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.setColor(Color.yellow);
            graphics2D.fillRect(this.xref - 3, 20, 7, n5);
            graphics2D.setComposite(composite);
            graphics2D.setColor(Color.blue);
            graphics2D.drawLine(this.xref, 20, this.xref, n5 + 20);
            this.framework.setStatusText("Experiment = " + this.data.getSampleName(this.experiment.getSampleIndex(this.currExpRefLine)) + ",   mean = " + this.means[this.clusterIndex][this.currExpRefLine] + ",   sd = " + this.variances[this.clusterIndex][this.currExpRefLine]);
        }
        graphics2D.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            graphics2D.drawString("No Genes", n2 + 10, n3 + 20);
        } else {
            graphics2D.drawString(this.getCluster().length + " Genes", n2 + 10, n3 + 20);
        }
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onDataChanged(IData iData) {
        this.setData(iData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.maxValue = Math.abs(iDisplayMenu.getMaxRatioScale());
        this.minValue = -Math.abs(iDisplayMenu.getMinRatioScale());
        posColorImage = iDisplayMenu.getPositiveGradientImage();
        negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.setGradient(iDisplayMenu.getColorGradientState());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private float calculateMaxValue(int[] nArray) {
        float f = 0.0f;
        int n = this.experiment.getNumberOfSamples();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                float f2 = this.experiment.get(nArray[j], i);
                if (Float.isNaN(f2)) continue;
                f = Math.max(f, Math.abs(f2));
            }
        }
        return f;
    }

    protected int getNamesWidth(FontMetrics fontMetrics) {
        int n = 0;
        for (int i = 0; i < this.experiment.getNumberOfSamples(); ++i) {
            n = Math.max(n, fontMetrics.stringWidth(this.data.getSampleName(this.experiment.getSampleIndex(i))));
        }
        return n;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(actionListener);
        this.setOverallMaxMenuItem.setEnabled(false);
        jPopupMenu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(actionListener);
        jPopupMenu.add(this.setClusterMaxMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Toggle reference line...");
        jMenuItem.setActionCommand(TOGGLE_REF_LINE_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    public float[][] getMeans() {
        return this.means;
    }

    public class GraphListener
    extends MouseAdapter
    implements MouseMotionListener {
        int x = 0;
        int y = 0;

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!CentroidViewer.this.showRefLine) {
                CentroidViewer.this.framework.setStatusText("TIGR MultiExperiment Viewer");
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = CentroidViewer.this.experiment.getNumberOfSamples();
            if (n < 40 || n > CentroidViewer.this.getWidth() - 40 || n3 <= 1) {
                CentroidViewer.this.drawReferenceBlock = false;
                CentroidViewer.this.framework.setStatusText("TIGR MultiExperiment Viewer");
                CentroidViewer.this.repaint();
                return;
            }
            CentroidViewer.this.drawReferenceBlock = true;
            CentroidViewer.this.currExpRefLine = Math.round((float)(n3 - 1) * (((float)n - 40.0f) / ((float)CentroidViewer.this.getWidth() - 80.0f)));
            CentroidViewer.this.xref = n;
            CentroidViewer.this.yref = n2;
            CentroidViewer.this.repaint();
        }
    }
}

