/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;

public class ExperimentUtil {
    public static void saveExperiment(Frame frame, Experiment experiment, IData iData) throws Exception {
        ExperimentUtil.saveExperiment(frame, experiment, iData, ExperimentUtil.createDefaultRows(experiment.getNumberOfGenes()));
    }

    public static void saveExperiment(Frame frame, IData iData, int[] nArray) throws Exception {
        ExperimentUtil.saveExperiment(frame, iData.getExperiment(), iData, nArray);
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData iData, int[] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveCluster(file, experiment, iData, nArray);
        }
    }

    public static void saveExperiment(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new ExpressionFileFilter());
        jFileChooser.setFileView(new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(frame);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    public static void saveGeneCluster(Frame frame, IData iData, int[] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveGeneCluster(file, iData, nArray);
        }
    }

    public static void saveGeneCluster(File file, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        if (stringArray == null) {
            return;
        }
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            if (n >= stringArray.length - 1) continue;
            printWriter.print("\t");
        }
        for (n = 0; n < iData.getFeaturesCount(); ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getFullSampleName(n));
        }
        printWriter.print("\n");
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            printWriter.print(Integer.toString(nArray[n] + 1));
            printWriter.print("\t");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.print(iData.getElementAttribute(nArray[n], n2));
                if (n2 >= stringArray.length - 1) continue;
                printWriter.print("\t");
            }
            for (n2 = 0; n2 < iData.getFeaturesCount(); ++n2) {
                printWriter.print("\t");
                printWriter.print(Float.toString(iData.getRatio(n2, nArray[n], 1)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static void saveCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        if (stringArray == null) {
            return;
        }
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            if (n >= stringArray.length - 1) continue;
            printWriter.print("\t");
        }
        for (n = 0; n < experiment.getNumberOfSamples(); ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getFullSampleName(experiment.getSampleIndex(n)));
        }
        printWriter.print("\n");
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n2));
                if (n2 >= stringArray.length - 1) continue;
                printWriter.print("\t");
            }
            for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n2)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    public static void saveExperimentCluster(Frame frame, Experiment experiment, IData iData, int[] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            ExperimentUtil.saveExperimentCluster(file, experiment, iData, nArray);
        }
    }

    public static void saveAllExperimentClusters(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = ExperimentUtil.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                ExperimentUtil.saveExperimentCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    private static void saveExperimentCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        int n2 = experiment.getNumberOfGenes();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            if (n >= stringArray.length - 1) continue;
            printWriter.print("\t");
        }
        for (n = 0; n < nArray.length; ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getFullSampleName(experiment.getSampleIndex(nArray[n])));
        }
        printWriter.print("\n");
        for (n = 0; n < n2; ++n) {
            int n3;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(n) + 1));
            printWriter.print("\t");
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(n), n3));
                if (n3 >= stringArray.length - 1) continue;
                printWriter.print("\t");
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(n, experiment.getSampleIndex(nArray[n3]))));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static int[] createDefaultRows(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }
}

