/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMContentComponent;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMGraph;

public class CastFOMContentComponentB
extends JPanel {
    private FOMGraph fomGraphB;
    private int[] numOfCastClusters;
    private float[] fom_values;
    float interval;
    float[] sortedFomValues;
    int[] sortedNumCastClusters;

    public CastFOMContentComponentB(float[] fArray, float f, int[] nArray) {
        this.setLayout(new GridBagLayout());
        this.fom_values = fArray;
        this.interval = f;
        this.numOfCastClusters = nArray;
        this.sortedFomValues = this.createSortedFomValues(fArray, nArray);
        this.sortedNumCastClusters = this.createSortedClusterArray(nArray);
        this.fomGraphB = new FOMGraph(this.sortedFomValues, "FOM value vs. # of Clusters", "# of Clusters", "Adjusted FOM");
        this.fomGraphB.setItems(this.createXItems(this.sortedFomValues.length), this.createYItems(this.sortedFomValues));
        this.fomGraphB.setMaxYValue((float)Math.ceil(this.getMaxValue(this.sortedFomValues)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fomGraphB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.createValuesList(this.sortedFomValues, nArray), gridBagConstraints);
    }

    public BufferedImage getImageB() {
        return this.fomGraphB.getImage();
    }

    private JComponent createValuesList(float[] fArray, int[] nArray) {
        String[] stringArray = new String[fArray.length];
        int[] nArray2 = this.createSortedClusterArray(nArray);
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = String.valueOf(nArray2[i]) + "---->" + String.valueOf((float)Math.round(fArray[i] * 1000.0f) / 1000.0f);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(new JList<String>(stringArray));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Details");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CastFOMContentComponentB.this.onDetails();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private void onDetails() {
        JFrame jFrame = new JFrame("Details");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.sortedFomValues.length; ++i) {
            stringBuffer.append(String.valueOf(this.sortedNumCastClusters[i]) + "\t" + String.valueOf((float)Math.round(this.sortedFomValues[i] * 1000.0f) / 1000.0f) + "\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setSize(200, 200);
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - jFrame.getSize().width / 2, dimension.height / 2 - jFrame.getSize().height / 2);
        jFrame.setVisible(true);
    }

    public void onSelected(IFramework iFramework) {
        this.fomGraphB.setAntiAliasing(iFramework.getDisplayMenu().isAntiAliasing());
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.fomGraphB.setAntiAliasing(iDisplayMenu.isAntiAliasing());
    }

    private String[] createXItems(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(this.sortedNumCastClusters[i]);
        }
        return stringArray;
    }

    private int[] createSortedClusterArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i];
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < nArray2.length; ++i) {
            vector.add(new Integer(nArray2[i]));
        }
        HashSet hashSet = new HashSet(vector);
        Vector vector2 = new Vector();
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            vector2.add(object.next());
        }
        object = new int[vector2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)vector2.get(i);
        }
        Arrays.sort((int[])object);
        int[] nArray3 = new int[((Object)object).length - 1];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = (int)object[i];
        }
        return nArray3;
    }

    private float[] createSortedFomValues(float[] fArray, int[] nArray) {
        int[] nArray2 = this.createSortedClusterArray(nArray);
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < nArray2.length; ++i) {
            float f = 0.0f;
            int n = 0;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != nArray2[i]) continue;
                f += fArray[j];
                ++n;
            }
            vector.add(new Float(f /= (float)n));
        }
        float[] fArray2 = new float[vector.size()];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = ((Float)vector.get(i)).floatValue();
        }
        return fArray2;
    }

    private float getMaxValue(float[] fArray) {
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            f = Math.max(f, fArray[i]);
        }
        return f;
    }

    private String[] createYItems(float[] fArray) {
        int n = (int)Math.ceil(this.getMaxValue(fArray)) + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            if (i % 2 != 0 && i != stringArray.length - 1) continue;
            stringArray[i] = String.valueOf(i);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        float[] fArray = new float[]{1.5f, 0.8888889f, 0.6666667f, 2.5f, 0.33333334f, 0.0f};
        FOMContentComponent fOMContentComponent = new FOMContentComponent(fArray);
        jFrame.getContentPane().add(fOMContentComponent);
        jFrame.setSize(700, 400);
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - jFrame.getSize().width / 2, dimension.height / 2 - jFrame.getSize().height / 2);
        jFrame.setVisible(true);
    }
}

