/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class HCLInitDialog
extends AlgorithmDialog {
    private int result;
    private JCheckBox genes_box;
    private JCheckBox cluster_box;
    private JRadioButton ALC;
    private JRadioButton CLC;
    private JRadioButton SLC;

    public HCLInitDialog(Frame frame) {
        super(new JFrame(), "HCL: Hierarchical Clustering", true);
        this.setResizable(false);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.ALC = new JRadioButton("Average linkage clustering");
        this.ALC.setBackground(Color.white);
        this.ALC.setFocusPainted(false);
        this.ALC.setForeground(UIManager.getColor("Label.foreground"));
        this.ALC.setMnemonic(65);
        this.ALC.setSelected(true);
        this.CLC = new JRadioButton("Complete linkage clustering");
        this.CLC.setBackground(Color.white);
        this.CLC.setFocusPainted(false);
        this.CLC.setForeground(UIManager.getColor("Label.foreground"));
        this.CLC.setMnemonic(67);
        this.SLC = new JRadioButton("Single linkage clustering");
        this.SLC.setBackground(Color.white);
        this.SLC.setFocusPainted(false);
        this.SLC.setForeground(UIManager.getColor("Label.foreground"));
        this.SLC.setMnemonic(83);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ALC);
        buttonGroup.add(this.CLC);
        buttonGroup.add(this.SLC);
        this.genes_box = new JCheckBox("Cluster genes");
        this.genes_box.setSelected(true);
        this.genes_box.setFocusPainted(false);
        this.genes_box.setBackground(Color.white);
        this.genes_box.setForeground(UIManager.getColor("Label.foreground"));
        this.genes_box.addItemListener(listener);
        this.cluster_box = new JCheckBox("Cluster experiments");
        this.cluster_box.setSelected(true);
        this.cluster_box.setFocusPainted(false);
        this.cluster_box.setBackground(Color.white);
        this.cluster_box.setForeground(UIManager.getColor("Label.foreground"));
        this.cluster_box.addItemListener(listener);
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 10, 10));
        jPanel.setLayout(new GridLayout(0, 2, 10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setBackground(Color.white);
        jPanel.setForeground(Color.black);
        jPanel.add(this.ALC);
        jPanel.add(this.genes_box);
        jPanel.add(this.CLC);
        jPanel.add(this.cluster_box);
        jPanel.add(this.SLC);
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.add(jPanel);
        this.addContent(parameterPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.ALC.setSelected(true);
        this.genes_box.setSelected(true);
        this.cluster_box.setSelected(true);
    }

    public boolean isClusterGenes() {
        return this.genes_box.isSelected();
    }

    public boolean isClusterExperience() {
        return this.cluster_box.isSelected();
    }

    public int getMethod() {
        if (this.ALC.isSelected()) {
            return 0;
        }
        if (this.CLC.isSelected()) {
            return 1;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        while (true) {
            HCLInitDialog hCLInitDialog;
            if ((hCLInitDialog = new HCLInitDialog(jFrame)).showModal() != 0) {
                System.exit(0);
            }
            System.out.println("===============================");
            System.out.println(hCLInitDialog.isClusterGenes());
            System.out.println(hCLInitDialog.isClusterExperience());
            System.out.println(hCLInitDialog.getMethod());
        }
    }

    protected void disposeDialog() {
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                HCLInitDialog.this.result = 0;
                HCLInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                HCLInitDialog.this.result = 2;
                HCLInitDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    HCLInitDialog.this.resetControls();
                    HCLInitDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(HCLInitDialog.this, "HCL Initialization Dialog");
                    HCLInitDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
            HCLInitDialog.this.dispose();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            HCLInitDialog.this.okButton.setEnabled(HCLInitDialog.this.genes_box.isSelected() || HCLInitDialog.this.cluster_box.isSelected());
        }

        public void windowClosing(WindowEvent windowEvent) {
            HCLInitDialog.this.result = -1;
            HCLInitDialog.this.dispose();
        }
    }
}

