/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCASelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PlotVectorViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.ValuesViewer;
import org.tigr.util.FloatMatrix;

public class PCAGUI
implements IClusterGUI {
    private int mode;
    private FloatMatrix T;
    private FloatMatrix V;
    private FloatMatrix S;
    private FloatMatrix U;
    private Algorithm algorithm;
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Listener listener = new Listener();
        try {
            PCASelectionDialog pCASelectionDialog = new PCASelectionDialog(iFramework.getFrame());
            if (pCASelectionDialog.showModal() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                return defaultMutableTreeNode;
            }
            this.mode = pCASelectionDialog.isClusterGenesSelected() ? 1 : 3;
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("PCA");
            this.algorithm.addAlgorithmListener(listener);
            this.logger = new Logger(iFramework.getFrame(), "PCA Log Window", listener);
            this.logger.show();
            this.logger.append("Starting SVD calculation\n");
            AlgorithmData algorithmData = new AlgorithmData();
            Experiment experiment = iFramework.getData().getExperiment();
            algorithmData.addMatrix("experiment", experiment.getMatrix());
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n = iDistanceMenu.getDistanceFunction();
            if (n == 0) {
                n = 3;
            }
            algorithmData.addParam("distance-function", String.valueOf(n));
            algorithmData.addParam("pca-mode", String.valueOf(this.mode));
            AlgorithmData algorithmData2 = null;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            long l = System.currentTimeMillis();
            switch (this.mode) {
                case 1: {
                    algorithmData.addParam("distance-function", String.valueOf(n));
                    algorithmData2 = this.algorithm.execute(algorithmData);
                    this.T = algorithmData2.getMatrix("T");
                    this.V = algorithmData2.getMatrix("V");
                    this.S = algorithmData2.getMatrix("S");
                    this.U = algorithmData2.getMatrix("U");
                    defaultMutableTreeNode = new DefaultMutableTreeNode("PCA - genes");
                    break;
                }
                case 3: {
                    algorithmData2 = this.algorithm.execute(algorithmData);
                    this.T = algorithmData2.getMatrix("T");
                    this.V = algorithmData2.getMatrix("V");
                    this.S = algorithmData2.getMatrix("S");
                    this.U = algorithmData2.getMatrix("U");
                    defaultMutableTreeNode = new DefaultMutableTreeNode("PCA - experiments");
                    break;
                }
            }
            this.logger.append("Creation the result viewers");
            long l2 = System.currentTimeMillis() - l;
            this.addResultNodes(iFramework.getFrame(), defaultMutableTreeNode, l2, iDistanceMenu.getFunctionName(n), experiment);
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            return defaultMutableTreeNode2;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(listener);
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    private void addResultNodes(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, long l, String string, Experiment experiment) {
        this.add3DViewNode(frame, defaultMutableTreeNode, experiment);
        this.addPCPlotsNode(defaultMutableTreeNode);
        this.addPCInfoNode(defaultMutableTreeNode);
        this.addEigenNode(defaultMutableTreeNode);
        this.addGeneralInfoNode(defaultMutableTreeNode, l, string);
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        if (this.U == null || this.U.getColumnDimension() < 3) {
            return;
        }
        PCA3DViewer pCA3DViewer = this.mode == 1 ? new PCA3DViewer(frame, this.mode, this.U, experiment, true) : new PCA3DViewer(frame, this.mode, this.U, experiment, false);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view", (IViewer)pCA3DViewer, pCA3DViewer.getJPopupMenu())));
    }

    private void addPCPlotsNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.S == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("PC Plots");
        PlotVectorViewer plotVectorViewer = new PlotVectorViewer(this.T);
        for (int i = 0; i < this.S.getRowDimension(); ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Component " + (i + 1), (IViewer)plotVectorViewer, new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addPCInfoNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.S == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("PC Information");
        PCInfoViewer pCInfoViewer = new PCInfoViewer(this.T);
        for (int i = 0; i < this.S.getRowDimension(); ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Component " + (i + 1), (IViewer)pCInfoViewer, new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addEigenNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Eigenvalues");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Plot", new PlotViewer(this.S))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Values", new ValuesViewer(this.S))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addGeneralInfoNode(DefaultMutableTreeNode defaultMutableTreeNode, long l, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        if (this.S != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Components: " + this.S.getColumnDimension()));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(l) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(string));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            PCAGUI.this.logger.append(algorithmEvent.getDescription());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                PCAGUI.this.algorithm.abort();
                PCAGUI.this.logger.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            PCAGUI.this.algorithm.abort();
            PCAGUI.this.logger.dispose();
        }
    }
}

