/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class PCInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private JLabel headerLabel;
    private FloatMatrix T;
    private DecimalFormat format;

    public PCInfoViewer(FloatMatrix floatMatrix) {
        this.T = floatMatrix;
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(5);
        this.format.setMinimumFractionDigits(5);
        this.format.setGroupingUsed(false);
        this.headerLabel = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Eigenvector</b></font></body></html>");
        this.header = this.createHeader(this.headerLabel);
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    public void onSelected(IFramework iFramework) {
        Object object = iFramework.getUserObject();
        this.updateViewer((Integer)object);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader(JLabel jLabel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent() {
        JTextArea jTextArea = new JTextArea(this.T.getRowDimension(), 20);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        jTextArea.setEditable(false);
        return jTextArea;
    }

    private void updateViewer(int n) {
        this.headerLabel.setText("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Eigenvector " + String.valueOf(n + 1) + "</b></font></body></html>");
        this.content.setText("");
        int n2 = this.T.getRowDimension();
        StringBuffer stringBuffer = new StringBuffer(n2 * 10);
        for (int i = 0; i < n2; ++i) {
            float f = this.T.get(i, n);
            if (Float.isNaN(f)) {
                stringBuffer.append(String.valueOf(Float.NaN) + "\n");
                continue;
            }
            stringBuffer.append(this.format.format(f) + "\n");
        }
        this.content.setText(stringBuffer.toString());
        this.content.setCaretPosition(0);
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

