/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.qtc;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.qtc.QTCInitDialog;
import org.tigr.util.FloatMatrix;

public class QTCGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        int n = 5;
        float f = 0.2f;
        boolean bl = false;
        boolean bl2 = true;
        QTCInitDialog qTCInitDialog = new QTCInitDialog((JFrame)iFramework.getFrame(), bl2);
        qTCInitDialog.setVisible(true);
        if (!qTCInitDialog.isOkPressed()) {
            return null;
        }
        this.clusterGenes = qTCInitDialog.isClusterGenesSelected();
        n = Integer.parseInt(qTCInitDialog.clusterTextField.getText());
        f = Float.parseFloat(qTCInitDialog.diameterTextField.getText());
        bl = qTCInitDialog.useAbsoluteCheckBox.isSelected();
        boolean bl3 = qTCInitDialog.isHCLSelected();
        int n2 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl3) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n2 = ((HCLInitDialog)object).getMethod();
            bl4 = ((HCLInitDialog)object).isClusterExperience();
            bl5 = ((HCLInitDialog)object).isClusterGenes();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("QTC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            int n3 = this.experiment.getNumberOfGenes();
            AlgorithmData algorithmData = new AlgorithmData();
            FloatMatrix floatMatrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                floatMatrix = floatMatrix.transpose();
            }
            algorithmData.addMatrix("experiment", floatMatrix);
            algorithmData.addParam("hjc-cluster-genes", String.valueOf(this.clusterGenes));
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("use-absolute", String.valueOf(bl));
            int n4 = iDistanceMenu.getDistanceFunction();
            if (n4 == 0) {
                n4 = 1;
            }
            algorithmData.addParam("distance-function", String.valueOf(n4));
            algorithmData.addParam("min-cluster-size", String.valueOf(n));
            algorithmData.addParam("diameter", String.valueOf(f));
            if (bl3) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n2));
                algorithmData.addParam("calculate-genes", String.valueOf(bl5));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            if (algorithmParameters.getBoolean("aborted")) {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                return defaultMutableTreeNode;
            }
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            int n5 = algorithmParameters.getInt("number-of-clusters");
            this.clusters = new int[n5][];
            for (int i = 0; i < n5; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.clusters = n5;
            generalInfo.minClustSize = n;
            generalInfo.diameter = f;
            generalInfo.useAbsolute = bl;
            generalInfo.time = l2;
            generalInfo.function = iDistanceMenu.getFunctionName(n4);
            generalInfo.hcl = bl3;
            generalInfo.hcl_genes = bl5;
            generalInfo.hcl_samples = bl4;
            generalInfo.hcl_method = n2;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
        }
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("QTC - genes") : new DefaultMutableTreeNode("QTC - experiments");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        JPanel jPanel = this.clusterGenes ? new QTCExperimentViewer(this.experiment, this.clusters) : new QTCExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length - 1; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)((Object)jPanel), new Integer(i))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", (IViewer)((Object)jPanel), new Integer(this.clusters.length - 1))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)((Object)jPanel), new Integer(this.clusters.length - 1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        int n2 = this.clusters.length;
        if (!this.clusterGenes) {
            object = new int[n2][];
            for (n = 0; n < n2; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < nodeList.getSize() - 1; ++n) {
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, null))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, (int[][])object), new Integer(nodeList.getSize() - 1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new QTCInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new QTCInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            QTCCentroidViewer qTCCentroidViewer = new QTCCentroidViewer(this.experiment, this.clusters);
            qTCCentroidViewer.setMeans(this.means.A);
            qTCCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCCentroidViewer, new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)qTCCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)qTCCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 1))));
            QTCCentroidsViewer qTCCentroidsViewer = new QTCCentroidsViewer(this.experiment, this.clusters);
            qTCCentroidsViewer.setMeans(this.means.A);
            qTCCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCCentroidsViewer, new Integer(1))));
        } else {
            QTCExperimentCentroidViewer qTCExperimentCentroidViewer = new QTCExperimentCentroidViewer(this.experiment, this.clusters);
            qTCExperimentCentroidViewer.setMeans(this.means.A);
            qTCExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)qTCExperimentCentroidViewer, new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)qTCExperimentCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)qTCExperimentCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 1))));
            QTCExperimentCentroidsViewer qTCExperimentCentroidsViewer = new QTCExperimentCentroidsViewer(this.experiment, this.clusters);
            qTCExperimentCentroidsViewer.setMeans(this.means.A);
            qTCExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)qTCExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(generalInfo.clusters - 1)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Diameter: " + String.valueOf(generalInfo.diameter)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Minimum cluster size: " + String.valueOf(generalInfo.minClustSize)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Absolute distance: " + String.valueOf(generalInfo.useAbsolute)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public String function;
        public int minClustSize;
        public float diameter;
        public boolean useAbsolute;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                QTCGUI.this.algorithm.abort();
                this.cleanUp();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            QTCGUI.this.algorithm.abort();
            this.cleanUp();
        }

        public void cleanUp() {
        }
    }
}

