/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNElementSeedInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNSubnetInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetComparator;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelevanceNetworkLayout;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelevanceNetworkViewer;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntSorter;
import org.tigr.util.FloatMatrix;

public class RNGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    private FloatMatrix means;
    private FloatMatrix variances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        RelNetInitDialog relNetInitDialog = new RelNetInitDialog(iFramework.getFrame());
        if (relNetInitDialog.showModal() != 0) {
            return null;
        }
        boolean bl = relNetInitDialog.usePermutation();
        float f = relNetInitDialog.getMinThreshold();
        float f2 = relNetInitDialog.getMaxThreshold();
        boolean bl2 = relNetInitDialog.useEntropy();
        float f3 = bl2 ? relNetInitDialog.getEntropy() : 100.0f;
        boolean bl3 = relNetInitDialog.isClusterGenes();
        Listener listener = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("RN");
            this.algorithm.addAlgorithmListener(listener);
            this.progress = new Progress(iFramework.getFrame(), "Calculating Relevance Network", listener);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            Experiment experiment = iFramework.getData().getExperiment();
            algorithmData.addMatrix("experiment", bl3 ? experiment.getMatrix() : experiment.getMatrix().transpose());
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(true));
            int n = 1;
            algorithmData.addParam("distance-function", String.valueOf(n));
            algorithmData.addParam("use-permutation", String.valueOf(bl));
            algorithmData.addParam("min-threshold", String.valueOf(f));
            algorithmData.addParam("max-threshold", String.valueOf(f2));
            algorithmData.addParam("filter-by-entropy", String.valueOf(bl2));
            algorithmData.addParam("top-n-percent", String.valueOf(f3));
            algorithmData.addParam("threshold", String.valueOf(f));
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            int[][] nArray = this.convert2int(algorithmData2.getCluster("cluster"));
            float[][] fArray = this.convert2float(algorithmData2.getCluster("weights"));
            this.means = algorithmData2.getMatrix("means");
            this.variances = algorithmData2.getMatrix("variances");
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            algorithmData2 = null;
            int[] nArray2 = this.getSortedIndices(nArray);
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.time = l2;
            generalInfo.links = algorithmParameters.getInt("links", 0);
            generalInfo.min_threshold = algorithmParameters.getFloat("min_threshold");
            generalInfo.max_threshold = f2;
            generalInfo.entropy = f3;
            generalInfo.function = iDistanceMenu.getFunctionName(n);
            generalInfo.absolute = true;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, nArray, fArray, nArray2, generalInfo, bl3);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private int[][] convert2int(Cluster cluster) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        int n = nodeList.getSize();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = nodeList.getNode(i).getFeaturesIndexes();
            if (nArrayArray[i] != null) continue;
            throw new AlgorithmException("Cluster " + i + " does not contain indices.");
        }
        return nArrayArray;
    }

    private static float[] int2float(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Float.intBitsToFloat(nArray[i]);
        }
        return fArray;
    }

    private float[][] convert2float(Cluster cluster) {
        if (cluster == null) {
            return null;
        }
        NodeList nodeList = cluster.getNodeList();
        float[][] fArrayArray = new float[nodeList.getSize()][];
        for (int i = 0; i < nodeList.getSize(); ++i) {
            fArrayArray[i] = RNGUI.int2float(nodeList.getNode(i).getFeaturesIndexes());
        }
        return fArrayArray;
    }

    private int[] getSortedIndices(int[][] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = nArray2.length;
        while (--n >= 0) {
            nArray2[n] = n;
        }
        IntSorter.sort(nArray2, new RelNetComparator(nArray));
        return nArray2;
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, int[][] nArray, float[][] fArray, int[] nArray2, GeneralInfo generalInfo, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("RelNet");
        this.addResultNodes(defaultMutableTreeNode, experiment, nArray, fArray, nArray2, generalInfo, bl);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, float[][] fArray, int[] nArray2, GeneralInfo generalInfo, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Element Seed Clusters");
        this.addExpressionImages(defaultMutableTreeNode2, experiment, nArray, nArray2, bl);
        this.addCentroidViews(defaultMutableTreeNode2, experiment, nArray, nArray2, bl);
        this.addElementClusterInfo(defaultMutableTreeNode2, experiment, nArray, nArray2, bl);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Subnets");
        this.addSubnets(defaultMutableTreeNode3, experiment, nArray, bl);
        this.addRelevanceNetworkViewer(defaultMutableTreeNode, experiment, nArray, fArray, nArray2, bl);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addElementClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, int[] nArray2, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (bl) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new RNElementSeedInfoViewer(nArray, experiment, nArray2, experiment.getNumberOfGenes(), true))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new RNElementSeedInfoViewer(nArray, experiment, nArray2, experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addSubnetClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, int[] nArray2, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (bl) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Subnets (#,%)", new RNSubnetInfoViewer(nArray, nArray2, experiment.getNumberOfGenes(), true))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Subnets (#,%)", new RNSubnetInfoViewer(nArray, nArray2, experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, int[] nArray2, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        JPanel jPanel = bl ? new RelNetExperimentViewer(experiment, nArray) : new RelNetExperimentClusterViewer(experiment, nArray);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[nArray2[i]].length <= 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(experiment.getGeneIndexMappedToData(nArray[i][0]) + 1) + " (" + nArray[nArray2[i]].length + ")", (IViewer)((Object)jPanel), new Integer(nArray2[i]))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, int[] nArray2, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (bl) {
            RNCentroidViewer rNCentroidViewer = new RNCentroidViewer(experiment, nArray);
            rNCentroidViewer.setMeans(this.means.A);
            rNCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[nArray2[i]].length <= 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(experiment.getGeneIndexMappedToData(nArray[i][0]) + 1) + " (" + nArray[nArray2[i]].length + ")", (IViewer)rNCentroidViewer, new CentroidUserObject(nArray2[i], 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(experiment.getGeneIndexMappedToData(nArray[i][0]) + 1) + " (" + nArray[nArray2[i]].length + ")", (IViewer)rNCentroidViewer, new CentroidUserObject(nArray2[i], 1))));
            }
        } else {
            RNExperimentCentroidViewer rNExperimentCentroidViewer = new RNExperimentCentroidViewer(experiment, nArray);
            rNExperimentCentroidViewer.setMeans(this.means.A);
            rNExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[nArray2[i]].length <= 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(nArray2[i] + 1) + " (" + nArray[nArray2[i]].length + ")", (IViewer)rNExperimentCentroidViewer, new CentroidUserObject(nArray2[i], 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(nArray2[i] + 1) + " (" + nArray[nArray2[i]].length + ")", (IViewer)rNExperimentCentroidViewer, new CentroidUserObject(nArray2[i], 1))));
            }
            RNExperimentCentroidsViewer rNExperimentCentroidsViewer = new RNExperimentCentroidsViewer(experiment, nArray);
            rNExperimentCentroidsViewer.setMeans(this.means.A);
            rNExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)rNExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)rNExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addSubnets(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        RelevanceNetworkLayout relevanceNetworkLayout = new RelevanceNetworkLayout();
        int[][] nArray2 = relevanceNetworkLayout.formRelevanceNetworks(nArray);
        int[] nArray3 = this.getSortedIndices(nArray2);
        JPanel jPanel = bl ? new RelNetExperimentViewer(experiment, nArray2) : new RelNetExperimentClusterViewer(experiment, nArray2);
        for (int i = 0; i < nArray2.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1) + " (" + nArray2[nArray3[i]].length + ")", (IViewer)((Object)jPanel), new Integer(nArray3[i]))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addSubnetCentroidViews(defaultMutableTreeNode, experiment, nArray2, nArray3, bl);
        this.addSubnetClusterInfo(defaultMutableTreeNode, experiment, nArray2, nArray3, bl);
    }

    private void addSubnetCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, int[] nArray2, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        FloatMatrix floatMatrix = this.getMeans(nArray, experiment, bl);
        FloatMatrix floatMatrix2 = this.getVariances(floatMatrix, experiment, nArray, bl);
        if (bl) {
            RNCentroidViewer rNCentroidViewer = new RNCentroidViewer(experiment, nArray);
            rNCentroidViewer.setMeans(floatMatrix.A);
            rNCentroidViewer.setVariances(floatMatrix2.A);
            for (int i = 0; i < nArray.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)rNCentroidViewer, new CentroidUserObject(nArray2[i], 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)rNCentroidViewer, new CentroidUserObject(nArray2[i], 1))));
            }
            RNCentroidsViewer rNCentroidsViewer = new RNCentroidsViewer(experiment, nArray);
            rNCentroidsViewer.setMeans(floatMatrix.A);
            rNCentroidsViewer.setVariances(floatMatrix2.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)rNCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)rNCentroidsViewer, new Integer(1))));
        } else {
            RNExperimentCentroidViewer rNExperimentCentroidViewer = new RNExperimentCentroidViewer(experiment, nArray);
            rNExperimentCentroidViewer.setMeans(floatMatrix.A);
            rNExperimentCentroidViewer.setVariances(floatMatrix2.A);
            for (int i = 0; i < nArray.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)rNExperimentCentroidViewer, new CentroidUserObject(nArray2[i], 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)rNExperimentCentroidViewer, new CentroidUserObject(nArray2[i], 1))));
            }
            RNExperimentCentroidsViewer rNExperimentCentroidsViewer = new RNExperimentCentroidsViewer(experiment, nArray);
            rNExperimentCentroidsViewer.setMeans(floatMatrix.A);
            rNExperimentCentroidsViewer.setVariances(floatMatrix2.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)rNExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)rNExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private FloatMatrix getMeans(int[][] nArray, Experiment experiment, boolean bl) {
        FloatMatrix floatMatrix = experiment.getMatrix();
        if (!bl) {
            floatMatrix = floatMatrix.transpose();
        }
        int n = floatMatrix.getColumnDimension();
        int n2 = floatMatrix.getRowDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, n);
        float f = 0.0f;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            float[] fArray = new float[n];
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < nArray[i].length; ++k) {
                    n4 = nArray[i][k];
                    float f2 = floatMatrix.get(n4, j);
                    if (Float.isNaN(f2)) continue;
                    ++n3;
                    f += f2;
                }
                fArray[j] = n3 > 0 ? f / (float)n3 : 0.0f;
                n3 = 0;
                f = 0.0f;
            }
            floatMatrix2.A[i] = fArray;
        }
        return floatMatrix2;
    }

    private FloatMatrix getVariances(FloatMatrix floatMatrix, Experiment experiment, int[][] nArray, boolean bl) {
        FloatMatrix floatMatrix2 = experiment.getMatrix();
        if (!bl) {
            floatMatrix2 = floatMatrix2.transpose();
        }
        int n = floatMatrix2.getColumnDimension();
        int n2 = floatMatrix2.getRowDimension();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, n);
        float f = 0.0f;
        float f2 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            float[] fArray = new float[n];
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < nArray[i].length; ++k) {
                    n4 = nArray[i][k];
                    float f3 = floatMatrix2.get(n4, j);
                    if (Float.isNaN(f3)) continue;
                    ++n3;
                    f2 = (float)((double)f2 + Math.pow(f3 - floatMatrix.get(i, j), 2.0));
                }
                fArray[j] = n3 > 1 ? (float)Math.sqrt(f2 / (float)(n3 - 1)) : 0.0f;
                n3 = 0;
                f2 = 0.0f;
            }
            floatMatrix3.A[i] = fArray;
        }
        return floatMatrix3;
    }

    private void addRelevanceNetworkViewer(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, float[][] fArray, int[] nArray2, boolean bl) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Network", new RelevanceNetworkViewer(bl, experiment, nArray, fArray, nArray2))));
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Links: " + String.valueOf(generalInfo.links)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Min Threshold: " + String.valueOf(generalInfo.min_threshold)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Max Threshold: " + String.valueOf(generalInfo.max_threshold)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Highest Entropy Filter: " + String.valueOf(generalInfo.entropy) + " %"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Absolute: " + String.valueOf(generalInfo.absolute)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private class GeneralInfo {
        private long time;
        private int links;
        private float min_threshold;
        private float max_threshold;
        private float entropy;
        private String function;
        private boolean absolute;

        private GeneralInfo() {
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    RNGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    RNGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    RNGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    RNGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                RNGUI.this.algorithm.abort();
                RNGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            RNGUI.this.algorithm.abort();
            RNGUI.this.progress.dispose();
        }
    }
}

