/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetComparator;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntSorter;

public class RelevanceNetworkLayout {
    public static final int RANDOM_LAYOUT = 0;
    public static final int CIRCULAR_LAYOUT = 1;

    public float[][] doLayout(int[][] nArray, float[][] fArray, int n) {
        switch (n) {
            case 0: {
                return this.doRandomLayout(nArray, fArray);
            }
            case 1: {
                return this.doCircularLayout(nArray, fArray);
            }
        }
        return null;
    }

    private float[][] doRandomLayout(int[][] nArray, float[][] fArray) {
        float[][] fArray2 = new float[nArray.length][2];
        Random random = new Random(0L);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i][0] = Math.abs(random.nextFloat());
            fArray2[i][1] = Math.abs(random.nextFloat());
        }
        return fArray2;
    }

    private float[][] doCircularLayout(int[][] nArray, float[][] fArray) {
        float[][] fArray2 = new float[nArray.length][2];
        int[][] nArray2 = this.formRelevanceNetworks(nArray);
        int[] nArray3 = new int[nArray2.length];
        int n = nArray3.length;
        while (--n >= 0) {
            nArray3[n] = n;
        }
        IntSorter.sort(nArray3, new RelNetComparator(nArray2));
        n = (int)Math.ceil(Math.sqrt(nArray2.length));
        int n2 = (int)Math.ceil((float)nArray2.length / (float)n);
        for (int i = 0; i < n2; ++i) {
            int n3;
            for (int j = 0; j < n && (n3 = i * n + j) < nArray2.length; ++j) {
                this.arrangeGraph(nArray2[nArray3[n3]], fArray2, j, i);
            }
        }
        this.normalize(fArray2, nArray);
        return fArray2;
    }

    private void arrangeGraph(int[] nArray, float[][] fArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            fArray[nArray[i]][0] = (float)(Math.cos(Math.PI * 2 * (double)i / (double)nArray.length) + 2.5 * (double)(n + 1) - 1.5);
            fArray[nArray[i]][1] = (float)(Math.sin(Math.PI * 2 * (double)i / (double)nArray.length) + 2.5 * (double)(n2 + 1) - 1.5);
        }
    }

    private void normalize(float[][] fArray, int[][] nArray) {
        int n;
        int n2;
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2].length <= 1) continue;
            for (n = 0; n < nArray[n2].length; ++n) {
                f2 = Math.min(f2, fArray[nArray[n2][n]][0]);
                f3 = Math.min(f3, fArray[nArray[n2][n]][1]);
            }
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray[n2][0] = fArray[n2][0] - f2;
            fArray[n2][1] = fArray[n2][1] - f3;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2].length <= 1) continue;
            for (n = 0; n < nArray[n2].length; ++n) {
                f = Math.max(f, Math.max(fArray[nArray[n2][n]][0], fArray[nArray[n2][n]][1]));
            }
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray[n2][0] = fArray[n2][0] / f;
            fArray[n2][1] = fArray[n2][1] / f;
        }
    }

    public int[][] formRelevanceNetworks(int[][] nArray) {
        int n;
        int n2 = nArray.length;
        boolean[] blArray = new boolean[n2];
        Arrays.fill(blArray, false);
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            arrayList.add(this.fillSubnet(new ArrayList(), n, blArray, nArray));
        }
        n = arrayList.size();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (((ArrayList)arrayList.get(i)).size() <= 1) continue;
            ++n3;
        }
        int[][] nArrayArray = new int[n3][];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            if (arrayList2.size() <= 1) continue;
            nArrayArray[n4] = new int[arrayList2.size()];
            for (int j = 0; j < nArrayArray[n4].length; ++j) {
                nArrayArray[n4][j] = (Integer)arrayList2.get(j);
            }
            ++n4;
        }
        return nArrayArray;
    }

    private ArrayList fillSubnet(ArrayList arrayList, int n, boolean[] blArray, int[][] nArray) {
        arrayList.add(new Integer(n));
        blArray[n] = true;
        int[] nArray2 = nArray[n];
        for (int i = 1; i < nArray2.length; ++i) {
            int n2 = nArray2[i];
            if (blArray[n2]) continue;
            this.fillSubnet(arrayList, n2, blArray, nArray);
        }
        return arrayList;
    }
}

