/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.som.UMatrixColorViewer;
import org.tigr.microarray.mev.cluster.gui.impl.som.UMatrixDistanceViewer;
import org.tigr.util.FloatMatrix;

public class SOMGUI
implements IClusterGUI {
    private Experiment experiment;
    private Algorithm algorithm;
    private Progress progress;
    private int[][] clusters;
    private FloatMatrix codes;
    private FloatMatrix u_matrix;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        SOMInitDialog sOMInitDialog = new SOMInitDialog(iFramework.getFrame(), 3, 3, 2000L, 0.05f, 3.0f, 1, 1, 0);
        if (sOMInitDialog.showModal() != 0) {
            return null;
        }
        this.clusterGenes = sOMInitDialog.isClusterGenes();
        boolean bl = sOMInitDialog.isHierarchicalTree();
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n = ((HCLInitDialog)object).getMethod();
            bl2 = ((HCLInitDialog)object).isClusterExperience();
            bl3 = ((HCLInitDialog)object).isClusterGenes();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new GeneralInfo();
        ((GeneralInfo)object).alpha = sOMInitDialog.getAlpha();
        ((GeneralInfo)object).radius = sOMInitDialog.getRadius();
        ((GeneralInfo)object).dimension = this.clusterGenes ? this.experiment.getNumberOfSamples() : this.experiment.getNumberOfGenes();
        ((GeneralInfo)object).dimension_x = sOMInitDialog.getDimensionX();
        ((GeneralInfo)object).dimension_y = sOMInitDialog.getDimensionY();
        ((GeneralInfo)object).clusters = ((GeneralInfo)object).dimension_x * ((GeneralInfo)object).dimension_y;
        ((GeneralInfo)object).iterations = sOMInitDialog.getIterations();
        ((GeneralInfo)object).neiborhood = sOMInitDialog.getNeighborhood() == 0 ? "bubble" : "gaussian";
        ((GeneralInfo)object).topology = sOMInitDialog.getTopology() == 0 ? "hexagonal" : "rectangular";
        ((GeneralInfo)object).init_type = sOMInitDialog.getInitType() == 0 ? "vector" : "genes";
        ((GeneralInfo)object).hcl = bl;
        ((GeneralInfo)object).hcl_genes = bl3;
        ((GeneralInfo)object).hcl_samples = bl2;
        ((GeneralInfo)object).hcl_method = n;
        Listener listener = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("SOM");
            this.algorithm.addAlgorithmListener(listener);
            this.progress = new Progress(iFramework.getFrame(), "SOM Training", listener);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            FloatMatrix floatMatrix = iFramework.getData().getExperiment().getMatrix();
            if (!this.clusterGenes) {
                floatMatrix = floatMatrix.transpose();
            }
            algorithmData.addMatrix("experiment", floatMatrix);
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n2 = iDistanceMenu.getDistanceFunction();
            if (n2 == 0) {
                n2 = 4;
            }
            ((GeneralInfo)object).function = iDistanceMenu.getFunctionName(n2);
            algorithmData.addParam("distance-function", String.valueOf(n2));
            algorithmData.addParam("dimension-x", String.valueOf(((GeneralInfo)object).dimension_x));
            algorithmData.addParam("dimension-y", String.valueOf(((GeneralInfo)object).dimension_y));
            algorithmData.addParam("iterations", String.valueOf(((GeneralInfo)object).iterations));
            algorithmData.addParam("topology", ((GeneralInfo)object).topology);
            algorithmData.addParam("is_neighborhood_bubble", String.valueOf(((GeneralInfo)object).neiborhood.equals("bubble")));
            algorithmData.addParam("is_random_vector", String.valueOf(((GeneralInfo)object).init_type.equals("vector")));
            algorithmData.addParam("radius", String.valueOf(((GeneralInfo)object).radius));
            algorithmData.addParam("alpha", String.valueOf(((GeneralInfo)object).alpha));
            algorithmData.addParam("som-cluster-genes", String.valueOf(this.clusterGenes));
            if (bl) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n));
                algorithmData.addParam("calculate-genes", String.valueOf(bl3));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl2));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            ((GeneralInfo)object).time = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            this.clusters = new int[nodeList.getSize()][];
            for (int i = 0; i < this.clusters.length; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.codes = algorithmData2.getMatrix("codes");
            this.u_matrix = algorithmData2.getMatrix("u_matrix");
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, (GeneralInfo)object);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("SOM - genes") : new DefaultMutableTreeNode("SOM - experiments");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode, generalInfo);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode, generalInfo);
        this.addSOMViews(defaultMutableTreeNode, generalInfo);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        IViewer iViewer = this.clusterGenes ? new SOMExperimentViewer(this.experiment, this.clusters, this.codes) : new SOMExperimentClusterViewer(this.experiment, this.clusters, "SOM Vector", this.codes);
        for (int i = 0; i < generalInfo.dimension_x; ++i) {
            for (int j = 0; j < generalInfo.dimension_y; ++j) {
                int n = i * generalInfo.dimension_y + j;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1) + " (" + String.valueOf(i + 1) + "," + String.valueOf(j + 1) + ")", iViewer, new Integer(n))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = this.clusters;
        int n2 = nodeList.getSize();
        if (!this.clusterGenes) {
            object = new int[n2][];
            for (n = 0; n < n2; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < nodeList.getSize(); ++n) {
            int n3 = n / generalInfo.dimension_y;
            int n4 = n % generalInfo.dimension_y;
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1) + " (" + String.valueOf(n3 + 1) + "," + String.valueOf(n4 + 1) + ")", this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1) + " (" + String.valueOf(n3 + 1) + "," + String.valueOf(n4 + 1) + ")", this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new SOMInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new SOMInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            SOMCentroidViewer sOMCentroidViewer = new SOMCentroidViewer(this.experiment, this.clusters);
            sOMCentroidViewer.setMeans(this.means.A);
            sOMCentroidViewer.setVariances(this.variances.A);
            sOMCentroidViewer.setCodes(this.codes.A);
            for (int i = 0; i < generalInfo.dimension_x; ++i) {
                for (int j = 0; j < generalInfo.dimension_y; ++j) {
                    int n = i * generalInfo.dimension_y + j;
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1) + " (" + String.valueOf(i + 1) + "," + String.valueOf(j + 1) + ")", (IViewer)sOMCentroidViewer, new CentroidUserObject(n, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1) + " (" + String.valueOf(i + 1) + "," + String.valueOf(j + 1) + ")", (IViewer)sOMCentroidViewer, new CentroidUserObject(n, 1))));
                }
            }
            SOMCentroidsViewer sOMCentroidsViewer = new SOMCentroidsViewer(this.experiment, this.clusters);
            sOMCentroidsViewer.setMeans(this.means.A);
            sOMCentroidsViewer.setVariances(this.variances.A);
            sOMCentroidsViewer.setCodes(this.codes.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOMCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOMCentroidsViewer, new Integer(1))));
        } else {
            SOMExperimentCentroidViewer sOMExperimentCentroidViewer = new SOMExperimentCentroidViewer(this.experiment, this.clusters);
            sOMExperimentCentroidViewer.setMeans(this.means.A);
            sOMExperimentCentroidViewer.setVariances(this.variances.A);
            sOMExperimentCentroidViewer.setCodes(this.codes.A);
            for (int i = 0; i < generalInfo.dimension_x; ++i) {
                for (int j = 0; j < generalInfo.dimension_y; ++j) {
                    int n = i * generalInfo.dimension_y + j;
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1) + " (" + String.valueOf(i + 1) + "," + String.valueOf(j + 1) + ")", (IViewer)sOMExperimentCentroidViewer, new CentroidUserObject(n, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1) + " (" + String.valueOf(i + 1) + "," + String.valueOf(j + 1) + ")", (IViewer)sOMExperimentCentroidViewer, new CentroidUserObject(n, 1))));
                }
            }
            SOMExperimentCentroidsViewer sOMExperimentCentroidsViewer = new SOMExperimentCentroidsViewer(this.experiment, this.clusters);
            sOMExperimentCentroidsViewer.setMeans(this.means.A);
            sOMExperimentCentroidsViewer.setVariances(this.variances.A);
            sOMExperimentCentroidsViewer.setCodes(this.codes.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOMExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)sOMExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addSOMViews(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("SOM Visualization");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("U-Matrix Color", new UMatrixColorViewer(this.clusters, this.u_matrix, generalInfo.dimension_x, generalInfo.dimension_y, generalInfo.topology))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("U-Matrix Distance", new UMatrixDistanceViewer(this.clusters, this.u_matrix, generalInfo.dimension_x, generalInfo.dimension_y, generalInfo.topology))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("clusters: " + String.valueOf(generalInfo.clusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("iterations: " + String.valueOf(generalInfo.iterations)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("dimension: " + String.valueOf(generalInfo.dimension)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("dimension x: " + String.valueOf(generalInfo.dimension_x)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("dimension y: " + String.valueOf(generalInfo.dimension_y)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("topology: " + generalInfo.topology));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("neiborhood: " + generalInfo.neiborhood));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("init type: " + generalInfo.init_type));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("alpha: " + String.valueOf(generalInfo.alpha)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("radius: " + String.valueOf(generalInfo.radius)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long iterations;
        public int dimension;
        public int dimension_x;
        public int dimension_y;
        public String topology;
        public String neiborhood;
        public String init_type;
        public float alpha;
        public float radius;
        public long time;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    SOMGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    SOMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    SOMGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    SOMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                SOMGUI.this.algorithm.abort();
                SOMGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SOMGUI.this.algorithm.abort();
            SOMGUI.this.progress.dispose();
        }
    }
}

