/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.st.HCLSupportViewer;
import org.tigr.microarray.mev.cluster.gui.impl.st.ResampleTreeInitDialog;
import org.tigr.util.FloatMatrix;

public class STGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    boolean drawGeneTree;
    boolean drawExptTree;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        ResampleTreeInitDialog resampleTreeInitDialog = new ResampleTreeInitDialog((JFrame)iFramework.getFrame(), true);
        resampleTreeInitDialog.setVisible(true);
        if (resampleTreeInitDialog.isCancelled()) {
            return null;
        }
        int n = resampleTreeInitDialog.getMethod();
        this.drawGeneTree = resampleTreeInitDialog.drawGeneTreeCheckBox.isSelected();
        this.drawExptTree = resampleTreeInitDialog.drawExptTreeCheckBox.isSelected();
        int n2 = resampleTreeInitDialog.getGeneTreeAnalysisOption();
        int n3 = resampleTreeInitDialog.getExptTreeAnalysisOption();
        int n4 = Integer.parseInt(resampleTreeInitDialog.geneTreeIterationsTextField.getText());
        int n5 = Integer.parseInt(resampleTreeInitDialog.exptTreeIterationsTextField.getText());
        Listener listener = new Listener();
        try {
            Experiment experiment = iFramework.getData().getExperiment();
            AlgorithmFactory algorithmFactory = iFramework.getAlgorithmFactory();
            this.algorithm = algorithmFactory.getAlgorithm("ST");
            this.algorithm.addAlgorithmListener(listener);
            AlgorithmData algorithmData = new AlgorithmData();
            algorithmData.addMatrix("experiment", experiment.getMatrix());
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            int n6 = iDistanceMenu.getDistanceFunction();
            if (n6 == 0) {
                n6 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n6));
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            algorithmData.addParam("method-linkage", String.valueOf(n));
            algorithmData.addParam("geneTreeIterations", String.valueOf(n4));
            algorithmData.addParam("exptTreeIterations", String.valueOf(n5));
            algorithmData.addParam("geneTreeAnalysisOption", String.valueOf(n2));
            algorithmData.addParam("exptTreeAnalysisOption", String.valueOf(n3));
            this.progress = new Progress(iFramework.getFrame(), "", listener);
            this.progress.show();
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = null;
            if (this.drawExptTree) {
                this.progress.setTitle("Resampling by Experiments");
                algorithmData.addParam("drawGeneTree", String.valueOf(false));
                algorithmData.addParam("drawExptTree", String.valueOf(true));
                algorithmData2 = this.algorithm.execute(algorithmData);
                this.validate(algorithmData2);
            }
            AlgorithmData algorithmData3 = null;
            if (this.drawGeneTree) {
                this.progress.setTitle("Resampling by Genes");
                algorithmData.addParam("drawGeneTree", String.valueOf(true));
                algorithmData.addParam("drawExptTree", String.valueOf(false));
                algorithmData3 = this.algorithm.execute(algorithmData);
                this.validate(algorithmData3);
            }
            long l2 = System.currentTimeMillis() - l;
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.time = l2;
            generalInfo.method = n;
            generalInfo.function = iDistanceMenu.getFunctionName(n6);
            if (this.drawGeneTree) {
                generalInfo.drawGeneTree = true;
                generalInfo.geneTreeIterations = n4;
                generalInfo.geneTreeAnalysisOption = n2;
            }
            if (this.drawExptTree) {
                generalInfo.drawExptTree = true;
                generalInfo.exptTreeIterations = n5;
                generalInfo.exptTreeAnalysisOption = n3;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, algorithmData3, algorithmData2, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("orig-child-1-array") == null) {
            throw new AlgorithmException("parameter 'orig-child-1-array' is null");
        }
        if (algorithmData.getIntArray("orig-child-2-array") == null) {
            throw new AlgorithmException("parameter 'orig-child-2-array' is null");
        }
        if (algorithmData.getIntArray("orig-node-order") == null) {
            throw new AlgorithmException("parameter 'orig-node-order' is null");
        }
        if (algorithmData.getMatrix("orig-height") == null) {
            throw new AlgorithmException("parameter 'orig-height' is null");
        }
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, AlgorithmData algorithmData, AlgorithmData algorithmData2, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("ST");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Tree - " + generalInfo.getMethodName(), this.createHCLSupportViewer(experiment, algorithmData, algorithmData2, defaultMutableTreeNode2))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        if (generalInfo.drawGeneTree) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Gene Tree Resampling");
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Resampling method: " + generalInfo.getGeneTreeAnalysisOptionName()));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Iterations: " + generalInfo.geneTreeIterations));
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        if (generalInfo.drawExptTree) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Expt Tree Resampling");
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Resampling method: " + generalInfo.getExptTreeAnalysisOptionName()));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Iterations: " + generalInfo.exptTreeIterations));
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        return defaultMutableTreeNode2;
    }

    private HCLTreeData getHCLTreeData(AlgorithmData algorithmData) {
        if (algorithmData == null) {
            return null;
        }
        HCLTreeData hCLTreeData = new HCLTreeData();
        hCLTreeData.child_1_array = algorithmData.getIntArray("orig-child-1-array");
        hCLTreeData.child_2_array = algorithmData.getIntArray("orig-child-2-array");
        hCLTreeData.node_order = algorithmData.getIntArray("orig-node-order");
        hCLTreeData.height = algorithmData.getMatrix("orig-height").getRowPackedCopy();
        return hCLTreeData;
    }

    private IViewer createHCLSupportViewer(Experiment experiment, AlgorithmData algorithmData, AlgorithmData algorithmData2, DefaultMutableTreeNode defaultMutableTreeNode) {
        return new HCLSupportViewer(experiment, null, this.getHCLTreeData(algorithmData), this.getHCLTreeData(algorithmData2), this.getGeneTreeSupportVector(algorithmData), this.getExptTreeSupportVector(algorithmData2), defaultMutableTreeNode);
    }

    private Vector getGeneTreeSupportVector(AlgorithmData algorithmData) {
        Vector<Float> vector = new Vector<Float>();
        if (this.drawGeneTree) {
            FloatMatrix floatMatrix = algorithmData.getMatrix("geneTreeSupportMatrix");
            for (int i = 0; i < floatMatrix.A[0].length; ++i) {
                vector.add(new Float(floatMatrix.A[0][i]));
            }
        } else {
            vector = null;
        }
        return vector;
    }

    private Vector getExptTreeSupportVector(AlgorithmData algorithmData) {
        Vector<Float> vector = new Vector<Float>();
        if (this.drawExptTree) {
            FloatMatrix floatMatrix = algorithmData.getMatrix("exptTreeSupportMatrix");
            for (int i = 0; i < floatMatrix.A[0].length; ++i) {
                vector.add(new Float(floatMatrix.A[0][i]));
            }
        } else {
            vector = null;
        }
        return vector;
    }

    public static class GeneralInfo {
        public long time;
        public int method;
        public String function;
        public boolean drawGeneTree = false;
        public boolean drawExptTree = false;
        public int geneTreeIterations;
        public int exptTreeIterations;
        public int geneTreeAnalysisOption;
        public int exptTreeAnalysisOption;
        private static String[] methods = new String[]{"average linkage", "complete linkage", "single linkage"};

        public String getGeneTreeAnalysisOptionName() {
            String string;
            switch (this.geneTreeAnalysisOption) {
                case 0: {
                    string = "No Resampling";
                    break;
                }
                case 1: {
                    string = "Bootstrap Experiments";
                    break;
                }
                case 2: {
                    string = "Bootstrap Genes";
                    break;
                }
                case 3: {
                    string = "Jackknife Experiments";
                    break;
                }
                case 4: {
                    string = "Jackknife Genes";
                    break;
                }
                default: {
                    string = "No Resampling";
                }
            }
            return string;
        }

        public String getExptTreeAnalysisOptionName() {
            String string;
            switch (this.exptTreeAnalysisOption) {
                case 0: {
                    string = "No Resampling";
                    break;
                }
                case 1: {
                    string = "Bootstrap Experiments";
                    break;
                }
                case 2: {
                    string = "Bootstrap Genes";
                    break;
                }
                case 3: {
                    string = "Jackknife Experiments";
                    break;
                }
                case 4: {
                    string = "Jackknife Genes";
                    break;
                }
                default: {
                    string = "No Resampling";
                }
            }
            return string;
        }

        public String getMethodName() {
            return GeneralInfo.getMethodName(this.method);
        }

        public static String getMethodName(int n) {
            n = n == -1 ? 2 : n;
            return methods[n];
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    STGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    STGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    STGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    STGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                STGUI.this.algorithm.abort();
                STGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            STGUI.this.algorithm.abort();
            STGUI.this.progress.dispose();
        }
    }
}

