/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class SVMExperimentClusterCentroidViewer
extends ExperimentClusterCentroidViewer {
    private JPopupMenu popup;

    public SVMExperimentClusterCentroidViewer(Experiment experiment, int[][] nArray) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperimentCluster(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                SVMExperimentClusterCentroidViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                SVMExperimentClusterCentroidViewer.this.onSaveClusters();
            } else if (string.equals("set-def-color-cmd")) {
                SVMExperimentClusterCentroidViewer.this.onSetDefaultColor();
            } else if (string.equals("set-y-to-exp-max-cmd")) {
                SVMExperimentClusterCentroidViewer.this.yRangeOption = ExperimentClusterCentroidViewer.USE_EXPERIMENT_MAX;
                SVMExperimentClusterCentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                SVMExperimentClusterCentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                SVMExperimentClusterCentroidViewer.this.repaint();
            } else if (string.equals("set-y-to-cluster-max-cmd")) {
                SVMExperimentClusterCentroidViewer.this.yRangeOption = ExperimentClusterCentroidViewer.USE_CLUSTER_MAX;
                SVMExperimentClusterCentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                SVMExperimentClusterCentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                SVMExperimentClusterCentroidViewer.this.repaint();
            } else if (string.equals("store-cluster-cmd")) {
                SVMExperimentClusterCentroidViewer.this.storeCluster();
            } else if (string.equals("launch-new-session-cmd")) {
                SVMExperimentClusterCentroidViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || SVMExperimentClusterCentroidViewer.this.getCluster() == null || SVMExperimentClusterCentroidViewer.this.getCluster().length == 0) {
                return;
            }
            SVMExperimentClusterCentroidViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

