/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMGUI;

public class SVMInfoViewer
extends ViewerAdapter {
    private JComponent header = this.createHeader();
    private JTextArea content;
    private boolean classifyGenes = true;
    private int svmMode = 0;
    private int numberOfPositives = 0;
    private int numberOfTruePositives = 0;
    private int numberOfFalseNegatives = 0;
    private int numberOfNegatives = 0;
    private int numberOfTrueNegatives = 0;
    private int numberOfFalsePositives = 0;

    public SVMInfoViewer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl, int n12) {
        this.classifyGenes = bl;
        this.svmMode = n12;
        this.content = this.createContent(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
        this.setMaxWidth(this.content, this.header);
    }

    public SVMInfoViewer(int n, int n2, boolean bl, int n3) {
        this.classifyGenes = bl;
        this.svmMode = n3;
        this.content = this.createContent(0, 0, 0, n, 0, 0, n2, 0, 0, 0, 0);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Classification Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        JTextArea jTextArea = new JTextArea(20, 20);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        jTextArea.setEditable(false);
        StringBuffer stringBuffer = new StringBuffer(800);
        if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
            stringBuffer.append("SVM Mode: Training and Classification\n\n");
        } else {
            stringBuffer.append("SVM Mode: Classification using SVM Weight File\n\n");
        }
        if (this.classifyGenes) {
            stringBuffer.append("Total Number of Genes: " + (n4 + n7) + "\n\n");
            stringBuffer.append("Positive Genes\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Genes initially selected as Positive examples: " + n + "\n");
            }
            stringBuffer.append("# of Genes classified as Positive (Total Positives): " + n4 + "\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Genes retained in Positive class (True Positives): " + n5 + "\n");
                stringBuffer.append("# of Genes recruited into Positive class from Negatives (False Negatives): " + n6 + "\n");
                if (n3 > 0) {
                    stringBuffer.append("# of Genes recruited into Positive class from Neutrals: " + n10 + "\n");
                }
            }
            stringBuffer.append("\n");
            stringBuffer.append("Negative Genes\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Genes initially selected as negative examples: " + n2 + "\n");
            }
            stringBuffer.append("# of Genes classified as negative (Total Negatives): " + n7 + "\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Genes retained in negative class (True Negatives): " + n8 + "\n");
                stringBuffer.append("# of Genes recruited into negative class from Positives (False Positives): " + n9 + "\n");
                if (n3 > 0) {
                    stringBuffer.append("# of Genes recruited into Negative class from Neutrals: " + n11 + "\n");
                }
            }
            stringBuffer.append("\n");
            if (n3 != 0) {
                stringBuffer.append("Neutral Genes");
                stringBuffer.append("\n");
                stringBuffer.append("# of Genes initially selected as neutral examples: " + n3 + "\n");
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append("Total Number of Experiments: " + (n4 + n7) + "\n\n");
            stringBuffer.append("Positive Experiments");
            stringBuffer.append("\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Experiments initially selected as positive examples: " + n + "\n");
            }
            stringBuffer.append("# of Experiments classified as positive (Total Positives): " + n4 + "\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Experiments retained in positive class (True Positives): " + n5 + "\n");
                stringBuffer.append("# of Experiments recruited into positive class from Negatives (False Negatives): " + n6 + "\n");
                if (n3 > 0) {
                    stringBuffer.append("# of Experiments recruited into Positive class from Neutrals: " + n10 + "\n");
                }
            }
            stringBuffer.append("\n");
            stringBuffer.append("Negative Experiments");
            stringBuffer.append("\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Experiments initially selected as negative examples: " + n2 + "\n");
            }
            stringBuffer.append("# of Experiments classified as negative (Total Negatives): " + n7 + "\n");
            if (this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("# of Experiments retained in negative class (True Negatives): " + n8 + "\n");
                stringBuffer.append("# of Experiments recruited into negative class from Positives (False Positives): " + n9 + "\n");
                if (n3 > 0) {
                    stringBuffer.append("# of Experiments recruited into Positive class from Neutrals: " + n11 + "\n");
                }
            }
            stringBuffer.append("\n");
            if (n3 != 0 && this.svmMode == SVMGUI.TRAIN_AND_CLASSIFY) {
                stringBuffer.append("Neutral Experiments");
                stringBuffer.append("\n");
                stringBuffer.append("# of Experiments initially selected as neutral examples: " + n3 + "\n");
                stringBuffer.append("\n");
            }
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

