/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class SVMSearchDialog
extends JDialog {
    JTable table;
    String searchStr;
    int numSearchCols;
    int numRows;
    int numCols;
    Vector foundRowIndices;
    ButtonGroup searchButtonGroup;
    private ButtonGroup buttonGroup1;
    private JComboBox jComboBox1;
    private JLabel jLabel2;
    private JCheckBox matchCaseChkBox;
    private JRadioButton selectAllButton;
    private JRadioButton selectIncrButton;
    private JPanel buttonPanel;
    private JButton findButton;
    private JButton findNextButton;
    private JButton closeButton;
    private JPanel geneBarPanel;
    private JLabel geneBarContainerLabel;

    public SVMSearchDialog(Frame frame, JTable jTable, boolean bl) {
        super(frame, bl);
        this.table = jTable;
        this.numRows = jTable.getRowCount();
        this.numCols = jTable.getColumnCount();
        this.numSearchCols = this.numCols - 4;
        this.foundRowIndices = new Vector();
        this.initComponents();
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon("dialog_banner2.gif"));
        this.searchButtonGroup = new ButtonGroup();
        this.searchButtonGroup.add(this.selectAllButton);
        this.searchButtonGroup.add(this.selectIncrButton);
        this.setSize(250, 200);
        this.pack();
        this.jComboBox1.setMaximumRowCount(10);
        this.searchStr = null;
        this.jComboBox1.setEditable(true);
        this.jComboBox1.insertItemAt(new String(""), 0);
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMSearchDialog.this.findNextButton.setEnabled(false);
                SVMSearchDialog.this.runSearch();
                if (SVMSearchDialog.this.foundRowIndices.size() > 0 && SVMSearchDialog.this.selectIncrButton.isSelected()) {
                    SVMSearchDialog.this.findNextButton.setEnabled(true);
                } else {
                    SVMSearchDialog.this.findNextButton.setEnabled(false);
                }
            }
        });
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMSearchDialog.this.findNext();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMSearchDialog.this.foundRowIndices.removeAllElements();
                SVMSearchDialog.this.findNextButton.setEnabled(false);
                SVMSearchDialog.this.selectAllButton.setSelected(true);
                SVMSearchDialog.this.matchCaseChkBox.setSelected(true);
                SVMSearchDialog.this.setVisible(false);
            }
        });
        this.jComboBox1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                SVMSearchDialog.this.findNextButton.setEnabled(false);
                SVMSearchDialog.this.findNextButton.repaint();
                SVMSearchDialog.this.foundRowIndices.removeAllElements();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    private boolean runSearch() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        this.foundRowIndices = new Vector();
        boolean bl = this.selectAllButton.isSelected();
        boolean bl2 = false;
        this.searchStr = (String)this.jComboBox1.getSelectedItem();
        if (this.searchStr == null || this.numSearchCols == 0 || this.searchStr.equals("")) {
            return bl2;
        }
        this.table.clearSelection();
        this.jComboBox1.insertItemAt(this.searchStr, 0);
        if (this.matchCaseChkBox.isSelected()) {
            block0: for (int i = 0; i < this.numRows; ++i) {
                for (int j = 4; j < this.numCols; ++j) {
                    if (((String)this.table.getValueAt(i, j)).indexOf(this.searchStr) == -1) continue;
                    if (bl || !bl2) {
                        this.table.addRowSelectionInterval(i, i);
                        if (bl2) continue block0;
                        this.table.scrollRectToVisible(this.table.getCellRect(i, 0, true));
                        bl2 = true;
                        continue block0;
                    }
                    this.foundRowIndices.add(new Integer(i));
                    continue block0;
                }
            }
        } else {
            String string = this.searchStr.toUpperCase();
            block2: for (int i = 0; i < this.numRows; ++i) {
                for (int j = 4; j < this.numCols; ++j) {
                    if (((String)this.table.getValueAt(i, j)).toUpperCase().indexOf(string) == -1) continue;
                    if (bl || !bl2) {
                        this.table.addRowSelectionInterval(i, i);
                        if (bl2) continue block2;
                        this.table.scrollRectToVisible(this.table.getCellRect(i, 0, true));
                        bl2 = true;
                        continue block2;
                    }
                    this.foundRowIndices.add(new Integer(i));
                    continue block2;
                }
            }
        }
        return bl2;
    }

    public void findNext() {
        if (this.foundRowIndices.isEmpty()) {
            return;
        }
        int n = (Integer)this.foundRowIndices.remove(0);
        this.table.clearSelection();
        this.table.addRowSelectionInterval(n, n);
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
        if (this.foundRowIndices.size() == 0) {
            this.findNextButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.matchCaseChkBox = new JCheckBox();
        this.selectAllButton = new JRadioButton();
        this.selectIncrButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.findButton = new JButton();
        this.findNextButton = new JButton();
        this.closeButton = new JButton();
        this.geneBarPanel = new JPanel();
        this.geneBarContainerLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("SVM Search");
        this.setName("SVM Search");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SVMSearchDialog.this.closeDialog(windowEvent);
            }
        });
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMSearchDialog.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabel2.setText("Find what:");
        this.jLabel2.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.matchCaseChkBox.setText("Match Case");
        this.matchCaseChkBox.setFocusPainted(false);
        this.matchCaseChkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMSearchDialog.this.matchCaseChkBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.matchCaseChkBox, gridBagConstraints);
        this.selectAllButton.setToolTipText("Select all finds at once.");
        this.selectAllButton.setSelected(true);
        this.selectAllButton.setText("Select All Rows Found");
        this.selectAllButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.selectAllButton, gridBagConstraints);
        this.selectIncrButton.setToolTipText("Move throgh finds sequentially.");
        this.selectIncrButton.setText("Select Incrementally");
        this.selectIncrButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.selectIncrButton, gridBagConstraints);
        this.findButton.setText("Find");
        this.buttonPanel.add(this.findButton);
        this.findNextButton.setText("Find Next");
        this.findNextButton.setEnabled(false);
        this.buttonPanel.add(this.findNextButton);
        this.closeButton.setText("Close");
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.geneBarContainerLabel.setToolTipText("The Institute for Genomic Research");
        this.geneBarContainerLabel.setIconTextGap(0);
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon("genebar2.gif"));
        this.geneBarPanel.add(this.geneBarContainerLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.geneBarPanel, gridBagConstraints);
        this.pack();
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        this.foundRowIndices.removeAllElements();
        this.findNextButton.setEnabled(false);
    }

    private void matchCaseChkBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        SVMSearchDialog sVMSearchDialog = new SVMSearchDialog(new Frame(), new JTable(), false);
        sVMSearchDialog.show();
    }
}

