/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.QSort;

public class TStatsTableViewer
extends ViewerAdapter {
    private JComponent header;
    private JComponent content;
    private Experiment experiment;
    private int[][] clusters;
    private boolean sig;
    private int[] rows;
    private String[] fieldNames;
    private JTable tValuesTable;
    private TValuesTableModel tModel;
    private Vector pValues;
    private Vector tValues;
    private Vector dfValues;
    private Vector meansA;
    private Vector meansB;
    private Vector sdA;
    private Vector sdB;
    private IData data;
    private JPopupMenu popup;
    private Object[][] origData;

    public TStatsTableViewer(Experiment experiment, int[][] nArray, IData iData, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Vector vector7, boolean bl) {
        int n;
        this.experiment = experiment;
        this.clusters = nArray;
        this.data = iData;
        this.fieldNames = iData.getFieldNames();
        this.pValues = vector5;
        this.tValues = vector6;
        this.dfValues = vector7;
        this.meansA = vector;
        this.meansB = vector2;
        this.sdA = vector3;
        this.sdB = vector4;
        this.sig = bl;
        this.rows = bl ? nArray[0] : nArray[1];
        this.tModel = new TValuesTableModel();
        this.tValuesTable = new JTable(this.tModel);
        this.origData = new Object[this.tModel.getRowCount()][this.tModel.getColumnCount()];
        for (int i = 0; i < this.origData.length; ++i) {
            for (n = 0; n < this.origData[i].length; ++n) {
                this.origData[i][n] = this.tModel.getValueAt(i, n);
            }
        }
        TableColumn tableColumn = null;
        for (n = 0; n < this.tModel.getColumnCount(); ++n) {
            tableColumn = this.tValuesTable.getColumnModel().getColumn(n);
            tableColumn.setMinWidth(30);
        }
        this.addMouseListenerToHeaderInTable(this.tValuesTable);
        this.header = this.tValuesTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    public JComponent getContentComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.tValuesTable, gridBagConstraints);
        jPanel.add(this.tValuesTable);
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("Data"));
        jFileChooser.setDialogTitle("Save gene t-statistics");
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save Gene t-statistics", GUIFactory.getIcon("save16.gif"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jFileChooser.showSaveDialog(TStatsTableViewer.this.getHeaderComponent());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        int n2;
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        for (n2 = 0; n2 < TStatsTableViewer.this.fieldNames.length; ++n2) {
                            printWriter.print(TStatsTableViewer.this.fieldNames[n2]);
                            if (n2 >= TStatsTableViewer.this.fieldNames.length - 1) continue;
                            printWriter.print("\t");
                        }
                        printWriter.print("\tGroupA mean\tGroupA std.dev.\tGroupB mean\tGroupB std.dev.\tt-ratio\tdf\tp-value\n");
                        for (n2 = 0; n2 < TStatsTableViewer.this.rows.length; ++n2) {
                            for (int i = 0; i < TStatsTableViewer.this.fieldNames.length; ++i) {
                                printWriter.print(TStatsTableViewer.this.data.getElementAttribute(TStatsTableViewer.this.experiment.getGeneIndexMappedToData(TStatsTableViewer.this.rows[n2]), i));
                                if (i >= TStatsTableViewer.this.fieldNames.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.print("\t" + ((Float)TStatsTableViewer.this.meansA.get(TStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)TStatsTableViewer.this.sdA.get(TStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)TStatsTableViewer.this.meansB.get(TStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)TStatsTableViewer.this.sdB.get(TStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\t" + ((Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[n2])).intValue());
                            printWriter.print("\t" + ((Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[n2])).floatValue());
                            printWriter.print("\n");
                        }
                        printWriter.println();
                        printWriter.flush();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.popup.add(jMenuItem);
        this.tValuesTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TStatsTableViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return jPanel;
    }

    public JComponent getHeaderComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.header, gridBagConstraints);
        jPanel.add(this.header);
        return jPanel;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    int n4 = mouseEvent.getModifiers() & 2;
                    boolean bl = n3 == 0;
                    boolean bl2 = n4 != 0;
                    TStatsTableViewer.this.sortByColumn(n2, bl, bl2);
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void sortByColumn(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        if (bl2) {
            for (int i = 0; i < this.tModel.getRowCount(); ++i) {
                for (int j = 0; j < this.tModel.getColumnCount(); ++j) {
                    this.tModel.setValueAt(this.origData[i][j], i, j);
                }
            }
            return;
        }
        Object[][] objectArray = new Object[this.tValuesTable.getRowCount()][this.tValuesTable.getColumnCount()];
        float[] fArray = new float[this.rows.length];
        Object[] objectArray2 = new SortableField[this.rows.length];
        if (n < this.fieldNames.length) {
            for (n4 = 0; n4 < objectArray2.length; ++n4) {
                objectArray2[n4] = new SortableField(n4, n);
            }
            Arrays.sort(objectArray2);
        } else if (n == this.fieldNames.length) {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.meansA.get(this.rows[n4])).floatValue();
            }
        } else if (n == this.fieldNames.length + 1) {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.sdA.get(this.rows[n4])).floatValue();
            }
        } else if (n == this.fieldNames.length + 2) {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.meansB.get(this.rows[n4])).floatValue();
            }
        } else if (n == this.fieldNames.length + 3) {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.sdB.get(this.rows[n4])).floatValue();
            }
        } else if (n == this.fieldNames.length + 4) {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.tValues.get(this.rows[n4])).floatValue();
            }
        } else if (n == this.fieldNames.length + 5) {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.dfValues.get(this.rows[n4])).floatValue();
            }
        } else if (n == this.fieldNames.length + 6) {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.pValues.get(this.rows[n4])).floatValue();
            }
        }
        int[] nArray = new int[this.rows.length];
        if (n >= this.fieldNames.length) {
            QSort qSort = new QSort(fArray);
            nArray = qSort.getOrigIndx();
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((SortableField)objectArray2[i]).getIndex();
            }
        }
        if (!bl) {
            nArray = this.reverse(nArray);
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            for (n2 = 0; n2 < objectArray[n3].length; ++n2) {
                objectArray[n3][n2] = this.origData[nArray[n3]][n2];
            }
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            for (n2 = 0; n2 < objectArray[n3].length; ++n2) {
                this.tModel.setValueAt(objectArray[n3][n2], n3, n2);
            }
        }
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int n, int n2) {
            this.index = n;
            this.field = (String)TStatsTableViewer.this.origData[n][n2];
        }

        public int compareTo(Object object) {
            SortableField sortableField = (SortableField)object;
            return this.field.compareTo(sortableField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class TValuesTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;

        public TValuesTableModel() {
            this.columnNames = new String[TStatsTableViewer.this.fieldNames.length + 7];
            for (int i = 0; i < TStatsTableViewer.this.fieldNames.length; ++i) {
                this.columnNames[i] = TStatsTableViewer.this.fieldNames[i];
            }
            this.columnNames[i] = "GroupA mean";
            this.columnNames[i + 1] = "GroupA std.dev";
            this.columnNames[i + 2] = "GroupB mean";
            this.columnNames[i + 3] = "GroupB std.dev.";
            this.columnNames[i + 4] = "t-ratio";
            this.columnNames[i + 5] = "df";
            this.columnNames[i + 6] = "p-value";
            this.tableData = new Object[TStatsTableViewer.this.rows.length][this.columnNames.length];
            for (int i = 0; i < this.tableData.length; ++i) {
                for (int j = 0; j < this.tableData[i].length; ++j) {
                    float f;
                    if (j < TStatsTableViewer.this.fieldNames.length) {
                        this.tableData[i][j] = TStatsTableViewer.this.data.getElementAttribute(TStatsTableViewer.this.experiment.getGeneIndexMappedToData(TStatsTableViewer.this.rows[i]), j);
                        continue;
                    }
                    if (j == TStatsTableViewer.this.fieldNames.length) {
                        f = ((Float)TStatsTableViewer.this.meansA.get(TStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)TStatsTableViewer.this.meansA.get(TStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == TStatsTableViewer.this.fieldNames.length + 1) {
                        f = ((Float)TStatsTableViewer.this.sdA.get(TStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)TStatsTableViewer.this.sdA.get(TStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == TStatsTableViewer.this.fieldNames.length + 2) {
                        f = ((Float)TStatsTableViewer.this.meansB.get(TStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)TStatsTableViewer.this.meansB.get(TStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == TStatsTableViewer.this.fieldNames.length + 3) {
                        f = ((Float)TStatsTableViewer.this.sdB.get(TStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)TStatsTableViewer.this.sdB.get(TStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == TStatsTableViewer.this.fieldNames.length + 4) {
                        f = ((Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == TStatsTableViewer.this.fieldNames.length + 5) {
                        f = ((Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j != TStatsTableViewer.this.fieldNames.length + 6) continue;
                    f = ((Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                    this.tableData[i][j] = Float.isNaN(f) ? "N/A" : (Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[i]);
                }
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.tableData.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.tableData[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.tableData[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

