/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class TTestVolcanoPlotViewer
extends JPanel
implements IViewer {
    private double[] yArray;
    private double[] xArray;
    private boolean[] isSig;
    int originX;
    int originY;
    int currentMouseX;
    int currentMouseY;
    private boolean useRefLines;
    private JPopupMenu popup;
    private JCheckBoxMenuItem useRefLinesBox;

    public TTestVolcanoPlotViewer(double[] dArray, double[] dArray2, boolean[] blArray) {
        this.xArray = dArray;
        this.yArray = dArray2;
        this.isSig = blArray;
        this.useRefLines = true;
        this.currentMouseX = 0;
        this.currentMouseY = 0;
        this.setBorder(new EtchedBorder());
        this.setBackground(Color.white);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (TTestVolcanoPlotViewer.this.useRefLines) {
                    TTestVolcanoPlotViewer.this.currentMouseX = mouseEvent.getX();
                    TTestVolcanoPlotViewer.this.currentMouseY = mouseEvent.getY();
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.popup = new JPopupMenu();
        this.useRefLinesBox = new JCheckBoxMenuItem("Use reference lines", true);
        this.useRefLinesBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TTestVolcanoPlotViewer.this.useRefLines = true;
                } else {
                    TTestVolcanoPlotViewer.this.useRefLines = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }
        });
        this.popup.add(this.useRefLinesBox);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TTestVolcanoPlotViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(40, 10, this.getWidth() - 10, 10);
        graphics2D.drawLine(this.getWidth() - 10, 10, this.getWidth() - 10, this.getHeight() - 50);
        this.originX = (int)Math.round((double)(this.getWidth() / 2));
        this.originY = (int)Math.round((double)(this.getHeight() - 50));
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(40, (int)Math.round((double)(this.getHeight() - 50)), this.getWidth() - 10, (int)Math.round((double)(this.getHeight() - 50)));
        graphics2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 10, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight() - 50);
        graphics2D.drawLine(40, 10, 40, this.getHeight() - 50);
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.useRefLines && this.currentMouseX >= 40 && this.currentMouseX <= this.getWidth() - 10 && this.currentMouseY >= 10 && this.currentMouseY <= this.getHeight() - 50) {
            graphics2D.setColor(Color.magenta);
            graphics2D.drawLine(40, this.currentMouseY, this.getWidth() - 10, this.currentMouseY);
            graphics2D.drawLine(this.currentMouseX, 10, this.currentMouseX, this.getHeight() - 50);
        }
        graphics2D.setColor(Color.black);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawString("-log10(p)", -1 * this.getHeight() / 2, 25);
        graphics2D.rotate(1.5707963267948966);
        double[] dArray = this.getMaxXAndY();
        double[] dArray2 = this.getMinXAndY();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        double d5 = this.getXScalingFactor(d, d3);
        double[] dArray3 = new double[6];
        double d6 = 0.0;
        d6 = Math.abs(d) > Math.abs(d3) ? Math.abs(d / 5.0) : Math.abs(d3 / 5.0);
        double d7 = 0.0;
        for (n3 = 0; n3 < dArray3.length; ++n3) {
            dArray3[n3] = d7;
            d7 += d6;
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        for (n3 = 1; n3 < dArray3.length; ++n3) {
            graphics2D.drawLine((int)Math.round(dArray3[n3] * d5) + this.getWidth() / 2, this.getHeight() - 50 - 5, (int)Math.round(dArray3[n3] * d5) + this.getWidth() / 2, this.getHeight() - 50 + 5);
        }
        for (n3 = 1; n3 < dArray3.length; ++n3) {
            graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray3[n3] * d5), this.getHeight() - 50 - 5, this.getWidth() / 2 - (int)Math.round(dArray3[n3] * d5), this.getHeight() - 50 + 5);
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        for (n2 = 1; n2 < dArray3.length; ++n2) {
            graphics2D.drawString(decimalFormat.format(dArray3[n2]), (int)Math.round(dArray3[n2] * d5) + this.getWidth() / 2 - 10, this.getHeight() - 30);
        }
        for (n2 = 1; n2 < dArray3.length; ++n2) {
            graphics2D.drawString("-" + decimalFormat.format(dArray3[n2]), this.getWidth() / 2 - (int)Math.round(dArray3[n2] * d5) - 10, this.getHeight() - 30);
        }
        graphics2D.drawString("Mean(GroupB) - Mean(GroupA)", this.getWidth() / 2 - 85, this.getHeight() - 15);
        n2 = (int)Math.round(d2);
        double d8 = this.getYScalingFactor(d2, d4);
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (int i = 1; i <= n2 && this.getHeight() - 50 - (int)Math.round((double)i * d8) >= 10; ++i) {
            graphics2D.drawLine(40, this.getHeight() - 50 - (int)Math.round((double)i * d8), this.getWidth() - 10, this.getHeight() - 50 - (int)Math.round((double)i * d8));
        }
        graphics2D.setColor(Color.black);
        for (n = 1; n <= n2; ++n) {
            if (this.getHeight() - 50 - (int)Math.round((double)n * d8) < 10) continue;
            graphics2D.drawString(decimalFormat.format(n), 30, this.getHeight() - 50 - (int)Math.round((double)n * d8));
        }
        for (n = 0; n < this.xArray.length; ++n) {
            if (Double.isNaN(this.xArray[n]) || Double.isNaN(this.yArray[n]) || Double.isInfinite(this.xArray[n]) || Double.isInfinite(this.yArray[n])) continue;
            if (this.isSig[n]) {
                graphics2D.setColor(Color.red);
            } else {
                graphics2D.setColor(Color.black);
            }
            this.drawPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 5);
        }
        graphics2D.setColor(Color.black);
    }

    private void drawPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        int n2 = (int)Math.round(d * d3);
        int n3 = (int)Math.round(d2 * d4);
        int n4 = 0;
        int n5 = 0;
        n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
        n5 = (int)Math.round((double)(this.getHeight() - 50)) - n3;
        graphics2D.fillOval(n4, n5, n, n);
    }

    private double[] getMaxXAndY() {
        double[] dArray = new double[2];
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.xArray.length; ++i) {
            if (Double.isInfinite(this.xArray[i]) || Double.isNaN(this.xArray[i]) || Double.isInfinite(this.yArray[i]) || Double.isNaN(this.yArray[i])) continue;
            if (d < this.xArray[i]) {
                d = this.xArray[i];
            }
            if (!(d2 < this.yArray[i])) continue;
            d2 = this.yArray[i];
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    private double[] getMinXAndY() {
        double[] dArray = new double[2];
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.xArray.length; ++i) {
            if (Double.isInfinite(this.xArray[i]) || Double.isNaN(this.xArray[i]) || Double.isInfinite(this.yArray[i]) || Double.isNaN(this.yArray[i])) continue;
            if (d > this.xArray[i]) {
                d = this.xArray[i];
            }
            if (!(d2 > this.yArray[i])) continue;
            d2 = this.yArray[i];
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    private double getXScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = (double)(this.getWidth() / 2 - 50) / d3;
        return d4;
    }

    private double getYScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = (double)(this.getHeight() - 50 - 50) / d3;
        return d4;
    }

    public void showReferenceLines() {
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }
}

