/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TStatsTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TTestVolcanoPlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestInitDialog;
import org.tigr.util.FloatMatrix;

public class TtestGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private Vector tValues;
    private Vector pValues;
    private Vector dfValues;
    private Vector meansA;
    private Vector meansB;
    private Vector sdA;
    private Vector sdB;
    private IData data;
    Vector exptNamesVector;
    int[] groupAssignments;
    boolean isPermutations;
    boolean[] isSig;
    double[] diffMeansBA;
    double[] negLog10PValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        boolean bl;
        this.experiment = iFramework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        this.data = iFramework.getData();
        int n = this.experiment.getNumberOfSamples();
        int n2 = this.experiment.getNumberOfGenes();
        for (int i = 0; i < n; ++i) {
            this.exptNamesVector.add(iFramework.getData().getFullSampleName(i));
        }
        TtestInitDialog ttestInitDialog = new TtestInitDialog((JFrame)iFramework.getFrame(), true, this.exptNamesVector);
        ttestInitDialog.setVisible(true);
        if (!ttestInitDialog.isOkPressed()) {
            return null;
        }
        double d = 0.01;
        try {
            d = ttestInitDialog.getAlphaValue();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Invalid alpha value!", "Error", 0);
            return null;
        }
        this.groupAssignments = ttestInitDialog.getGroupAssignments();
        int n3 = ttestInitDialog.getSignificanceMethod();
        boolean bl2 = ttestInitDialog.isDrawTrees();
        this.isPermutations = bl = ttestInitDialog.isPermut();
        int n4 = ttestInitDialog.getUserNumCombs();
        boolean bl3 = ttestInitDialog.useAllCombs();
        int n5 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl2) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n5 = ((HCLInitDialog)object).getMethod();
            bl4 = ((HCLInitDialog)object).isClusterExperience();
            bl5 = ((HCLInitDialog)object).isClusterGenes();
        }
        object = new Listener();
        try {
            int n6;
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("TTEST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            int n7 = this.experiment.getNumberOfGenes();
            this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", (DialogListener)object);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            algorithmData.addMatrix("experiment", this.experiment.getMatrix());
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n8 = iDistanceMenu.getDistanceFunction();
            if (n8 == 0) {
                n8 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n8));
            algorithmData.addIntArray("group-assignments", this.groupAssignments);
            algorithmData.addParam("alpha", String.valueOf(d));
            algorithmData.addParam("significance-method", String.valueOf(n3));
            algorithmData.addParam("is-permut", String.valueOf(bl));
            algorithmData.addParam("num-combs", String.valueOf(n4));
            algorithmData.addParam("use-all-combs", String.valueOf(bl3));
            if (bl2) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n5));
                algorithmData.addParam("calculate-genes", String.valueOf(bl5));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            int n9 = 2;
            this.clusters = new int[n9][];
            for (int i = 0; i < n9; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            FloatMatrix floatMatrix = algorithmData2.getMatrix("sigPValues");
            FloatMatrix floatMatrix2 = algorithmData2.getMatrix("sigTValues");
            FloatMatrix floatMatrix3 = algorithmData2.getMatrix("nonSigPValues");
            FloatMatrix floatMatrix4 = algorithmData2.getMatrix("nonSigTValues");
            FloatMatrix floatMatrix5 = algorithmData2.getMatrix("pValues");
            FloatMatrix floatMatrix6 = algorithmData2.getMatrix("tValues");
            FloatMatrix floatMatrix7 = algorithmData2.getMatrix("dfValues");
            FloatMatrix floatMatrix8 = algorithmData2.getMatrix("meansAMatrix");
            FloatMatrix floatMatrix9 = algorithmData2.getMatrix("meansBMatrix");
            FloatMatrix floatMatrix10 = algorithmData2.getMatrix("sdAMatrix");
            FloatMatrix floatMatrix11 = algorithmData2.getMatrix("sdBMatrix");
            FloatMatrix floatMatrix12 = algorithmData2.getMatrix("isSigMatrix");
            this.pValues = new Vector();
            this.tValues = new Vector();
            this.dfValues = new Vector();
            this.meansA = new Vector();
            this.meansB = new Vector();
            this.sdA = new Vector();
            this.sdB = new Vector();
            for (n6 = 0; n6 < floatMatrix5.getRowDimension(); ++n6) {
                this.pValues.add(new Float(floatMatrix5.A[n6][0]));
            }
            for (n6 = 0; n6 < floatMatrix6.getRowDimension(); ++n6) {
                this.tValues.add(new Float(floatMatrix6.A[n6][0]));
            }
            for (n6 = 0; n6 < floatMatrix7.getRowDimension(); ++n6) {
                this.dfValues.add(new Float(floatMatrix7.A[n6][0]));
            }
            for (n6 = 0; n6 < floatMatrix8.getRowDimension(); ++n6) {
                this.meansA.add(new Float(floatMatrix8.A[n6][0]));
                this.meansB.add(new Float(floatMatrix9.A[n6][0]));
                this.sdA.add(new Float(floatMatrix10.A[n6][0]));
                this.sdB.add(new Float(floatMatrix11.A[n6][0]));
            }
            this.isSig = new boolean[floatMatrix12.getRowDimension()];
            for (n6 = 0; n6 < this.isSig.length; ++n6) {
                this.isSig[n6] = floatMatrix12.A[n6][0] == 1.0f;
            }
            this.diffMeansBA = new double[floatMatrix12.getRowDimension()];
            for (n6 = 0; n6 < this.diffMeansBA.length; ++n6) {
                this.diffMeansBA[n6] = (double)floatMatrix9.A[n6][0] - (double)floatMatrix8.A[n6][0];
            }
            this.negLog10PValues = new double[floatMatrix12.getRowDimension()];
            double d2 = Math.log(10.0);
            for (int i = 0; i < this.negLog10PValues.length; ++i) {
                double d3 = floatMatrix5.A[i][0];
                this.negLog10PValues[i] = -1.0 * (Math.log(d3) / d2);
            }
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.time = l2;
            generalInfo.alpha = d;
            generalInfo.sigMethod = this.getSigMethod(n3);
            generalInfo.pValueBasedOn = this.getPValueBasedOn(bl);
            if (bl) {
                generalInfo.useAllCombs = bl3;
                generalInfo.numCombs = n4;
            }
            generalInfo.function = iDistanceMenu.getFunctionName(n8);
            generalInfo.hcl = bl2;
            generalInfo.hcl_genes = bl5;
            generalInfo.hcl_samples = bl4;
            generalInfo.hcl_method = n5;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private String getPValueBasedOn(boolean bl) {
        String string = "";
        string = bl ? "permutation" : "t-distribution";
        return string;
    }

    private String getSigMethod(int n) {
        String string = "";
        if (n == 4) {
            string = "Just alpha";
        } else if (n == 5) {
            string = "Standard Bonferroni correction";
        } else if (n == 6) {
            string = "Adjusted Bonferroni correction";
        }
        return string;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("T Tests");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addTStatsViews(defaultMutableTreeNode);
        this.addVolcanoPlot(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        TtestExperimentViewer ttestExperimentViewer = new TtestExperimentViewer(this.experiment, this.clusters, this.meansA, this.meansB, this.sdA, this.sdB, this.pValues, this.tValues, this.dfValues);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)ttestExperimentViewer, new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)ttestExperimentViewer, new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < nodeList.getSize(); ++i) {
            if (i < nodeList.getSize() - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                continue;
            }
            if (i != nodeList.getSize() - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2 = hCLTreeData = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData3 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData, hCLTreeData3);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", new TtestInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        TtestCentroidViewer ttestCentroidViewer = new TtestCentroidViewer(this.experiment, this.clusters, this.meansA, this.meansB, this.sdA, this.sdB, this.pValues, this.tValues, this.dfValues);
        ttestCentroidViewer.setMeans(this.means.A);
        ttestCentroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)ttestCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)ttestCentroidViewer, new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)ttestCentroidViewer, new CentroidUserObject(i, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)ttestCentroidViewer, new CentroidUserObject(i, 1))));
        }
        TtestCentroidsViewer ttestCentroidsViewer = new TtestCentroidsViewer(this.experiment, this.clusters, this.meansA, this.meansB, this.sdA, this.sdB, this.pValues, this.tValues, this.dfValues);
        ttestCentroidsViewer.setMeans(this.means.A);
        ttestCentroidsViewer.setVariances(this.variances.A);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)ttestCentroidsViewer, new Integer(0))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)ttestCentroidsViewer, new Integer(1))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addTStatsViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Gene Statistics");
        TStatsTableViewer tStatsTableViewer = new TStatsTableViewer(this.experiment, this.clusters, this.data, this.meansA, this.meansB, this.sdA, this.sdB, this.pValues, this.tValues, this.dfValues, true);
        TStatsTableViewer tStatsTableViewer2 = new TStatsTableViewer(this.experiment, this.clusters, this.data, this.meansA, this.meansB, this.sdA, this.sdB, this.pValues, this.tValues, this.dfValues, false);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes", tStatsTableViewer)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", tStatsTableViewer2)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addVolcanoPlot(DefaultMutableTreeNode defaultMutableTreeNode) {
        TTestVolcanoPlotViewer tTestVolcanoPlotViewer = new TTestVolcanoPlotViewer(this.diffMeansBA, this.negLog10PValues, this.isSig);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Volcano Plot", tTestVolcanoPlotViewer)));
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(this.getGroupAssignmentInfo());
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + generalInfo.alpha));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("P-values based on: " + generalInfo.pValueBasedOn));
        if (this.isPermutations) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("All permutations used: " + generalInfo.useAllCombs));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of permutations per gene: " + generalInfo.numCombs));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Significance determined by: " + generalInfo.sigMethod));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private DefaultMutableTreeNode getGroupAssignmentInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Group assigments ");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Group A ");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Group B ");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Neither group ");
        int n = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                continue;
            }
            if (this.groupAssignments[i] == 2) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                continue;
            }
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
            ++n;
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        if (n > 0) {
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
        }
        return defaultMutableTreeNode;
    }

    private class GeneralInfo {
        public int clusters;
        public String sigMethod;
        public String pValueBasedOn;
        public double alpha;
        public int numCombs;
        public boolean useAllCombs;
        public long time;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    TtestGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    TtestGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    TtestGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    TtestGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                TtestGUI.this.algorithm.abort();
                TtestGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            TtestGUI.this.algorithm.abort();
            TtestGUI.this.progress.dispose();
        }
    }
}

