/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.GenepixFileParser;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class GenePixFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private GenePixFileLoaderPanel gpflp = new GenePixFileLoaderPanel();
    private boolean loadEnabled = false;

    public GenePixFileLoader(SuperExpressionFileLoader superExpressionFileLoader) {
        super(superExpressionFileLoader);
    }

    public Vector loadExpressionFiles() throws IOException {
        Object[] objectArray = this.gpflp.getGenePixSelectedListModel().toArray();
        if (objectArray == null || objectArray.length < 1) {
            return null;
        }
        Vector<ISlideData> vector = new Vector<ISlideData>();
        ISlideMetaData iSlideMetaData = null;
        this.setFilesCount(objectArray.length);
        this.setRemain(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setFileName(((File)objectArray[i]).getName());
            if (i == 0) {
                vector.add(this.loadSlideData((File)objectArray[i]));
                iSlideMetaData = (ISlideMetaData)vector.elementAt(0);
            } else {
                vector.add(this.loadFloatSlideData((File)objectArray[i], iSlideMetaData));
            }
            this.setFilesProgress(i + 1);
        }
        if (vector != null && vector.size() > 0) {
            String[] stringArray = new String[]{"Name", "ID"};
            TMEV.setFieldNames(stringArray);
        }
        return vector;
    }

    public ISlideData loadSlideData(File file) {
        SlideData slideData = null;
        GenepixFileParser genepixFileParser = new GenepixFileParser(file, false);
        if (genepixFileParser.isCompleted()) {
            Vector vector;
            int n;
            Vector vector2 = genepixFileParser.getTavFile();
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            float[] fArray = new float[2];
            String[] stringArray = new String[2];
            int n2 = vector2.size();
            int n3 = 0;
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                vector = (Vector)vector2.elementAt(n);
                n3 = Math.max(n3, (Integer)vector.elementAt(2));
                n4 = Math.max(n4, (Integer)vector.elementAt(3));
            }
            slideData = new SlideData(n3, n4);
            this.setLinesCount(n2);
            for (n = 0; n < n2; ++n) {
                nArray = new int[3];
                nArray2 = new int[3];
                fArray = new float[2];
                stringArray = new String[2];
                vector = (Vector)vector2.elementAt(n);
                fArray[0] = ((Integer)vector.elementAt(0)).intValue();
                fArray[1] = ((Integer)vector.elementAt(1)).intValue();
                nArray[0] = (Integer)vector.elementAt(2);
                nArray2[0] = (Integer)vector.elementAt(3);
                nArray[1] = 0;
                nArray2[1] = 0;
                nArray[2] = (Integer)vector.elementAt(4);
                nArray2[2] = (Integer)vector.elementAt(5);
                stringArray[0] = (String)vector.elementAt(6);
                stringArray[1] = (String)vector.elementAt(7);
                SlideDataElement slideDataElement = new SlideDataElement(nArray, nArray2, fArray, stringArray);
                slideData.add(slideDataElement);
                this.setFileProgress(n);
            }
            slideData.setSlideDataName(file.getName());
            slideData.setSlideFileName(file.getPath());
        }
        return slideData;
    }

    public ISlideData loadFloatSlideData(File file, ISlideMetaData iSlideMetaData) {
        FloatSlideData floatSlideData = null;
        GenepixFileParser genepixFileParser = new GenepixFileParser(file, false);
        if (genepixFileParser.isCompleted()) {
            floatSlideData = new FloatSlideData(iSlideMetaData);
            Vector vector = genepixFileParser.getTavFile();
            int n = vector.size();
            this.setLinesCount(n);
            for (int i = 0; i < n; ++i) {
                Vector vector2 = (Vector)vector.elementAt(i);
                float f = ((Integer)vector2.elementAt(0)).intValue();
                float f2 = ((Integer)vector2.elementAt(1)).intValue();
                floatSlideData.setIntensities(i, f, f2);
                this.setFileProgress(i);
            }
            floatSlideData.setSlideDataName(file.getName());
            floatSlideData.setSlideFileName(file.getPath());
        }
        return floatSlideData;
    }

    public ISlideData loadExpressionFile(File file) throws IOException {
        return null;
    }

    public Vector loadAnnotationFile(File file) throws IOException {
        return new Vector();
    }

    public FileFilter getFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".gpr");
            }

            public String getDescription() {
                return "GenePix Files (*.gpr)";
            }
        };
        return fileFilter;
    }

    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean bl) {
        this.loadEnabled = bl;
        this.checkLoadEnable();
    }

    public JPanel getFileLoaderPanel() {
        return this.gpflp;
    }

    public void processFileList(String string, Vector vector) {
        this.gpflp.setPath(string);
        if (vector == null) {
            return;
        }
        FileFilter fileFilter = this.getFileFilter();
        this.gpflp.getGenePixAvailableListModel().clear();
        for (int i = 0; i < vector.size(); ++i) {
            File file = new File((String)vector.elementAt(i));
            if (!fileFilter.accept(file)) continue;
            this.gpflp.getGenePixAvailableListModel().addElement(new File((String)vector.elementAt(i)));
        }
    }

    private class GenePixFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JTextField pathTextField;
        JPanel genePixSelectionPanel;
        JPanel genePixListPanel;
        JLabel genePixAvailableLabel;
        JLabel genePixSelectedLabel;
        JList genePixAvailableList;
        JList genePixSelectedList;
        JScrollPane genePixAvailableScrollPane;
        JScrollPane genePixSelectedScrollPane;
        JButton genePixAddButton;
        JButton genePixAddAllButton;
        JButton genePixRemoveButton;
        JButton genePixRemoveAllButton;
        JPanel genePixButtonPanel;
        JPanel selectionPanel;
        JSplitPane splitPane;
        JPanel fileLoaderPanel;

        public GenePixFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileTreePane = new FileTreePane();
            this.fileTreePane.addFileTreePaneListener(new FileTreePaneEventHandler());
            this.fileTreePane.setPreferredSize(new Dimension(200, 50));
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setBorder(new TitledBorder(new EtchedBorder(), "Selected Path"));
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            this.genePixSelectionPanel = new JPanel();
            this.genePixSelectionPanel.setLayout(new GridBagLayout());
            this.genePixSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), GenePixFileLoader.this.getFileFilter().getDescription()));
            this.genePixAvailableLabel = new JLabel("Available");
            this.genePixSelectedLabel = new JLabel("Selected");
            this.genePixAvailableList = new JList(new DefaultListModel());
            this.genePixAvailableList.setCellRenderer(new ListRenderer());
            this.genePixSelectedList = new JList(new DefaultListModel());
            this.genePixSelectedList.setCellRenderer(new ListRenderer());
            this.genePixAvailableScrollPane = new JScrollPane(this.genePixAvailableList);
            this.genePixSelectedScrollPane = new JScrollPane(this.genePixSelectedList);
            this.genePixAddButton = new JButton("Add");
            this.genePixAddButton.addActionListener(new EventHandler());
            this.genePixAddAllButton = new JButton("Add All");
            this.genePixAddAllButton.addActionListener(new EventHandler());
            this.genePixRemoveButton = new JButton("Remove");
            this.genePixRemoveButton.addActionListener(new EventHandler());
            this.genePixRemoveAllButton = new JButton("Remove All");
            this.genePixRemoveAllButton.addActionListener(new EventHandler());
            Dimension dimension = this.genePixRemoveAllButton.getPreferredSize();
            this.genePixAddButton.setPreferredSize(dimension);
            this.genePixAddAllButton.setPreferredSize(dimension);
            this.genePixRemoveButton.setPreferredSize(dimension);
            this.genePixRemoveAllButton.setPreferredSize(dimension);
            this.genePixButtonPanel = new JPanel();
            this.genePixButtonPanel.setLayout(new GridBagLayout());
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.genePixListPanel = new JPanel();
            this.genePixListPanel.setLayout(new GridBagLayout());
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixAvailableScrollPane, 0, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixButtonPanel, 1, 1, 1, 4, 0, 1, 3, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixSelectedScrollPane, 2, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixSelectionPanel, this.genePixListPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            GenePixFileLoader.this.gba.add(this.selectionPanel, this.pathTextField, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.selectionPanel, this.genePixSelectionPanel, 0, 1, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.splitPane = new JSplitPane(1, this.fileTreePane, this.selectionPanel);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            GenePixFileLoader.this.gba.add(this.fileLoaderPanel, this.splitPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void setPath(String string) {
            this.pathTextField.setText(string);
        }

        public void validateLists() {
            if (((DefaultListModel)this.genePixSelectedList.getModel()).size() > 0) {
                GenePixFileLoader.this.markLoadEnabled(true);
            } else {
                GenePixFileLoader.this.markLoadEnabled(false);
            }
        }

        public void onGenePixAdd() {
            int n;
            int[] nArray = this.genePixAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.genePixAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.genePixSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
        }

        public void onGenePixAddAll() {
            int n = ((DefaultListModel)this.genePixAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.genePixAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.genePixSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
        }

        public void onGenePixRemove() {
            int[] nArray = this.genePixSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.genePixSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
        }

        public void onGenePixRemoveAll() {
            ((DefaultListModel)this.genePixSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public DefaultListModel getGenePixAvailableListModel() {
            return (DefaultListModel)this.genePixAvailableList.getModel();
        }

        public DefaultListModel getGenePixSelectedListModel() {
            return (DefaultListModel)this.genePixSelectedList.getModel();
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            public void nodeSelected(FileTreePaneEvent fileTreePaneEvent) {
                String string = (String)fileTreePaneEvent.getValue("Path");
                Vector vector = (Vector)fileTreePaneEvent.getValue("Filenames");
                GenePixFileLoader.this.processFileList(string, vector);
            }

            public void nodeCollapsed(FileTreePaneEvent fileTreePaneEvent) {
            }

            public void nodeExpanded(FileTreePaneEvent fileTreePaneEvent) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == GenePixFileLoaderPanel.this.genePixAddButton) {
                    GenePixFileLoaderPanel.this.onGenePixAdd();
                } else if (object == GenePixFileLoaderPanel.this.genePixAddAllButton) {
                    GenePixFileLoaderPanel.this.onGenePixAddAll();
                } else if (object == GenePixFileLoaderPanel.this.genePixRemoveButton) {
                    GenePixFileLoaderPanel.this.onGenePixRemove();
                } else if (object == GenePixFileLoaderPanel.this.genePixRemoveAllButton) {
                    GenePixFileLoaderPanel.this.onGenePixRemoveAll();
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                File file = (File)object;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

