/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.util.Vector;

public class QSort {
    private int[] origIndx;
    private float[] sorted;
    private double[] sortedDouble;
    private int[] NaNIndices;

    public QSort(float[] fArray) {
        int n;
        float[] fArray2 = new float[fArray.length];
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = fArray[n];
            if (!Float.isNaN(fArray[n])) continue;
            vector.add(new Integer(n));
        }
        this.NaNIndices = new int[vector.size()];
        for (n = 0; n < this.NaNIndices.length; ++n) {
            this.NaNIndices[n] = (Integer)vector.get(n);
        }
        this.sort(fArray2);
    }

    public QSort(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = dArray[n];
            if (!Double.isNaN(dArray[n])) continue;
            vector.add(new Integer(n));
        }
        this.NaNIndices = new int[vector.size()];
        for (n = 0; n < this.NaNIndices.length; ++n) {
            this.NaNIndices[n] = (Integer)vector.get(n);
        }
        this.sort(dArray2);
    }

    public void sort(float[] fArray) {
        this.origIndx = new int[fArray.length];
        for (int i = 0; i <= this.origIndx.length - 1; ++i) {
            this.origIndx[i] = i;
        }
        this.quickSort(fArray, 0, fArray.length - 1);
    }

    public void sort(double[] dArray) {
        this.origIndx = new int[dArray.length];
        for (int i = 0; i <= this.origIndx.length - 1; ++i) {
            this.origIndx[i] = i;
        }
        this.quickSort(dArray, 0, dArray.length - 1);
    }

    void quickSort(float[] fArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            float f = fArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && fArray[n3] < f) {
                    ++n3;
                }
                while (n4 > n && fArray[n4] > f) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swap(fArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(fArray, n, n4);
            }
            if (n3 < n2) {
                this.quickSort(fArray, n3, n2);
            }
        }
        this.sorted = fArray;
    }

    void quickSort(double[] dArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            double d = dArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && dArray[n3] < d) {
                    ++n3;
                }
                while (n4 > n && dArray[n4] > d) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swap(dArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(dArray, n, n4);
            }
            if (n3 < n2) {
                this.quickSort(dArray, n3, n2);
            }
        }
        this.sortedDouble = dArray;
    }

    private void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
        int n3 = this.origIndx[n];
        this.origIndx[n] = this.origIndx[n2];
        this.origIndx[n2] = n3;
    }

    private void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
        int n3 = this.origIndx[n];
        this.origIndx[n] = this.origIndx[n2];
        this.origIndx[n2] = n3;
    }

    public float[] getSorted() {
        int n;
        Vector<Float> vector = new Vector<Float>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < this.sorted.length; ++n) {
            if (Float.isNaN(this.sorted[n])) {
                vector2.add(new Integer(n));
                continue;
            }
            vector.add(new Float(this.sorted[n]));
        }
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(0, new Float(Float.NaN));
        }
        for (n = 0; n < vector.size(); ++n) {
            this.sorted[n] = ((Float)vector.get(n)).floatValue();
        }
        return this.sorted;
    }

    public double[] getSortedDouble() {
        int n;
        Vector<Double> vector = new Vector<Double>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < this.sortedDouble.length; ++n) {
            if (Double.isNaN(this.sortedDouble[n])) {
                vector2.add(new Integer(n));
                continue;
            }
            vector.add(new Double(this.sortedDouble[n]));
        }
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(0, new Double(Double.NaN));
        }
        for (n = 0; n < vector.size(); ++n) {
            this.sortedDouble[n] = (Double)vector.get(n);
        }
        return this.sortedDouble;
    }

    public int[] getOrigIndx() {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < this.origIndx.length; ++n) {
            if (this.isNaNIndex(this.origIndx[n])) continue;
            vector.add(new Integer(this.origIndx[n]));
        }
        for (n = 0; n < this.NaNIndices.length; ++n) {
            vector.add(0, new Integer(this.NaNIndices[n]));
        }
        for (n = 0; n < vector.size(); ++n) {
            this.origIndx[n] = (Integer)vector.get(n);
        }
        return this.origIndx;
    }

    private boolean isNaNIndex(int n) {
        for (int i = 0; i < this.NaNIndices.length; ++i) {
            if (n != this.NaNIndices[i]) continue;
            return true;
        }
        return false;
    }
}

