/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ProgressBar
extends JDialog {
    private Frame parent;
    private String title;
    private Color barColor1;
    private Color barColor2;
    private Color textColor;
    private int units = 0;
    private int value = 0;
    private Applet progressBarApplet;
    private Font progressBarFont;
    private JPanel drawingArea;

    public ProgressBar(Frame frame, String string, Color color, Color color2, Color color3, int n) {
        super(frame, string, false);
        this.parent = frame;
        this.title = string;
        this.barColor1 = color;
        this.barColor2 = color2;
        this.textColor = color3;
        this.units = n;
        this.progressBarApplet = new Applet();
        this.progressBarFont = new Font("monospaced", 1, 20);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressBar.this.hide();
                ProgressBar.this.dispose();
            }
        });
        this.drawingArea = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                ProgressBar.this.OnPaint(graphics);
            }
        };
        this.drawingArea.setPreferredSize(new Dimension(210, 50));
        this.getContentPane().add((Component)this.drawingArea, null);
        this.setSize(210, 50);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.pack();
        this.show();
        this.requestFocus();
        this.toFront();
    }

    public void OnPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.barColor1, 200.0f, 0.0f, this.barColor2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(5, 5, this.value * 200 / this.units, 40);
        graphics2D.setColor(this.textColor);
        graphics2D.drawRect(5, 5, 200, 40);
        graphics2D.setFont(this.progressBarFont);
        graphics2D.drawString("" + this.value * 100 / this.units + "%", 90, 32);
    }

    public ProgressBar(Frame frame, String string, int n) {
        this(frame, string, new Color(200, 200, 200), new Color(200, 200, 200), Color.black, n);
    }

    public ProgressBar(Frame frame, String string, Color color, Color color2, int n) {
        this(frame, string, color, color, Color.black, n);
    }

    public void drawProgressBar() {
        if (this.value < this.units) {
            this.show();
        }
    }

    public void increment(int n) {
        if (this.value < this.units) {
            this.value += n;
            this.repaint();
        }
        if (this.value >= this.units) {
            this.hide();
            this.dispose();
        }
    }

    public void set(int n) {
        this.value = n;
        this.repaint();
    }
}

