/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Header;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.html.HtmlEncoder;
import com.lowagie.text.html.HtmlTags;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;

public class HtmlWriter
extends DocWriter
implements DocListener {
    public static final byte[] BEGINCOMMENT = DocWriter.getISOBytes("<!-- ");
    public static final byte[] ENDCOMMENT = DocWriter.getISOBytes(" -->");
    public static final String NBSP = "&nbsp;";
    protected Stack currentfont = new Stack();
    protected Font standardfont = new Font();
    protected String imagepath = null;
    protected int pageN = 0;
    protected HeaderFooter header = null;
    protected HeaderFooter footer = null;

    protected HtmlWriter(Document doc, OutputStream os) {
        super(doc, os);
        this.document.addDocListener(this);
        this.pageN = this.document.getPageNumber();
        try {
            os.write(60);
            os.write(DocWriter.getISOBytes("html"));
            os.write(62);
            os.write(10);
            os.write(9);
            os.write(60);
            os.write(DocWriter.getISOBytes("head"));
            os.write(62);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public static HtmlWriter getInstance(Document document, OutputStream os) {
        return new HtmlWriter(document, os);
    }

    public boolean newPage() throws DocumentException {
        try {
            this.writeStart("div");
            this.write(" ");
            this.write("style");
            this.write("=\"");
            this.writeCssProperty("page-break-before", "always");
            this.write("\" /");
            this.os.write(62);
        }
        catch (IOException ioe) {
            throw new DocumentException(ioe);
        }
        return true;
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    try {
                        Header h = (Header)element;
                        if ("stylesheet".equals(h.name())) {
                            this.writeLink(h);
                        } else if ("JavaScript".equals(h.name())) {
                            this.writeJavaScript(h);
                        } else {
                            this.writeHeader(h);
                        }
                    }
                    catch (ClassCastException h) {
                        // empty catch block
                    }
                    return true;
                }
                case 2: 
                case 3: 
                case 4: {
                    Meta meta = (Meta)element;
                    this.writeHeader(meta);
                    return true;
                }
                case 1: {
                    this.addTabs(2);
                    this.writeStart("title");
                    this.os.write(62);
                    this.addTabs(3);
                    this.write(HtmlEncoder.encode(((Meta)element).content()));
                    this.addTabs(2);
                    this.writeEnd("title");
                    return true;
                }
                case 7: {
                    this.writeComment("Creator: " + HtmlEncoder.encode(((Meta)element).content()));
                    return true;
                }
                case 5: {
                    this.writeComment("Producer: " + HtmlEncoder.encode(((Meta)element).content()));
                    return true;
                }
                case 6: {
                    this.writeComment("Creationdate: " + HtmlEncoder.encode(((Meta)element).content()));
                    return true;
                }
            }
            this.write(element, 2);
            return true;
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public void open() {
        super.open();
        try {
            this.writeComment("Producer: iTextXML by lowagie.com");
            this.writeComment("CreationDate: " + new Date().toString());
            this.addTabs(1);
            this.writeEnd("head");
            this.addTabs(1);
            this.writeStart("body");
            if (this.document.leftMargin() > 0.0f) {
                this.write("leftmargin", String.valueOf(this.document.leftMargin()));
            }
            if (this.document.rightMargin() > 0.0f) {
                this.write("rightmargin", String.valueOf(this.document.rightMargin()));
            }
            if (this.document.topMargin() > 0.0f) {
                this.write("topmargin", String.valueOf(this.document.topMargin()));
            }
            if (this.document.bottomMargin() > 0.0f) {
                this.write("bottommargin", String.valueOf(this.document.bottomMargin()));
            }
            if (this.pageSize.backgroundColor() != null) {
                this.write("bgcolor", HtmlEncoder.encode(this.pageSize.backgroundColor()));
            }
            if (this.document.getJavaScript_onLoad() != null) {
                this.write("onLoad", HtmlEncoder.encode(this.document.getJavaScript_onLoad()));
            }
            if (this.document.getJavaScript_onUnLoad() != null) {
                this.write("onUnLoad", HtmlEncoder.encode(this.document.getJavaScript_onUnLoad()));
            }
            if (this.document.getHtmlStyleClass() != null) {
                this.write("class", this.document.getHtmlStyleClass());
            }
            this.os.write(62);
            this.initHeader();
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public void close() {
        try {
            this.initFooter();
            this.addTabs(1);
            this.writeEnd("body");
            this.os.write(10);
            this.writeEnd("html");
            super.close();
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    protected void initHeader() {
        if (this.header != null) {
            try {
                this.add(this.header.paragraph());
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    protected void initFooter() {
        if (this.footer != null) {
            try {
                this.footer.setPageNumber(this.pageN + 1);
                this.add(this.footer.paragraph());
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    protected void writeHeader(Meta meta) throws IOException {
        this.addTabs(2);
        this.writeStart("meta");
        switch (meta.type()) {
            case 0: {
                this.write("name", ((Header)meta).name());
                break;
            }
            case 2: {
                this.write("name", "subject");
                break;
            }
            case 3: {
                this.write("name", "keywords");
                break;
            }
            case 4: {
                this.write("name", "author");
            }
        }
        this.write("content", HtmlEncoder.encode(meta.content()));
        this.writeEnd();
    }

    protected void writeLink(Header header) throws IOException {
        this.addTabs(2);
        this.writeStart("link");
        this.write("rel", header.name());
        this.write("type", "text/css");
        this.write("href", header.content());
        this.writeEnd();
    }

    protected void writeJavaScript(Header header) throws IOException {
        this.addTabs(2);
        this.writeStart("script");
        this.write("language", "JavaScript");
        if (header.getMarkupAttribute("src") != null) {
            this.write("src", header.getMarkupAttribute("src"));
            this.os.write(62);
            this.writeEnd("script");
        } else {
            this.write("type", "text/javascript");
            this.os.write(62);
            this.addTabs(2);
            this.write(String.valueOf(new String(BEGINCOMMENT)) + "\n");
            this.write(header.content());
            this.addTabs(2);
            this.write("//" + new String(ENDCOMMENT));
            this.addTabs(2);
            this.writeEnd("script");
        }
    }

    protected void writeComment(String comment) throws IOException {
        this.addTabs(2);
        this.os.write(BEGINCOMMENT);
        this.write(comment);
        this.os.write(ENDCOMMENT);
    }

    public void setStandardFont(Font standardfont) {
        this.standardfont = standardfont;
    }

    public boolean isOtherFont(Font font) {
        try {
            Font cFont = (Font)this.currentfont.peek();
            return cFont.compareTo(font) != 0;
        }
        catch (EmptyStackException ese) {
            return this.standardfont.compareTo(font) != 0;
        }
    }

    public void setImagepath(String imagepath) {
        this.imagepath = imagepath;
    }

    public void resetImagepath() {
        this.imagepath = null;
    }

    public void setHeader(HeaderFooter header) {
        this.header = header;
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer;
    }

    public boolean add(String string) throws DocumentException {
        if (this.pause) {
            return false;
        }
        try {
            this.write(string);
            return true;
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    protected void write(Element element, int indent) throws IOException {
        Properties styleAttributes = null;
        switch (element.type()) {
            case 10: {
                boolean tag;
                Chunk chunk = (Chunk)element;
                Image image = chunk.getImage();
                if (image != null) {
                    this.write(image, indent);
                    return;
                }
                if (chunk.isEmpty()) {
                    return;
                }
                HashMap attributes = chunk.getAttributes();
                if (attributes != null && attributes.get("NEWPAGE") != null) {
                    return;
                }
                boolean bl = tag = this.isOtherFont(chunk.font()) || DocWriter.hasMarkupAttributes(chunk) || styleAttributes != null;
                if (tag) {
                    this.addTabs(indent);
                    this.writeStart("span");
                    if (this.isOtherFont(chunk.font())) {
                        this.write(chunk.font(), styleAttributes);
                    }
                    if (DocWriter.hasMarkupAttributes(chunk)) {
                        this.writeMarkupAttributes(chunk);
                    }
                    this.os.write(62);
                }
                if (attributes != null && attributes.get("SUBSUPSCRIPT") != null) {
                    if (((Float)attributes.get("SUBSUPSCRIPT")).floatValue() > 0.0f) {
                        this.writeStart("sup");
                    } else {
                        this.writeStart("sub");
                    }
                    this.os.write(62);
                }
                this.write(HtmlEncoder.encode(chunk.content()));
                if (attributes != null && attributes.get("SUBSUPSCRIPT") != null) {
                    this.os.write(60);
                    this.os.write(47);
                    if (((Float)attributes.get("SUBSUPSCRIPT")).floatValue() > 0.0f) {
                        this.write("sup");
                    } else {
                        this.write("sub");
                    }
                    this.os.write(62);
                }
                if (tag) {
                    this.writeEnd("span");
                }
                return;
            }
            case 11: {
                Phrase phrase = (Phrase)element;
                styleAttributes = new Properties();
                if (phrase.leadingDefined()) {
                    styleAttributes.setProperty("line-height", String.valueOf(String.valueOf(phrase.leading())) + "pt");
                }
                this.addTabs(indent);
                this.writeStart("span");
                if (DocWriter.hasMarkupAttributes(phrase)) {
                    this.writeMarkupAttributes(phrase);
                }
                this.write(phrase.font(), styleAttributes);
                this.os.write(62);
                this.currentfont.push(phrase.font());
                Iterator i = ((AbstractList)phrase).iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("span");
                this.currentfont.pop();
                return;
            }
            case 17: {
                Anchor anchor = (Anchor)element;
                styleAttributes = new Properties();
                if (anchor.leadingDefined()) {
                    styleAttributes.setProperty("line-height", String.valueOf(String.valueOf(anchor.leading())) + "pt");
                }
                this.addTabs(indent);
                this.writeStart("a");
                if (anchor.name() != null) {
                    this.write("name", anchor.name());
                }
                if (anchor.reference() != null) {
                    this.write("href", anchor.reference());
                }
                if (DocWriter.hasMarkupAttributes(anchor)) {
                    this.writeMarkupAttributes(anchor);
                }
                this.write(anchor.font(), styleAttributes);
                this.os.write(62);
                this.currentfont.push(anchor.font());
                Iterator i = ((AbstractList)anchor).iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("a");
                this.currentfont.pop();
                return;
            }
            case 12: {
                String alignment;
                Paragraph paragraph = (Paragraph)element;
                styleAttributes = new Properties();
                if (paragraph.leadingDefined()) {
                    styleAttributes.setProperty("line-height", String.valueOf(String.valueOf(paragraph.leading())) + "pt");
                }
                this.addTabs(indent);
                this.writeStart("div");
                if (DocWriter.hasMarkupAttributes(paragraph)) {
                    this.writeMarkupAttributes(paragraph);
                }
                if (!"".equals(alignment = HtmlEncoder.getAlignment(paragraph.alignment()))) {
                    this.write("align", alignment);
                }
                this.write(paragraph.font(), styleAttributes);
                this.os.write(62);
                this.currentfont.push(paragraph.font());
                Iterator i = ((AbstractList)paragraph).iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("div");
                this.currentfont.pop();
                return;
            }
            case 13: 
            case 16: {
                this.writeSection((Section)element, indent);
                return;
            }
            case 14: {
                List list = (List)element;
                this.addTabs(indent);
                if (list.isNumbered()) {
                    this.writeStart("ol");
                } else {
                    this.writeStart("ul");
                }
                if (DocWriter.hasMarkupAttributes(list)) {
                    this.writeMarkupAttributes(list);
                }
                this.os.write(62);
                Iterator i = ((AbstractList)list.getItems()).iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                if (list.isNumbered()) {
                    this.writeEnd("ol");
                } else {
                    this.writeEnd("ul");
                }
                return;
            }
            case 15: {
                ListItem listItem = (ListItem)element;
                styleAttributes = new Properties();
                if (listItem.leadingDefined()) {
                    styleAttributes.setProperty("line-height", String.valueOf(String.valueOf(listItem.leading())) + "pt");
                }
                this.addTabs(indent);
                this.writeStart("li");
                if (DocWriter.hasMarkupAttributes(listItem)) {
                    this.writeMarkupAttributes(listItem);
                }
                this.write(listItem.font(), styleAttributes);
                this.os.write(62);
                this.currentfont.push(listItem.font());
                Iterator i = ((AbstractList)listItem).iterator();
                while (i.hasNext()) {
                    this.write((Element)i.next(), indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("li");
                this.currentfont.pop();
                return;
            }
            case 20: {
                String alignment;
                Cell cell = (Cell)element;
                this.addTabs(indent);
                if (cell.header()) {
                    this.writeStart("th");
                } else {
                    this.writeStart("td");
                }
                if (DocWriter.hasMarkupAttributes(cell)) {
                    this.writeMarkupAttributes(cell);
                }
                if (cell.borderWidth() != -1.0f) {
                    this.write("border", String.valueOf(cell.borderWidth()));
                }
                if (cell.borderColor() != null) {
                    this.write("bordercolor", HtmlEncoder.encode(cell.borderColor()));
                }
                if (cell.backgroundColor() != null) {
                    this.write("bgcolor", HtmlEncoder.encode(cell.backgroundColor()));
                }
                if (!"".equals(alignment = HtmlEncoder.getAlignment(cell.horizontalAlignment()))) {
                    this.write("align", alignment);
                }
                if (!"".equals(alignment = HtmlEncoder.getAlignment(cell.verticalAlignment()))) {
                    this.write("valign", alignment);
                }
                if (cell.cellWidth() != null) {
                    this.write("width", cell.cellWidth());
                }
                if (cell.colspan() != 1) {
                    this.write("colspan", String.valueOf(cell.colspan()));
                }
                if (cell.rowspan() != 1) {
                    this.write("rowspan", String.valueOf(cell.rowspan()));
                }
                if (cell.noWrap()) {
                    this.write("nowrap", String.valueOf(true));
                }
                this.os.write(62);
                if (cell.isEmpty()) {
                    this.write(NBSP);
                } else {
                    Iterator i = cell.getElements();
                    while (i.hasNext()) {
                        this.write((Element)i.next(), indent + 1);
                    }
                }
                this.addTabs(indent);
                if (cell.header()) {
                    this.writeEnd("th");
                } else {
                    this.writeEnd("td");
                }
                return;
            }
            case 21: {
                Row row = (Row)element;
                this.addTabs(indent);
                this.writeStart("tr");
                if (DocWriter.hasMarkupAttributes(row)) {
                    this.writeMarkupAttributes(row);
                }
                this.os.write(62);
                int i = 0;
                while (i < row.columns()) {
                    Element cell = (Element)row.getCell(i);
                    if (cell != null) {
                        this.write(cell, indent + 1);
                    }
                    ++i;
                }
                this.addTabs(indent);
                this.writeEnd("tr");
                return;
            }
            case 22: {
                Table table = (Table)element;
                table.complete();
                this.addTabs(indent);
                this.writeStart("table");
                if (DocWriter.hasMarkupAttributes(table)) {
                    this.writeMarkupAttributes(table);
                }
                this.os.write(32);
                this.write("width");
                this.os.write(61);
                this.os.write(34);
                if (!"".equals(table.absWidth())) {
                    this.write(table.absWidth());
                } else {
                    this.write(String.valueOf(table.widthPercentage()));
                    this.write("%");
                }
                this.os.write(34);
                String alignment = HtmlEncoder.getAlignment(table.alignment());
                if (!"".equals(alignment)) {
                    this.write("align", alignment);
                }
                this.write("cellpadding", String.valueOf(table.cellpadding()));
                this.write("cellspacing", String.valueOf(table.cellspacing()));
                if (table.borderWidth() != -1.0f) {
                    this.write("border", String.valueOf(table.borderWidth()));
                }
                if (table.borderColor() != null) {
                    this.write("bordercolor", HtmlEncoder.encode(table.borderColor()));
                }
                if (table.backgroundColor() != null) {
                    this.write("bgcolor", HtmlEncoder.encode(table.backgroundColor()));
                }
                this.os.write(62);
                Iterator iterator = table.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    this.write(row, indent + 1);
                }
                this.addTabs(indent);
                this.writeEnd("table");
                return;
            }
            case 29: {
                Annotation annotation = (Annotation)element;
                this.writeComment(String.valueOf(annotation.title()) + ": " + annotation.content());
                if (DocWriter.hasMarkupAttributes(annotation)) {
                    this.os.write(BEGINCOMMENT);
                    this.writeMarkupAttributes(annotation);
                    this.os.write(ENDCOMMENT);
                }
                return;
            }
            case 32: 
            case 34: 
            case 35: {
                Image image = (Image)element;
                if (image.url() == null) {
                    return;
                }
                this.addTabs(indent);
                this.writeStart("img");
                String path = image.url().toString();
                if (this.imagepath != null) {
                    path = path.indexOf("/") > 0 ? String.valueOf(this.imagepath) + path.substring(path.lastIndexOf("/") + 1) : String.valueOf(this.imagepath) + path;
                }
                this.write("src", path);
                image.alignment();
                if (0 > 0) {
                    this.write("align", "Left");
                } else if ((image.alignment() & 2) > 0) {
                    this.write("align", "Right");
                } else if ((image.alignment() & 1) > 0) {
                    this.write("align", "Middle");
                }
                if (image.alt() != null) {
                    this.write("alt", image.alt());
                }
                this.write("width", String.valueOf(image.scaledWidth()));
                this.write("height", String.valueOf(image.scaledHeight()));
                if (DocWriter.hasMarkupAttributes(image)) {
                    this.writeMarkupAttributes(image);
                }
                this.writeEnd();
                return;
            }
        }
    }

    protected void writeSection(Section section, int indent) throws IOException {
        if (section.title() != null) {
            int depth = section.depth() - 1;
            if (depth > 5) {
                depth = 5;
            }
            Properties styleAttributes = new Properties();
            if (section.title().leadingDefined()) {
                styleAttributes.setProperty("line-height", String.valueOf(String.valueOf(section.title().leading())) + "pt");
            }
            this.addTabs(indent);
            this.writeStart(HtmlTags.H[depth]);
            this.write(section.title().font(), styleAttributes);
            String alignment = HtmlEncoder.getAlignment(section.title().alignment());
            if (!"".equals(alignment)) {
                this.write("align", alignment);
            }
            if (DocWriter.hasMarkupAttributes(section.title())) {
                this.writeMarkupAttributes(section.title());
            }
            this.os.write(62);
            this.currentfont.push(section.title().font());
            Iterator i = ((AbstractList)section.title()).iterator();
            while (i.hasNext()) {
                this.write((Element)i.next(), indent + 1);
            }
            this.addTabs(indent);
            this.writeEnd(HtmlTags.H[depth]);
            this.currentfont.pop();
        }
        Iterator i = ((AbstractList)section).iterator();
        while (i.hasNext()) {
            this.write((Element)i.next(), indent);
        }
    }

    protected void write(Font font, Properties styleAttributes) throws IOException {
        if (font == null || !this.isOtherFont(font)) {
            return;
        }
        this.write(" ");
        this.write("style");
        this.write("=\"");
        if (styleAttributes != null) {
            Enumeration<?> e = styleAttributes.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.writeCssProperty(key, styleAttributes.getProperty(key));
            }
        }
        if (this.isOtherFont(font)) {
            int fontstyle;
            this.writeCssProperty("font-family", font.getFamilyname());
            if (font.size() != -1.0f) {
                this.writeCssProperty("font-size", String.valueOf(String.valueOf(font.size())) + "pt");
            }
            if (font.color() != null) {
                this.writeCssProperty("color", HtmlEncoder.encode(font.color()));
            }
            if ((fontstyle = font.style()) != -1 && fontstyle != 0) {
                switch (fontstyle & 3) {
                    case 1: {
                        this.writeCssProperty("font-weight", "bold");
                        break;
                    }
                    case 2: {
                        this.writeCssProperty("font-style", "italic");
                        break;
                    }
                    case 3: {
                        this.writeCssProperty("font-weight", "bold");
                        this.writeCssProperty("font-style", "italic");
                    }
                }
                if ((fontstyle & 4) > 0) {
                    this.writeCssProperty("text-decoration", "underline");
                }
                if ((fontstyle & 8) > 0) {
                    this.writeCssProperty("text-decoration", "line-through");
                }
            }
        }
        this.write("\"");
    }

    protected void writeCssProperty(String prop, String value) throws IOException {
        this.write(prop + ": " + value + "; ");
    }
}

