/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ListOrderDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ExperimentLabelEditor
extends AlgorithmDialog {
    JTable table;
    DefaultViewerTableModel model;
    CellEditor cellEditor;
    int result = 0;
    JPopupMenu popup;
    JMenuItem mergeRowsPopItem;
    JMenuItem mergeRowsItem;
    JMenuItem delRowsPopItem;
    JMenuItem delRowsItem;
    JCheckBoxMenuItem enableReorderItem;
    JCheckBoxMenuItem enableReorderPopItem;
    boolean allowReordering = false;
    JFrame parent;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JTextField;
    static /* synthetic */ Class class$java$lang$Object;

    public ExperimentLabelEditor(JFrame jFrame, Vector vector, IData iData, boolean bl) {
        super(jFrame, "Sample Label Editor", true);
        this.parent = jFrame;
        Listener listener = new Listener();
        this.allowReordering = bl;
        this.model = new DefaultViewerTableModel(vector, iData);
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ExperimentLabelEditor.class$("java.lang.String")) : class$java$lang$String, new CellRenderer());
        this.table.setDefaultRenderer(class$javax$swing$JTextField == null ? (class$javax$swing$JTextField = ExperimentLabelEditor.class$("javax.swing.JTextField")) : class$javax$swing$JTextField, new CellRenderer());
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ExperimentLabelEditor.class$("java.lang.Object")) : class$java$lang$Object, new CellRenderer());
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.getColumn("Label Key").setMinWidth(130);
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(String.valueOf(i)).setMinWidth(100);
        }
        this.table.setDefaultEditor(class$javax$swing$JTextField == null ? (class$javax$swing$JTextField = ExperimentLabelEditor.class$("javax.swing.JTextField")) : class$javax$swing$JTextField, new DefaultCellEditor(new JTextField()));
        this.table.setRowHeight(25);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setColumnHeaderView(this.table.getTableHeader());
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        ParameterPanel parameterPanel = new ParameterPanel("Sample Labels");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)jScrollPane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JMenuBar jMenuBar = this.createMenuBar(listener);
        this.setJMenuBar(jMenuBar);
        this.popup = this.createPopupMenu(listener);
        this.addContent((Component)parameterPanel);
        int n = this.getToolkit().getScreenSize().width;
        int n2 = 130 + 100 * (this.table.getColumnCount() - 1) - 50;
        if (n > 100) {
            n = (int)((double)n * 0.8);
            this.setSize(Math.min(n, n2), 300);
        } else {
            this.setSize(700, 300);
        }
        this.table.addMouseListener(listener);
        this.setActionListeners(listener);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getNewLabel() {
        return "TestLabel";
    }

    public String[] getLabelValues() {
        String[] stringArray = new String[10];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "Test Label " + String.valueOf(i);
        }
        return stringArray;
    }

    public String[][] getLableData() {
        String[][] stringArray = new String[this.table.getRowCount()][this.table.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringArray[i][j] = (String)this.model.getValueAt(i, j);
            }
        }
        return stringArray;
    }

    public String[][] getLabelDataWithoutKeys() {
        String[][] stringArray = new String[this.table.getRowCount()][this.table.getColumnCount() - 1];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringArray[i][j] = (String)this.model.getValueAt(i, j + 1);
            }
        }
        return stringArray;
    }

    public String[] getLabelKeys() {
        String[] stringArray = new String[this.table.getRowCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.model.getValueAt(i, 0);
        }
        return stringArray;
    }

    public String[] getExperimentNamesInOriginalOrder() {
        String[] stringArray = new String[this.table.getColumnCount() - 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.model.getValueAt(0, i + 1);
        }
        return stringArray;
    }

    public String[] getExperimentNamesInTableOrder() {
        String[] stringArray = new String[this.table.getColumnCount() - 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.table.getValueAt(0, i + 1);
        }
        return stringArray;
    }

    public int[] getNewOrderScheme() {
        String[] stringArray = this.getExperimentNamesInOriginalOrder();
        String[] stringArray2 = this.getExperimentNamesInTableOrder();
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                nArray[j] = i;
            }
        }
        return nArray;
    }

    public boolean isReorderedSelected() {
        return this.allowReordering && (this.enableReorderItem.isSelected() || this.enableReorderPopItem.isSelected());
    }

    private JMenuBar createMenuBar(Listener listener) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        JMenuItem jMenuItem = new JMenuItem("Add New Sample Label");
        jMenuItem.setActionCommand("add-row-command");
        jMenuItem.addActionListener(listener);
        this.mergeRowsItem = new JMenuItem("Merge Selected Rows");
        this.mergeRowsItem.setActionCommand("merge-rows-command");
        this.mergeRowsItem.addActionListener(listener);
        this.delRowsItem = new JMenuItem("Delete Selected Rows");
        this.delRowsItem.setActionCommand("del-rows-command");
        this.delRowsItem.addActionListener(listener);
        this.enableReorderItem = new JCheckBoxMenuItem("Enable Sample Reordering", false);
        this.enableReorderItem.setActionCommand("reorder-command");
        this.enableReorderItem.setEnabled(this.allowReordering);
        this.enableReorderItem.setToolTipText("forces samples to reorder to match table, hit info button");
        this.enableReorderItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenu.add(this.mergeRowsItem);
        jMenu.add(this.delRowsItem);
        jMenu.add(new JSeparator());
        jMenu.add(this.enableReorderItem);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    private JPopupMenu createPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add New Sample Label");
        jMenuItem.setActionCommand("add-row-command");
        jMenuItem.addActionListener(listener);
        this.mergeRowsPopItem = new JMenuItem("Merge Selected Rows");
        this.mergeRowsPopItem.setActionCommand("merge-rows-command");
        this.mergeRowsPopItem.addActionListener(listener);
        this.delRowsPopItem = new JMenuItem("Delete Selected Rows");
        this.delRowsPopItem.setActionCommand("del-rows-command");
        this.delRowsPopItem.addActionListener(listener);
        this.enableReorderPopItem = new JCheckBoxMenuItem("Enable Sample Reordering", false);
        this.enableReorderPopItem.setActionCommand("reorder-command");
        this.enableReorderPopItem.setEnabled(this.allowReordering);
        this.enableReorderPopItem.setToolTipText("forces samples to reorder to match table, hit info button");
        this.enableReorderPopItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(this.mergeRowsPopItem);
        jPopupMenu.add(this.delRowsPopItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.enableReorderPopItem);
        return jPopupMenu;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("add-row-command")) {
                ExperimentLabelEditor.this.model.addNewRow();
            } else if (string.equals("merge-rows-command")) {
                int[] nArray = ExperimentLabelEditor.this.table.getSelectedRows();
                if (nArray.length < 2) {
                    return;
                }
                ExperimentLabelEditor.this.model.mergeRows(nArray);
            } else if (string.equals("del-rows-command")) {
                int[] nArray = ExperimentLabelEditor.this.table.getSelectedRows();
                if (nArray.length < 1) {
                    return;
                }
                ExperimentLabelEditor.this.model.deleteRows(nArray);
            } else if (ExperimentLabelEditor.this.allowReordering && string.equals("reorder-command")) {
                if (actionEvent.getSource() == ExperimentLabelEditor.this.enableReorderItem) {
                    ExperimentLabelEditor.this.enableReorderPopItem.setSelected(ExperimentLabelEditor.this.enableReorderItem.isSelected());
                } else {
                    ExperimentLabelEditor.this.enableReorderItem.setSelected(ExperimentLabelEditor.this.enableReorderPopItem.isSelected());
                }
            } else if (string.equals("ok-command")) {
                if (ExperimentLabelEditor.this.table.isEditing()) {
                    String string2 = ((JTextField)ExperimentLabelEditor.this.table.getEditorComponent()).getText();
                    ExperimentLabelEditor.this.table.setValueAt(string2, ExperimentLabelEditor.this.table.getEditingRow(), ExperimentLabelEditor.this.table.getEditingColumn());
                }
                ExperimentLabelEditor.this.result = 0;
                ExperimentLabelEditor.this.dispose();
            } else if (string.equals("cancel-command")) {
                ExperimentLabelEditor.this.result = 2;
                ExperimentLabelEditor.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)ExperimentLabelEditor.this), "Experiment Label Editor");
                ExperimentLabelEditor.this.result = 2;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(550, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ExperimentLabelEditor.this.popup.show(ExperimentLabelEditor.this.table, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ExperimentLabelEditor.this.popup.show(ExperimentLabelEditor.this.table, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (ExperimentLabelEditor.this.table.getSelectedRowCount() > 1) {
                ExperimentLabelEditor.this.mergeRowsItem.setEnabled(true);
                ExperimentLabelEditor.this.mergeRowsPopItem.setEnabled(true);
            } else {
                ExperimentLabelEditor.this.mergeRowsItem.setEnabled(false);
                ExperimentLabelEditor.this.mergeRowsPopItem.setEnabled(false);
            }
            if (ExperimentLabelEditor.this.table.getSelectedRowCount() > 0) {
                ExperimentLabelEditor.this.delRowsItem.setEnabled(true);
                ExperimentLabelEditor.this.delRowsPopItem.setEnabled(true);
            } else {
                ExperimentLabelEditor.this.delRowsItem.setEnabled(false);
                ExperimentLabelEditor.this.delRowsPopItem.setEnabled(false);
            }
        }
    }

    public class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTextField field = new JTextField();
        String value;

        public CellEditor() {
            this.field.setBackground(new Color(222, 222, 222));
        }

        public Object getCellEditorValue() {
            return this.field;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.value = this.field.getText();
            this.fireEditingStopped();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.field = (JTextField)object;
            return (JTextField)object;
        }
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        JPanel colorPanel;
        JLabel label;
        JTextField textField = new JTextField();

        public CellRenderer() {
            this.textField.setOpaque(true);
            this.colorPanel = new JPanel();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Color) {
                this.colorPanel.setBackground((Color)object);
                return this.colorPanel;
            }
            if (object instanceof JLabel) {
                this.label = (JLabel)object;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                if (n == 0 || n2 == 0) {
                    this.label.setBackground(Color.lightGray);
                } else {
                    this.label.setBackground(new Color(225, 225, 225));
                }
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (ExperimentLabelEditor.this.table.isRowSelected(n) && n != 0) {
                    this.label.setBackground(ExperimentLabelEditor.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (object instanceof JTextField) {
                this.textField = (JTextField)object;
                if (n == 0) {
                    this.textField.setEditable(false);
                    this.textField.setBackground(Color.lightGray);
                } else if (n2 == 0) {
                    this.textField.setEditable(true);
                    this.textField.setBackground(new Color(255, 255, 155));
                } else {
                    this.textField.setEditable(true);
                    this.textField.setBackground(Color.white);
                }
                if (ExperimentLabelEditor.this.table.isRowSelected(n) && n != 0) {
                    this.textField.setBackground(ExperimentLabelEditor.this.table.getSelectionBackground());
                }
                return this.textField;
            }
            if (object instanceof String) {
                this.textField.setText((String)object);
                if (n == 0) {
                    this.textField.setEditable(false);
                    this.textField.setBackground(Color.lightGray);
                } else if (n2 == 0) {
                    this.textField.setEditable(true);
                    this.textField.setBackground(new Color(255, 255, 155));
                } else {
                    this.textField.setEditable(true);
                    this.textField.setBackground(Color.white);
                }
                if (ExperimentLabelEditor.this.table.isRowSelected(n) && n != 0) {
                    this.textField.setBackground(ExperimentLabelEditor.this.table.getSelectionBackground());
                }
                return this.textField;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class DefaultViewerTableModel
    extends AbstractTableModel
    implements Serializable {
        boolean[] numerical;
        Row[] rows;
        int colToSort = 0;
        boolean ascending = false;
        int columnCount;
        IData data;
        ISlideData slideData;
        String currKey;
        String[] columnNames;
        String[][] dataObject;
        Vector keys;
        JTextField valueObject;
        JLabel label;

        public DefaultViewerTableModel(Vector vector, IData iData) {
            int n;
            int n2;
            this.data = iData;
            this.keys = vector;
            this.columnCount = iData.getFeaturesCount() + 1;
            this.columnNames = new String[this.columnCount];
            for (n2 = 0; n2 < this.columnNames.length; ++n2) {
                this.columnNames[n2] = n2 == 0 ? "Label Key" : String.valueOf(n2);
            }
            n2 = iData.getFeaturesCount();
            int n3 = vector.size();
            this.dataObject = new String[n3][n2 + 1];
            for (n = 0; n < n2 + 1; ++n) {
                String string = null;
                for (int i = 0; i < n3; ++i) {
                    String string2 = (String)vector.elementAt(i);
                    if (n == 0) {
                        this.dataObject[i][n] = string2;
                        continue;
                    }
                    this.slideData = iData.getFeature(n - 1);
                    string = (String)this.slideData.getSlideDataLabels().get(string2);
                    this.dataObject[i][n] = string != null ? string : " ";
                }
            }
            this.rows = new Row[vector.size()];
            for (n = 0; n < this.rows.length; ++n) {
                this.rows[n] = new Row();
                this.rows[n].index = n;
            }
            this.valueObject = new JTextField();
            this.valueObject.setOpaque(true);
            this.label = new JLabel();
            this.label.setOpaque(true);
        }

        public void initializeRows(int n) {
            this.rows = new Row[n];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        public void setNumerical(int n, boolean bl) {
            if (n > -1 && n < this.numerical.length) {
                this.numerical[n] = bl;
            }
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowCount() {
            return this.rows.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.dataObject[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.dataObject[n][n2] = (String)object;
            this.fireTableChanged(new TableModelEvent(this, n, n, n2));
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        private boolean isNumerical(int n) {
            return this.numerical[n];
        }

        public void sort(int n) {
            this.ascending = !this.ascending;
            this.colToSort = n;
            Arrays.sort(this.rows);
            this.fireTableDataChanged();
        }

        public int getRow(int n) {
            return this.rows[n].index;
        }

        public boolean isCellEditable(int n, int n2) {
            return n > 0;
        }

        public void addNewRow() {
            int n;
            String[][] stringArray = new String[this.dataObject.length + 1][this.columnCount];
            for (n = 0; n < stringArray.length - 1; ++n) {
                stringArray[n] = this.dataObject[n];
            }
            this.dataObject = stringArray;
            this.initializeRows(this.dataObject.length);
            for (n = 0; n < this.columnCount; ++n) {
                this.dataObject[this.dataObject.length - 1][n] = "";
            }
            this.fireTableRowsInserted(this.dataObject.length - 1, this.dataObject.length - 1);
        }

        public void addNewRow(String[] stringArray) {
            String[][] stringArray2 = new String[this.dataObject.length + 1][this.columnCount];
            for (int i = 0; i < stringArray2.length - 1; ++i) {
                stringArray2[i] = this.dataObject[i];
            }
            this.dataObject = stringArray2;
            this.initializeRows(this.dataObject.length);
            this.dataObject[this.dataObject.length - 1] = stringArray;
            this.fireTableRowsInserted(this.dataObject.length - 1, this.dataObject.length - 1);
        }

        public void mergeRows(int[] nArray) {
            Vector vector = new Vector();
            for (int i = 0; i < nArray.length; ++i) {
                vector.addElement(this.dataObject[nArray[i]][0]);
            }
            JList jList = new JList(vector);
            jList.setSelectedIndex(0);
            ListOrderDialog listOrderDialog = new ListOrderDialog(ExperimentLabelEditor.this.parent, jList, vector, "Sample Label Keys", " ");
            if (listOrderDialog.showModal() != 0) {
                return;
            }
            vector = listOrderDialog.getSortedVector();
            String[] stringArray = new String[ExperimentLabelEditor.this.table.getColumnCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)this.getMergedData(vector, i);
            }
            this.addNewRow(stringArray);
        }

        public Object getMergedData(Vector vector, int n) {
            String string = "";
            for (int i = 0; i < vector.size(); ++i) {
                string = i == 0 ? string + this.getDataForKey((String)vector.elementAt(i), n) : string + "-" + this.getDataForKey((String)vector.elementAt(i), n);
            }
            return string;
        }

        public Object getDataForKey(String string, int n) {
            for (int i = 0; i < this.dataObject.length; ++i) {
                if (!this.dataObject[i][0].equals(string)) continue;
                return this.dataObject[i][n];
            }
            return " ";
        }

        public void deleteRows(int[] nArray) {
            boolean[] blArray = new boolean[this.dataObject.length];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                blArray[nArray[i]] = true;
                ++n;
            }
            String[][] stringArrayArray = new String[this.dataObject.length - n][];
            int n2 = 0;
            for (int i = 0; i < this.dataObject.length; ++i) {
                if (blArray[i]) continue;
                stringArrayArray[n2] = this.dataObject[i];
                ++n2;
            }
            this.initializeRows(stringArrayArray.length);
            this.dataObject = stringArrayArray;
            this.fireTableDataChanged();
        }

        private class Row
        implements Comparable,
        Serializable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object object) {
                if (DefaultViewerTableModel.this.ascending) {
                    return this.compareToOther(object);
                }
                return this.compareToOther(object) * -1;
            }

            public int compareToOther(Object object) {
                Row row = (Row)object;
                Object object2 = DefaultViewerTableModel.this.getValueAt(this.index, DefaultViewerTableModel.this.colToSort);
                Object object3 = DefaultViewerTableModel.this.getValueAt(row.index, DefaultViewerTableModel.this.colToSort);
                if (object2 instanceof Comparable) {
                    if (DefaultViewerTableModel.this.isNumerical(DefaultViewerTableModel.this.colToSort) && object2 instanceof String) {
                        Float f = new Float((String)object2);
                        Float f2 = new Float((String)object3);
                        return f.compareTo(f2);
                    }
                    return ((Comparable)object2).compareTo(object3);
                }
                if (object2 instanceof JLabel) {
                    this.myString = ((JLabel)object2).getText();
                    this.otherString = ((JLabel)object3).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - row.index;
            }
        }
    }
}

