/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class SetPercentageCutoffsDialog
extends AlgorithmDialog {
    private float originalValue;
    private int result;
    private JTextField textField;
    private JCheckBox enableCheckBox;
    private JLabel percentageLabel;

    public SetPercentageCutoffsDialog(JFrame jFrame, float f) {
        super(jFrame, "Set Percentage Cutoff", true);
        Listener listener = new Listener();
        this.originalValue = f;
        GBA gBA = new GBA();
        this.enableCheckBox = new JCheckBox("Enable Percentage Cutoff Filter", true);
        this.enableCheckBox.setActionCommand("enable-check-box-command");
        this.enableCheckBox.setOpaque(false);
        this.enableCheckBox.setFocusPainted(false);
        this.enableCheckBox.addActionListener(listener);
        this.percentageLabel = new JLabel("Percentage Cutoff (" + f + "%): ");
        this.percentageLabel.setHorizontalTextPosition(4);
        this.percentageLabel.setHorizontalAlignment(4);
        this.textField = new JTextField(10);
        this.textField.setText(String.valueOf(f));
        this.textField.selectAll();
        this.textField.addKeyListener(listener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        gBA.add((Container)jPanel, (Component)this.enableCheckBox, 0, 0, 2, 1, 0, 0, 3, 10, new Insets(25, 5, 0, 5), 0, 0);
        gBA.add((Container)jPanel, (Component)this.percentageLabel, 0, 1, 1, 1, 1, 0, 1, 13, new Insets(10, 5, 35, 5), 0, 0);
        gBA.add((Container)jPanel, (Component)this.textField, 1, 1, 1, 1, 1, 0, 0, 17, new Insets(10, 5, 35, 5), 0, 0);
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
        this.textField.grabFocus();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isCutoffFilterEnabled() {
        return this.enableCheckBox.isSelected();
    }

    public float getPercentageCutoff() {
        return Float.parseFloat(this.textField.getText());
    }

    public static void main(String[] stringArray) {
        SetPercentageCutoffsDialog setPercentageCutoffsDialog = new SetPercentageCutoffsDialog(new JFrame(), 0.0f);
        setPercentageCutoffsDialog.showModal();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    Float.parseFloat(SetPercentageCutoffsDialog.this.textField.getText());
                    SetPercentageCutoffsDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetPercentageCutoffsDialog.this.result = 2;
                }
                SetPercentageCutoffsDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                SetPercentageCutoffsDialog.this.result = 2;
                SetPercentageCutoffsDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                SetPercentageCutoffsDialog.this.enableCheckBox.setSelected(true);
                SetPercentageCutoffsDialog.this.textField.setEnabled(true);
                SetPercentageCutoffsDialog.this.percentageLabel.setEnabled(true);
                SetPercentageCutoffsDialog.this.textField.setText(String.valueOf(SetPercentageCutoffsDialog.this.originalValue));
                SetPercentageCutoffsDialog.this.textField.selectAll();
                SetPercentageCutoffsDialog.this.textField.grabFocus();
            } else {
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow((JDialog)((Object)SetPercentageCutoffsDialog.this), "Set Percentage Cutoff");
                    SetPercentageCutoffsDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
                if (string.equals("enable-check-box-command")) {
                    boolean bl = SetPercentageCutoffsDialog.this.enableCheckBox.isSelected();
                    SetPercentageCutoffsDialog.this.percentageLabel.setEnabled(bl);
                    SetPercentageCutoffsDialog.this.textField.setEnabled(bl);
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetPercentageCutoffsDialog.this.result = -1;
            SetPercentageCutoffsDialog.this.dispose();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    Float.parseFloat(SetPercentageCutoffsDialog.this.textField.getText());
                    SetPercentageCutoffsDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetPercentageCutoffsDialog.this.result = 2;
                }
                SetPercentageCutoffsDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

