/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class SetRatioScaleDialog
extends AlgorithmDialog {
    private int result;
    private boolean doubleGradient;
    private boolean origDoubleGradient;
    private BufferedImage origPosImage;
    private BufferedImage origNegImage;
    private JTextField upperTextField;
    private JTextField lowerTextField;
    private JTextField midTextField;
    private JLabel midLabel;
    private JRadioButton singleGradientButton;
    private JRadioButton doubleGradientButton;
    private float currMinValue;
    private float currMaxValue;
    private float currMidValue;
    private float origUpper;
    private float origLower;
    private float origMid;
    private String formattedUpper;
    private String formattedLower;
    private String formattedMid;
    private StatsPanel statsPanel;
    private GradientPreviewPanel gradientPreviewPanel;
    private IFramework framework;
    private MultipleArrayMenubar menubar;
    private DecimalFormat twoDecimalFormat;
    private DecimalFormat oneDecimalFormat;

    public SetRatioScaleDialog(JFrame jFrame, IFramework iFramework, MultipleArrayMenubar multipleArrayMenubar, float f, float f2, float f3, boolean bl) {
        super(jFrame, "Color Scale Limits", true);
        EventListener eventListener = new EventListener();
        Experiment experiment = iFramework.getData().getExperiment();
        FloatMatrix floatMatrix = experiment.getMatrix();
        float[] fArray = experiment.getMinAndMax();
        float f4 = fArray[0];
        float f5 = fArray[1];
        this.menubar = multipleArrayMenubar;
        this.doubleGradient = bl;
        this.origDoubleGradient = bl;
        this.framework = iFramework;
        this.origLower = f2;
        this.origUpper = f;
        this.origMid = f3;
        this.origNegImage = iFramework.getDisplayMenu().getNegativeGradientImage();
        this.origPosImage = iFramework.getDisplayMenu().getPositiveGradientImage();
        this.twoDecimalFormat = new DecimalFormat();
        this.twoDecimalFormat.setMaximumFractionDigits(2);
        this.twoDecimalFormat.setMinimumFractionDigits(2);
        this.oneDecimalFormat = new DecimalFormat();
        this.oneDecimalFormat.setMaximumFractionDigits(1);
        this.formattedUpper = this.twoDecimalFormat.format(this.origUpper);
        this.formattedLower = this.twoDecimalFormat.format(this.origLower);
        this.formattedMid = this.twoDecimalFormat.format(this.origMid);
        this.statsPanel = new StatsPanel(iFramework);
        float f6 = this.statsPanel.getMedian();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.doubleGradientButton = new JRadioButton("Double Gradient", bl);
        this.doubleGradientButton.setActionCommand("change-gradient-command");
        this.doubleGradientButton.addActionListener(eventListener);
        this.doubleGradientButton.setFocusPainted(false);
        this.doubleGradientButton.setOpaque(false);
        buttonGroup.add(this.doubleGradientButton);
        this.singleGradientButton = new JRadioButton("Single Gradient", !bl);
        this.singleGradientButton.setActionCommand("change-gradient-command");
        this.singleGradientButton.addActionListener(eventListener);
        this.singleGradientButton.setFocusPainted(false);
        this.singleGradientButton.setOpaque(false);
        buttonGroup.add(this.singleGradientButton);
        if (iFramework.getDisplayMenu().getColorScheme() == 8) {
            this.doubleGradientButton.setEnabled(false);
        }
        ParameterPanel parameterPanel = new ParameterPanel("Gradient Style");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)this.doubleGradientButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 20), 0, 0));
        parameterPanel.add((Component)this.singleGradientButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 20, 10, 0), 0, 0));
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        JLabel jLabel = new JLabel("Upper Limit ( max. data value = " + decimalFormat.format(f5) + " ): ");
        jLabel.addKeyListener(eventListener);
        this.upperTextField = new JTextField(5);
        this.upperTextField.addKeyListener(eventListener);
        this.upperTextField.setText("" + f);
        this.midLabel = new JLabel("Midpoint Value ( median data value = " + decimalFormat.format(f6) + " ): ");
        this.midLabel.addKeyListener(eventListener);
        this.midTextField = new JTextField(5);
        this.midTextField.addKeyListener(eventListener);
        this.midTextField.setText("" + f3);
        JLabel jLabel2 = new JLabel("Lower Limit ( min. data value = " + decimalFormat.format(f4) + " ): ");
        jLabel2.addKeyListener(eventListener);
        this.lowerTextField = new JTextField(5);
        this.lowerTextField.addKeyListener(eventListener);
        this.lowerTextField.setText("" + f2);
        JButton jButton = new JButton("Update Limits");
        jButton.setPreferredSize(new Dimension(130, 30));
        jButton.setFocusPainted(false);
        jButton.setActionCommand("update-command");
        jButton.addActionListener(eventListener);
        ParameterPanel parameterPanel2 = new ParameterPanel("Color Range Selection");
        parameterPanel2.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel2.add((Component)jLabel2, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 10), 0, 0));
        parameterPanel2.add((Component)this.lowerTextField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
        parameterPanel2.add((Component)this.midLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        parameterPanel2.add((Component)this.midTextField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel2.add((Component)jLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 25, 10), 0, 0));
        parameterPanel2.add((Component)this.upperTextField, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 25, 0), 0, 0));
        parameterPanel2.add((Component)jButton, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        ParameterPanel parameterPanel3 = new ParameterPanel("Gradient and Limits Preview");
        parameterPanel3.setLayout((LayoutManager)new GridBagLayout());
        this.gradientPreviewPanel = new GradientPreviewPanel(iFramework);
        parameterPanel3.add((Component)this.gradientPreviewPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)((Object)this.statsPanel), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel);
        this.addWindowListener(eventListener);
        this.setActionListeners(eventListener);
        this.pack();
        this.setResizable(false);
        this.lowerTextField.grabFocus();
        this.lowerTextField.selectAll();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getUpperLimit() {
        return Float.parseFloat(this.upperTextField.getText());
    }

    public float getLowerLimit() {
        return Float.parseFloat(this.lowerTextField.getText());
    }

    public float getMidValue() {
        return Float.parseFloat(this.midTextField.getText());
    }

    public boolean getUseDoubleGradient() {
        return this.doubleGradientButton.isSelected();
    }

    public boolean isGradientStyleAltered() {
        return this.origDoubleGradient == this.doubleGradient;
    }

    public BufferedImage getPosImage() {
        return this.gradientPreviewPanel.getPosImage();
    }

    private void updateLimits() {
        if (this.validateValues()) {
            this.currMinValue = Float.parseFloat(this.lowerTextField.getText());
            this.currMaxValue = Float.parseFloat(this.upperTextField.getText());
            this.currMidValue = Float.parseFloat(this.midTextField.getText());
            this.formattedLower = this.twoDecimalFormat.format(this.currMinValue);
            this.formattedUpper = this.twoDecimalFormat.format(this.currMaxValue);
            this.formattedMid = this.twoDecimalFormat.format(this.currMidValue);
            this.statsPanel.updateStats(this.currMinValue, this.currMaxValue);
            this.menubar.setUseDoubleGradient(this.getUseDoubleGradient());
            this.menubar.setMaxRatioScale(this.currMaxValue);
            this.menubar.setMinRatioScale(this.currMinValue);
            this.menubar.setMidRatioValue(this.currMidValue);
            this.framework.refreshCurrentViewer();
            this.repaint();
        }
    }

    private BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    private boolean validateValues() {
        int n = 0;
        boolean bl = false;
        try {
            float f = Float.parseFloat(this.lowerTextField.getText());
            ++n;
            float f2 = Float.parseFloat(this.upperTextField.getText());
            ++n;
            float f3 = Float.parseFloat(this.midTextField.getText());
            if (this.doubleGradient) {
                if (f < f3 && f3 < f2) {
                    bl = true;
                }
            } else if (f < f2) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Input Error, Values cannot be parsed as floating point numbers.", "Input Error", 0);
        }
        if (!bl) {
            if (this.doubleGradient) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Input Error (Double Gradient), Value Limits:  floating point number, lower < mid < upper", "Input Error", 0);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Input Error (Single Gradient), Value Limits:  floating point number, lower limit < upper limit", "Input Error", 0);
            }
        }
        return bl;
    }

    private void resetControls() {
        this.upperTextField.setText(String.valueOf(this.origUpper));
        this.lowerTextField.setText(String.valueOf(this.origLower));
        this.midTextField.setText(String.valueOf(this.origMid));
        if (this.origDoubleGradient) {
            this.doubleGradientButton.setSelected(true);
        } else {
            this.singleGradientButton.setSelected(true);
        }
        this.doubleGradient = this.origDoubleGradient;
        this.midLabel.setEnabled(this.origDoubleGradient);
        this.midTextField.setEnabled(this.origDoubleGradient);
        this.updateLimits();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (SetRatioScaleDialog.this.validateValues()) {
                    SetRatioScaleDialog.this.result = 0;
                    SetRatioScaleDialog.this.dispose();
                }
            } else if (string.equals("cancel-command")) {
                SetRatioScaleDialog.this.result = 2;
                SetRatioScaleDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                SetRatioScaleDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)SetRatioScaleDialog.this), "Color Scale Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(575, 550);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            } else if (string.equals("update-command")) {
                SetRatioScaleDialog.this.updateLimits();
            } else if (string.equals("change-gradient-command")) {
                SetRatioScaleDialog.this.doubleGradient = SetRatioScaleDialog.this.doubleGradientButton.isSelected();
                if (SetRatioScaleDialog.this.doubleGradient) {
                    BufferedImage bufferedImage = SetRatioScaleDialog.this.createGradientImage(new Color(SetRatioScaleDialog.this.gradientPreviewPanel.getNegImage().getRGB(255, 0)), new Color(SetRatioScaleDialog.this.gradientPreviewPanel.getPosImage().getRGB(255, 0)));
                    SetRatioScaleDialog.this.gradientPreviewPanel.setPosImage(bufferedImage);
                }
                SetRatioScaleDialog.this.midLabel.setEnabled(SetRatioScaleDialog.this.doubleGradient);
                SetRatioScaleDialog.this.midTextField.setEnabled(SetRatioScaleDialog.this.doubleGradient);
                SetRatioScaleDialog.this.repaint();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetRatioScaleDialog.this.result = -1;
            SetRatioScaleDialog.this.dispose();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    Float.parseFloat(SetRatioScaleDialog.this.lowerTextField.getText());
                    Float.parseFloat(SetRatioScaleDialog.this.upperTextField.getText());
                    SetRatioScaleDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetRatioScaleDialog.this.result = 2;
                }
                SetRatioScaleDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class StatsPanel
    extends ParameterPanel {
        private JTextField offScaleField;
        private JTextField lowEndField;
        private JTextField highEndField;
        private JTextField offScalePercentField;
        private JTextField lowEndPercentField;
        private JTextField highEndPercentField;
        private float[] sortedValues;
        private DecimalFormat format;

        public StatsPanel(IFramework iFramework) {
            super("Color Saturation Statistics");
            this.setLayout(new GridBagLayout());
            this.format = new DecimalFormat();
            this.format.setMaximumIntegerDigits(3);
            this.format.setMaximumFractionDigits(1);
            this.format.setMinimumFractionDigits(1);
            JLabel jLabel = new JLabel("Number");
            jLabel.setOpaque(false);
            JLabel jLabel2 = new JLabel("Percent");
            jLabel2.setOpaque(false);
            JLabel jLabel3 = new JLabel("Elements Off Color Scale");
            JLabel jLabel4 = new JLabel("Elements Below Lower Limit");
            JLabel jLabel5 = new JLabel("Elements Above Upper Limit");
            this.offScaleField = new JTextField(5);
            this.offScaleField.setBackground(Color.lightGray);
            this.offScaleField.setEditable(false);
            this.offScaleField.setHorizontalAlignment(4);
            this.lowEndField = new JTextField(5);
            this.lowEndField.setBackground(Color.lightGray);
            this.lowEndField.setEditable(false);
            this.lowEndField.setHorizontalAlignment(4);
            this.highEndField = new JTextField(5);
            this.highEndField.setBackground(Color.lightGray);
            this.highEndField.setEditable(false);
            this.highEndField.setHorizontalAlignment(4);
            this.offScalePercentField = new JTextField(5);
            this.offScalePercentField.setBackground(Color.lightGray);
            this.offScalePercentField.setEditable(false);
            this.offScalePercentField.setHorizontalAlignment(4);
            this.lowEndPercentField = new JTextField(5);
            this.lowEndPercentField.setBackground(Color.lightGray);
            this.lowEndPercentField.setEditable(false);
            this.lowEndPercentField.setHorizontalAlignment(4);
            this.highEndPercentField = new JTextField(5);
            this.highEndPercentField.setBackground(Color.lightGray);
            this.highEndPercentField.setEditable(false);
            this.highEndPercentField.setHorizontalAlignment(4);
            this.sortedValues = this.initSortedValues(iFramework.getData().getExperiment().getMatrix());
            this.updateStats(SetRatioScaleDialog.this.origLower, SetRatioScaleDialog.this.origUpper);
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
            this.add(jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 10), 0, 0));
            this.add(jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 0), 0, 0));
            this.add(jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 20), 0, 0));
            this.add(this.offScaleField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
            this.add(this.offScalePercentField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            JSeparator jSeparator = new JSeparator(0);
            jSeparator.setPreferredSize(new Dimension(200, 1));
            jSeparator.setOpaque(true);
            this.add(jSeparator, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add(jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 20), 0, 0));
            this.add(this.lowEndField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 10), 0, 0));
            this.add(this.lowEndPercentField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add(jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 20), 0, 0));
            this.add(this.highEndField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 10), 0, 0));
            this.add(this.highEndPercentField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        private float[] initSortedValues(FloatMatrix floatMatrix) {
            int n;
            float[] fArray = floatMatrix.getColumnPackedCopy();
            QSort qSort = new QSort(fArray, 1);
            fArray = qSort.getSorted();
            int n2 = 0;
            for (n = 0; n < fArray.length && Float.isNaN(fArray[n]); ++n) {
                ++n2;
            }
            n = fArray.length - n2;
            float[] fArray2 = new float[n];
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i] = fArray[i + n2];
            }
            return fArray2;
        }

        public float getMedian() {
            float f = this.sortedValues.length % 2 == 0 ? (this.sortedValues[this.sortedValues.length / 2] + this.sortedValues[this.sortedValues.length / 2 + 1]) / 2.0f : this.sortedValues[this.sortedValues.length / 2 + 1];
            return f;
        }

        public void updateStats(float f, float f2) {
            int n = this.getLowCount(f);
            int n2 = this.getHighCount(f2);
            float f3 = (float)n / (float)this.sortedValues.length * 100.0f;
            float f4 = (float)n2 / (float)this.sortedValues.length * 100.0f;
            float f5 = (float)(n + n2) / (float)this.sortedValues.length * 100.0f;
            this.offScaleField.setText(String.valueOf(n + n2));
            this.offScalePercentField.setText(this.format.format(f5));
            this.lowEndField.setText(String.valueOf(n));
            this.lowEndPercentField.setText(this.format.format(f3));
            this.highEndField.setText(String.valueOf(n2));
            this.highEndPercentField.setText(this.format.format(f4));
        }

        private int getLowCount(float f) {
            int n;
            for (n = 0; n < this.sortedValues.length && this.sortedValues[n] < f; ++n) {
            }
            return n;
        }

        private int getHighCount(float f) {
            int n = this.sortedValues.length - 1;
            int n2 = 0;
            while (n > -1 && this.sortedValues[n] > f) {
                --n;
                ++n2;
            }
            return n2;
        }
    }

    private class GradientPreviewPanel
    extends JPanel {
        private BufferedImage negImage;
        private BufferedImage posImage;
        private String centerPointStr;
        private int TIC_HEIGHT = 35;
        private int GRAD_HEIGHT = 30;
        private int TEXT_BUFFER = 20;
        private Insets insets = new Insets(5, 5, 5, 5);

        public GradientPreviewPanel(IFramework iFramework) {
            this.negImage = iFramework.getDisplayMenu().getNegativeGradientImage();
            this.posImage = iFramework.getDisplayMenu().getPositiveGradientImage();
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            super.setPreferredSize(new Dimension(this.negImage.getWidth() + this.posImage.getWidth() + this.insets.left + this.insets.right, this.GRAD_HEIGHT + this.insets.top + this.insets.bottom + this.TEXT_BUFFER));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = this.negImage.getWidth() + this.posImage.getWidth();
            if (SetRatioScaleDialog.this.doubleGradient) {
                graphics.drawImage(this.negImage, this.insets.left, this.insets.top, this.negImage.getWidth(), this.GRAD_HEIGHT, null);
                graphics.drawImage(this.posImage, this.insets.left + this.negImage.getWidth() + 1, this.insets.top, this.posImage.getWidth(), this.GRAD_HEIGHT, null);
                graphics.drawLine(this.insets.left + this.negImage.getWidth(), this.insets.top, this.insets.left + this.negImage.getWidth(), this.insets.top + this.TIC_HEIGHT);
                graphics.drawLine(this.insets.left + this.negImage.getWidth() - 1, this.insets.top, this.insets.left + this.negImage.getWidth() - 1, this.insets.top + this.TIC_HEIGHT);
                graphics.drawLine(this.insets.left + this.negImage.getWidth() + 1, this.insets.top, this.insets.left + this.negImage.getWidth() + 1, this.insets.top + this.TIC_HEIGHT);
                graphics.drawString(SetRatioScaleDialog.this.formattedMid, this.insets.left + this.negImage.getWidth() - (int)((float)fontMetrics.stringWidth(SetRatioScaleDialog.this.formattedMid) / 2.0f), this.insets.top + this.TIC_HEIGHT + fontMetrics.getHeight());
            } else {
                graphics.drawImage(this.posImage, this.insets.left, this.insets.top, n, this.GRAD_HEIGHT, null);
            }
            graphics.drawLine(this.insets.left, this.insets.top, this.insets.left, this.insets.top + this.TIC_HEIGHT);
            graphics.drawLine(this.insets.left + 1, this.insets.top, this.insets.left + 1, this.insets.top + this.TIC_HEIGHT);
            graphics.drawLine(this.insets.left + 2, this.insets.top, this.insets.left + 2, this.insets.top + this.TIC_HEIGHT);
            graphics.drawLine(this.insets.left + n, this.insets.top, this.insets.left + n, this.insets.top + this.TIC_HEIGHT);
            graphics.drawLine(this.insets.left + n - 1, this.insets.top, this.insets.left + n - 1, this.insets.top + this.TIC_HEIGHT);
            graphics.drawLine(this.insets.left + n - 2, this.insets.top, this.insets.left + n - 2, this.insets.top + this.TIC_HEIGHT);
            graphics.drawString(SetRatioScaleDialog.this.formattedLower, this.insets.left, this.insets.top + this.TIC_HEIGHT + fontMetrics.getHeight());
            graphics.drawString(SetRatioScaleDialog.this.formattedUpper, this.insets.left + n - fontMetrics.stringWidth(SetRatioScaleDialog.this.formattedUpper), this.insets.top + this.TIC_HEIGHT + fontMetrics.getHeight());
        }

        public void setPosImage(BufferedImage bufferedImage) {
            this.posImage = bufferedImage;
            this.repaint();
        }

        public BufferedImage getPosImage() {
            return this.posImage;
        }

        public BufferedImage getNegImage() {
            return this.negImage;
        }
    }
}

