/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit;

import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.ClusterArchiveSelectionDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.IClusterSubmitter;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.RepositoryConfigParser;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class SubmissionManager {
    private RepositoryConfigParser parser;
    private ClusterRepository repository;
    private IFramework framework;

    public SubmissionManager(IFramework iFramework, ClusterRepository clusterRepository) {
        this.framework = iFramework;
        this.repository = clusterRepository;
        this.parser = new RepositoryConfigParser();
    }

    public boolean submit(Cluster cluster) {
        boolean bl = false;
        if (!this.parser.parseSubmissionConfigFile()) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error parsing gene cluster submission configuration file, \n\"config/archive_submission_config.xml\"", "Submission Configuration File", 0);
            return false;
        }
        ClusterArchiveSelectionDialog clusterArchiveSelectionDialog = new ClusterArchiveSelectionDialog(this.parser);
        if (clusterArchiveSelectionDialog.showModal() == 0) {
            String string = clusterArchiveSelectionDialog.getSelectedRepositoryName();
            String string2 = this.parser.getRepositorySubmissionClass(string);
            try {
                this.getClass();
                IClusterSubmitter iClusterSubmitter = (IClusterSubmitter)Class.forName(string2).newInstance();
                bl = iClusterSubmitter.submit(cluster, this.framework, this.parser);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }
}

