/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit.lola;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.IClusterSubmitter;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.RepositoryConfigParser;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.lola.LOLADialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.lola.LOLAPasswordDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.lola.connLOLA;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;

public class LOLASubmitter
implements IClusterSubmitter {
    private Cluster cluster;
    private IFramework framework;
    private RepositoryConfigParser parser;
    private Submitter submitter;
    private Thread thread;
    private boolean stop = false;

    public boolean submit(Cluster cluster, IFramework iFramework, RepositoryConfigParser repositoryConfigParser) {
        this.cluster = cluster;
        this.framework = iFramework;
        this.parser = repositoryConfigParser;
        try {
            this.submitter = new Submitter();
            this.thread = new Thread(this.submitter);
            this.thread.start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Error starting the submission thread, submission aborted", "Submission Thread Error", 0);
            return false;
        }
        return true;
    }

    private float[] getFolds(IData iData, Cluster cluster, String[] stringArray, int[] nArray) {
        int n = stringArray.length;
        int[] nArray2 = cluster.getIndices();
        float[] fArray = new float[n];
        float[] fArray2 = new float[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = iData.getRatio(j, nArray2[i], 0);
            }
            fArray2[i] = this.get_fold(fArray, nArray);
        }
        return fArray2;
    }

    private float get_fold(float[] fArray, int[] nArray) {
        float[] fArray2 = new float[3];
        fArray2[2] = 0.0f;
        fArray2[1] = 0.0f;
        fArray2[0] = 0.0f;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (nArray[i] == 0) {
                ++n2;
            } else if (nArray[i] == 1) {
                ++n;
            }
            int n3 = nArray[i];
            fArray2[n3] = fArray2[n3] + fArray[i];
        }
        fArray2[0] = fArray2[0] / (float)n2;
        fArray2[1] = fArray2[1] / (float)n;
        return fArray2[0] / fArray2[1];
    }

    private String constructGeneList(IData iData, int[] nArray, float[] fArray) {
        String string = new String();
        for (int i = 0; i < nArray.length; ++i) {
            string = string + iData.getElementAttribute(nArray[i], 0) + "\t" + fArray[i] + "\n";
        }
        return string;
    }

    private class SubmissionListener
    extends DialogListener {
        private SubmissionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (LOLASubmitter.this.thread != null) {
                LOLASubmitter.this.stop = true;
            }
        }
    }

    private class Submitter
    implements Runnable {
        private Submitter() {
        }

        public void run() {
            Logger logger = new Logger(LOLASubmitter.this.framework.getFrame(), "LOLA Submission Log", (DialogListener)new SubmissionListener());
            logger.show();
            logger.append("Begin LOLA Submission Process\n");
            IData iData = LOLASubmitter.this.framework.getData();
            logger.append("Data Type Verification\n");
            if (iData.getDataType() != 2 && iData.getDataType() != 3 && iData.getDataType() != 4 && iData.getDataType() != 5) {
                JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "The Data Type must be Human Affymetrix data to comply with the LOLA repository.", "Data Type Mismatch Error", 0);
                return;
            }
            if (LOLASubmitter.this.stop) {
                return;
            }
            logger.append("Extract Sample Names\n");
            Experiment experiment = LOLASubmitter.this.cluster.getExperiment();
            int n = experiment.getNumberOfSamples();
            int[] nArray = experiment.getColumnIndicesCopy();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = iData.getSampleName(nArray[i]);
            }
            logger.append("Get User Login Info\n");
            Hashtable hashtable = LOLASubmitter.this.parser.getUserInfo("LOLA");
            String string = (String)hashtable.get("email");
            String string2 = (String)hashtable.get("password");
            LOLAPasswordDialog lOLAPasswordDialog = new LOLAPasswordDialog(string, string2);
            if (LOLASubmitter.this.stop) {
                return;
            }
            if (lOLAPasswordDialog.showModal() != 0) {
                JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Submission aborted prior to login.", "Abort LOLA Submission", 1);
                return;
            }
            string = lOLAPasswordDialog.getUserName();
            string2 = lOLAPasswordDialog.getPassword();
            logger.append("Collect Grouping Information and Fold Changes\n");
            LOLADialog lOLADialog = new LOLADialog("Export Gene List to LOLA", stringArray, LOLASubmitter.this.cluster);
            if (lOLADialog.showModal() == 0) {
                int[] nArray2 = lOLADialog.getGroupAssignments();
                float[] fArray = LOLASubmitter.this.getFolds(iData, LOLASubmitter.this.cluster, stringArray, nArray2);
                logger.append("Construct Gene List\n");
                String string3 = LOLASubmitter.this.constructGeneList(iData, LOLASubmitter.this.cluster.getIndices(), fArray);
                if (LOLASubmitter.this.stop) {
                    return;
                }
                if (string != null && string2 != null) {
                    connLOLA connLOLA2 = new connLOLA(string, string2);
                    logger.append("Login to LOLA\n");
                    String string4 = connLOLA2.login();
                    if (LOLASubmitter.this.stop) {
                        return;
                    }
                    if (string4.equals("")) {
                        JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Error during login to LOLA.  Please go to http://lola.gwu.edu to establish an account.\nIf you have an account please try again. You may Edit the user information for LOLA in the archive_submission_config.xml (in the config folder) to reflect\nyour email and LOLA password so that MeV will retain this information for you.", "LOLA Login Error", 0);
                        return;
                    }
                    logger.append("Login Complete\n");
                    logger.append("Submit List\n");
                    if (!connLOLA2.submit_list(LOLASubmitter.this.cluster.getClusterLabel(), LOLASubmitter.this.cluster.getClusterDescription(), string3)) {
                        JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "After login, an error occurred during list submission to LOLA.\nPlease check that the primary identifiers are Affy ID's or LocusLink.\nThe submission page for LOLA describes the submission requirements.", "LOLA Submission Error", 0);
                        return;
                    }
                    logger.append("Commit List\n");
                    connLOLA2.create_list();
                    logger.append("Logout from LOLA\n");
                    connLOLA2.logout();
                    JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Submission to LOLA completed successfully.  Thank you.", "LOLA Submission Confirmation", 1);
                    logger.append("Record Submission to History Node\n");
                    LOLASubmitter.this.framework.addHistory("Gene submission to LOLA, Cluster #" + LOLASubmitter.this.cluster.getSerialNumber() + ", containing " + LOLASubmitter.this.cluster.getSize() + " genes.");
                    logger.dispose();
                } else {
                    JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Error during login to LOLA.  No login information available.  Please go to http://lola.gwu.edu to establish an account.\nIf you have an account edit the user information for LOLA in the archive_submission_config.xml (in the config folder) to reflect\nyour email and LOLA password.", "LOLA Login Error", 0);
                    return;
                }
            }
        }
    }
}

