/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.file.agilent.AgilentFeature;
import org.tigr.microarray.mev.file.agilent.EightFeature;
import org.tigr.microarray.mev.file.agilent.TopFeature;
import org.tigr.microarray.mev.file.agilent.UnrecognizedPatternException;

public class AgilentFile {
    static final int EIGHT_COL = 8;
    static final int NINE_COL = 9;
    private int patternType;
    private Vector vAgilentFeature;
    private File file;

    public AgilentFile(Vector vector) throws UnrecognizedPatternException {
        String string = (String)vector.elementAt(0);
        this.patternType = this.characterizePattern(string);
        this.setVAgilentFeature(new Vector());
        for (int i = 1; i < vector.size(); ++i) {
            AgilentFeature agilentFeature;
            String string2 = (String)vector.elementAt(i);
            if (this.patternType == 8) {
                agilentFeature = new EightFeature(string2);
                this.getVAgilentFeature().add(agilentFeature);
                continue;
            }
            if (this.patternType != 9) continue;
            agilentFeature = new TopFeature(string2);
            this.getVAgilentFeature().add(agilentFeature);
        }
    }

    public int characterizePattern(String string) throws UnrecognizedPatternException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = stringTokenizer.countTokens();
        if (n == 8) {
            return 8;
        }
        if (n == 9) {
            return 9;
        }
        throw new UnrecognizedPatternException(string + " unrecognized");
    }

    public void setPatternType(int n) {
        this.patternType = n;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public String getPatternName() {
        return this.file.getName();
    }

    public void setVAgilentFeature(Vector vector) {
        this.vAgilentFeature = vector;
    }

    public Vector getVAgilentFeature() {
        return this.vAgilentFeature;
    }
}

