/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script;

import java.awt.Frame;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.SetDetectionFilterDialog;
import org.tigr.microarray.mev.SetFoldFilterDialog;
import org.tigr.microarray.mev.SetLowerCutoffsDialog;
import org.tigr.microarray.mev.SetPercentageCutoffsDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.script.Script;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.scriptGUI.CentroidEntropyRankingInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.DiversityRankingInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.microarray.mev.script.scriptGUI.ScriptAlgorithmInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.ScriptAttributeDialog;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTable;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTreeViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptXMLViewer;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.ErrorLog;
import org.tigr.microarray.mev.script.util.ParameterAttributes;
import org.tigr.microarray.mev.script.util.ParameterValidator;
import org.tigr.microarray.mev.script.util.ScriptNode;
import org.tigr.microarray.mev.script.util.ScriptRunner;
import org.tigr.microarray.mev.script.util.ScriptTree;

public class ScriptManager
implements Serializable {
    public static final long serialVersionUID = 10001020103010001L;
    private DefaultMutableTreeNode scriptManagerNode;
    private ActionManager actionManager;
    private ScriptTable table;
    private int scriptNum;
    private IFramework framework;
    private ParameterValidator validator;
    private Progress progress;
    private Vector scripts;

    public ScriptManager(IFramework iFramework, DefaultMutableTreeNode defaultMutableTreeNode, ActionManager actionManager) {
        this.framework = iFramework;
        this.actionManager = actionManager;
        this.scriptManagerNode = defaultMutableTreeNode;
        this.scripts = new Vector();
        this.scriptNum = 1;
    }

    public ScriptManager() {
    }

    public void loadScript() {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile("data/scripts/"));
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(this.framework.getFrame()) == 0) {
            this.loadXML(jFileChooser.getSelectedFile());
        }
    }

    public void loadXML(File file) {
        Thread thread = new Thread(new ThreadHandler(file));
        thread.setPriority(1);
        this.progress = new Progress(this.framework.getFrame(), "Script Loading and Validation", null);
        this.progress.show();
        thread.start();
    }

    private boolean loadScript(File file) {
        Serializable serializable;
        ScriptTree scriptTree;
        ScriptDocument scriptDocument = new ScriptDocument(this.scriptNum, file.getPath(), this);
        ErrorLog errorLog = scriptDocument.getErrorLog();
        boolean bl = false;
        try {
            scriptDocument.loadXMLFile(file, this.progress);
            if (scriptDocument.getErrorCount() > 0) {
                if (errorLog.hasErrors() || errorLog.hasFatalErrors()) {
                    bl = true;
                    this.progress.dispose();
                }
                errorLog.reportAllListings();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Script loading has been aborted due to parse errors.", "Script Parse Error", 1);
            this.progress.dispose();
            return false;
        }
        if (bl) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Script loading has been aborted.  If the script has been \nrepaired to correct the errors you can attempt to load it again.", "Script Validation Error", 1);
            return false;
        }
        scriptDocument.setDocumentFileName(file.getPath());
        if (this.validator == null) {
            this.validator = new ParameterValidator();
            this.validator.loadParameterConstraints();
        }
        if (!this.validateParameters(scriptTree = new ScriptTree(scriptDocument, this), errorLog)) {
            this.progress.dispose();
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Script loading has been aborted.  If the script has been \nrepaired to correct the errors you can attempt to load it again.", "Parmameter Validataion Error", 1);
            return false;
        }
        if (this.table == null) {
            this.table = new ScriptTable(this, this.scripts);
            serializable = new DefaultMutableTreeNode(new LeafInfo("Script Table", (IViewer)this.table));
            this.framework.addNode(this.scriptManagerNode, (DefaultMutableTreeNode)serializable);
        }
        serializable = new ScriptTreeViewer(scriptTree, this);
        ScriptXMLViewer scriptXMLViewer = new ScriptXMLViewer(scriptDocument, this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Script (" + this.scriptNum + ")"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Script Tree Viewer", (IViewer)serializable));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new LeafInfo("Script XML Viewer", (IViewer)scriptXMLViewer));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this.scripts.add(new Script(scriptDocument, scriptTree, scriptXMLViewer));
        this.framework.addNode(this.scriptManagerNode, defaultMutableTreeNode);
        this.framework.setTreeNode(defaultMutableTreeNode2);
        ++this.scriptNum;
        this.validator.checkAlgorithmsForDataDependance(scriptTree, this);
        return true;
    }

    public void addNewScript() {
        ScriptAttributeDialog scriptAttributeDialog = new ScriptAttributeDialog();
        if (scriptAttributeDialog.showModal() == 0) {
            Serializable serializable;
            ScriptDocument scriptDocument = new ScriptDocument(this.scriptNum, scriptAttributeDialog.getName(), scriptAttributeDialog.getFormattedDescription(), scriptAttributeDialog.getDate(), this);
            if (this.table == null) {
                this.table = new ScriptTable(this, this.scripts);
                serializable = new DefaultMutableTreeNode(new LeafInfo("Script Table", (IViewer)this.table));
                this.framework.addNode(this.scriptManagerNode, (DefaultMutableTreeNode)serializable);
                this.validator = new ParameterValidator();
                this.validator.loadParameterConstraints();
            }
            serializable = new ScriptTree(scriptDocument, this);
            ScriptTreeViewer scriptTreeViewer = new ScriptTreeViewer((ScriptTree)serializable, this);
            ScriptXMLViewer scriptXMLViewer = new ScriptXMLViewer(scriptDocument, this);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Script (" + this.scriptNum + ")"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Script Tree Viewer", (IViewer)scriptTreeViewer));
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new LeafInfo("Script XML Viewer", (IViewer)scriptXMLViewer));
            this.scripts.add(new Script(scriptDocument, (ScriptTree)serializable, scriptXMLViewer));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            this.framework.addNode(this.scriptManagerNode, defaultMutableTreeNode);
            this.framework.setTreeNode(defaultMutableTreeNode2);
            ++this.scriptNum;
        }
    }

    public int getNextScriptID() {
        ++this.scriptNum;
        return this.scriptNum;
    }

    public void saveScript(ScriptDocument scriptDocument) {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile("data/scripts/"));
        if (jFileChooser.showSaveDialog(new JFrame()) == 0) {
            try {
                this.writeScript(jFileChooser.getSelectedFile(), scriptDocument);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(new JFrame(), "An error occured while saving the script to file", "Save Error", 2);
            }
        }
    }

    private void writeScript(File file, ScriptDocument scriptDocument) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(scriptDocument.toString());
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public AlgorithmData getAlgorithm(String string) {
        ScriptAlgorithmInitDialog scriptAlgorithmInitDialog;
        AlgorithmData algorithmData = null;
        if (this.framework.getData().getFeaturesCount() == 0) {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setContentType("text/html");
            jTextPane.setMargin(new Insets(5, 15, 15, 15));
            String string2 = "<html><center><h2>Expression Data Unavailable</h2></center><hr size=3>";
            string2 = string2 + "<center>Expression data has not been loaded.  Some algorithms require information about the <br> number and order of loaded experiments in order to set parameters such as group assignments. <br><br><b>Please load data before proceeding with script construction.</b></center></html>";
            jTextPane.setText(string2);
            JOptionPane.showMessageDialog(this.framework.getFrame(), jTextPane, "Data Unavailable", 1);
            return null;
        }
        int n = this.framework.getData().getDataType();
        boolean bl = false;
        if (n == 2 || n == 3 || n == 4 || n == 5) {
            bl = true;
        }
        if ((scriptAlgorithmInitDialog = new ScriptAlgorithmInitDialog(this.actionManager, string, bl)).showModal() == 0) {
            String string3 = scriptAlgorithmInitDialog.getAlgorithmName();
            String string4 = scriptAlgorithmInitDialog.getAlgorithmType();
            if (string4.equals("cluster")) {
                int n2 = scriptAlgorithmInitDialog.getAlgorithmIndex();
                Action action = this.actionManager.getAction("analysis-action" + String.valueOf(n2));
                if (action == null) {
                    return null;
                }
                String string5 = (String)action.getValue("command-parameter");
                try {
                    Class<?> clazz = Class.forName(string5);
                    IScriptGUI iScriptGUI = (IScriptGUI)clazz.newInstance();
                    algorithmData = iScriptGUI.getScriptParameters(this.framework);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "Can't retrieve script parameters for the " + string3 + " algorithm", "Script Parameter Error", 2);
                    exception.printStackTrace();
                }
            } else if (string4.equals("data-adjustment")) {
                if (string3.equals("Percentage Cutoff")) {
                    SetPercentageCutoffsDialog setPercentageCutoffsDialog = new SetPercentageCutoffsDialog(new JFrame(), 0.0f);
                    if (setPercentageCutoffsDialog.showModal() == 0) {
                        algorithmData = new AlgorithmData();
                        algorithmData.addParam("name", string3);
                        float f = setPercentageCutoffsDialog.getPercentageCutoff();
                        algorithmData.addParam("percent-cutoff", String.valueOf(f));
                        this.setAdjustmentOutput(algorithmData);
                    }
                } else if (string3.equals("Lower Cutoffs")) {
                    SetLowerCutoffsDialog setLowerCutoffsDialog = new SetLowerCutoffsDialog(new JFrame(), 0.0f, 0.0f);
                    if (setLowerCutoffsDialog.showModal() == 0) {
                        algorithmData = new AlgorithmData();
                        algorithmData.addParam("name", string3);
                        algorithmData.addParam("cy3-lower-cutoff", String.valueOf(setLowerCutoffsDialog.getLowerCY3Cutoff()));
                        algorithmData.addParam("cy5-lower-cutoff", String.valueOf(setLowerCutoffsDialog.getLowerCY5Cutoff()));
                        this.setAdjustmentOutput(algorithmData);
                    }
                } else if (string3.equals("Detection Filter")) {
                    algorithmData = new AlgorithmData();
                    IData iData = this.framework.getData();
                    int n3 = iData.getFeaturesCount();
                    String[] stringArray = new String[n3];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = iData.getSampleName(i);
                    }
                    SetDetectionFilterDialog setDetectionFilterDialog = new SetDetectionFilterDialog(new JFrame(), stringArray, new DetectionFilter(stringArray));
                    if (setDetectionFilterDialog.showModal() == 0) {
                        DetectionFilter detectionFilter = setDetectionFilterDialog.getDetectionFilter();
                        int[] nArray = new int[n3];
                        int[] nArray2 = new int[n3];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = detectionFilter.get_group_membership(i);
                            nArray2[i] = detectionFilter.get_num_required(i);
                        }
                        algorithmData.addParam("name", "Affy Detection Filter");
                        algorithmData.addIntArray("group-memberships", nArray);
                        algorithmData.addIntArray("number-required", nArray2);
                        algorithmData.addParam("is-required-in-both-groups", String.valueOf(detectionFilter.get_both()));
                        this.setAdjustmentOutput(algorithmData);
                    }
                } else if (string3.equals("Fold Filter")) {
                    algorithmData = new AlgorithmData();
                    IData iData = this.framework.getData();
                    int n4 = iData.getFeaturesCount();
                    String[] stringArray = new String[n4];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = iData.getSampleName(i);
                    }
                    SetFoldFilterDialog setFoldFilterDialog = new SetFoldFilterDialog(new JFrame(), stringArray, new FoldFilter(stringArray));
                    if (setFoldFilterDialog.showModal() == 0) {
                        FoldFilter foldFilter = setFoldFilterDialog.getFoldFilter();
                        int[] nArray = new int[n4];
                        int[] nArray3 = new int[n4];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = foldFilter.get_group_membership(i);
                            nArray3[i] = foldFilter.get_num_members(i);
                        }
                        algorithmData.addParam("name", "Affy Fold Filter");
                        algorithmData.addIntArray("group-memberships", nArray);
                        algorithmData.addIntArray("number-of-members", nArray3);
                        algorithmData.addParam("fold-change", String.valueOf(foldFilter.get_fold_change()));
                        algorithmData.addParam("divider-string", foldFilter.get_divider());
                        this.setAdjustmentOutput(algorithmData);
                    }
                } else {
                    algorithmData = new AlgorithmData();
                    algorithmData.addParam("name", string3);
                    this.setAdjustmentOutput(algorithmData);
                }
            } else if (string4.equals("cluster-selection")) {
                CentroidEntropyRankingInitDialog centroidEntropyRankingInitDialog;
                if (string3.equals("Diversity Ranking Cluster Selection")) {
                    DiversityRankingInitDialog diversityRankingInitDialog = new DiversityRankingInitDialog(new JFrame());
                    if (diversityRankingInitDialog.showModal() == 0) {
                        algorithmData = new AlgorithmData();
                        algorithmData.addParam("name", string3);
                        algorithmData.addParam("desired-cluster-count", String.valueOf(diversityRankingInitDialog.getClusterNumber()));
                        algorithmData.addParam("minimum-cluster-size", String.valueOf(diversityRankingInitDialog.getClusterSize()));
                        algorithmData.addParam("use-centroid-variance", String.valueOf(diversityRankingInitDialog.isCentroidBased()));
                        int n5 = this.framework.getDistanceMenu().getDistanceFunction();
                        if (n5 == 0) {
                            n5 = 4;
                        }
                        algorithmData.addParam("distance-function", String.valueOf(n5));
                        algorithmData.addParam("use-absolute", String.valueOf(this.framework.getDistanceMenu().isAbsoluteDistance()));
                        if (string.equals("multi-gene-cluster-output")) {
                            algorithmData.addParam("process-gene-clusters", String.valueOf(true));
                        } else {
                            algorithmData.addParam("process-gene-clusters", String.valueOf(false));
                        }
                        this.setSelectionOutput(algorithmData);
                    }
                } else if (string3.equals("Centroid Entropy/Variance Ranking Cluster Selection") && (centroidEntropyRankingInitDialog = new CentroidEntropyRankingInitDialog(new JFrame())).showModal() == 0) {
                    algorithmData = new AlgorithmData();
                    algorithmData.addParam("name", string3);
                    algorithmData.addParam("desired-cluster-count", String.valueOf(centroidEntropyRankingInitDialog.getClusterNumber()));
                    algorithmData.addParam("minimum-cluster-size", String.valueOf(centroidEntropyRankingInitDialog.getClusterSize()));
                    algorithmData.addParam("use-centroid-variance", String.valueOf(centroidEntropyRankingInitDialog.isVarianceBased()));
                    int n6 = this.framework.getDistanceMenu().getDistanceFunction();
                    if (n6 == 0) {
                        n6 = 4;
                    }
                    algorithmData.addParam("distance-function", String.valueOf(n6));
                    algorithmData.addParam("use-absolute", String.valueOf(this.framework.getDistanceMenu().isAbsoluteDistance()));
                    if (string.equals("multi-gene-cluster-output")) {
                        algorithmData.addParam("process-gene-clusters", String.valueOf(true));
                    } else {
                        algorithmData.addParam("process-gene-clusters", String.valueOf(false));
                    }
                    this.setSelectionOutput(algorithmData);
                }
            }
        }
        return algorithmData;
    }

    private void setAdjustmentOutput(AlgorithmData algorithmData) {
        String[] stringArray = new String[]{"Single Adjusted Ouput"};
        algorithmData.addStringArray("output-nodes", stringArray);
        algorithmData.addParam("output-class", "single-output");
        algorithmData.addParam("alg-type", "data-adjustment");
    }

    private void setSelectionOutput(AlgorithmData algorithmData) {
        int n = algorithmData.getParams().getInt("desired-cluster-count");
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "Selected Cluster (" + String.valueOf(i + 1) + ") ";
        }
        algorithmData.addStringArray("output-nodes", stringArray);
        algorithmData.addParam("output-class", "cluster-selection-output");
        algorithmData.addParam("alg-type", "cluster-selection");
    }

    public void viewSelectedNodeXML(ScriptTreeViewer scriptTreeViewer, ScriptNode scriptNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSiblingXMLNode(scriptTreeViewer);
        if (defaultMutableTreeNode != null) {
            IViewer iViewer = ((LeafInfo)defaultMutableTreeNode.getUserObject()).getViewer();
            if (!(iViewer instanceof ScriptXMLViewer)) {
                return;
            }
            ScriptXMLViewer scriptXMLViewer = (ScriptXMLViewer)iViewer;
            scriptXMLViewer.update();
            if (scriptNode instanceof AlgorithmNode) {
                scriptXMLViewer.highlightAlgorithmNode((AlgorithmNode)scriptNode);
            }
            this.framework.setTreeNode(defaultMutableTreeNode);
        }
    }

    public DefaultMutableTreeNode getSiblingXMLNode(ScriptTreeViewer scriptTreeViewer) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Enumeration<TreeNode> enumeration = this.scriptManagerNode.depthFirstEnumeration();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while (enumeration.hasMoreElements()) {
            IViewer iViewer;
            LeafInfo leafInfo;
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.isLeaf() || (leafInfo = (LeafInfo)defaultMutableTreeNode.getUserObject()) == null || leafInfo.getViewer() == null || (iViewer = leafInfo.getViewer()) != scriptTreeViewer) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        }
        if (defaultMutableTreeNode2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()).getChildCount() > 1) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
            return defaultMutableTreeNode;
        }
        return null;
    }

    public void runScript(int n) {
        if (n >= this.scripts.size()) {
            return;
        }
        Script script = (Script)this.scripts.elementAt(n);
        ScriptRunner scriptRunner = new ScriptRunner(script, this.actionManager, this.framework);
        scriptRunner.setOutputMode(0);
        scriptRunner.execute();
    }

    public void runScript(ScriptDocument scriptDocument) {
        Script script = this.getScriptObjectForDocument(scriptDocument);
        if (script == null) {
            return;
        }
        ScriptRunner scriptRunner = new ScriptRunner(script, this.actionManager, this.framework);
        scriptRunner.setOutputMode(0);
        scriptRunner.execute();
    }

    public Script getScriptObjectForDocument(ScriptDocument scriptDocument) {
        for (int i = 0; i < this.scripts.size(); ++i) {
            Script script = (Script)this.scripts.elementAt(i);
            if (script.getScriptDocument() != scriptDocument) continue;
            return script;
        }
        return null;
    }

    public Frame getFrame() {
        return this.framework.getFrame();
    }

    public Experiment getCurrentExperiment() {
        return this.framework.getData().getExperiment();
    }

    public boolean validateParameters(ScriptTree scriptTree, ErrorLog errorLog) {
        boolean bl = true;
        if (this.validator != null && this.validator.isEnabled()) {
            if (!this.validator.validate(this, scriptTree, errorLog)) {
                errorLog.reportAllListings();
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public String getValidParametersTable(String string) {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getValidParameterTable(string);
    }

    public Hashtable getParameterHash(String string) {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getParameterHash(string);
    }

    public ParameterAttributes getParameterAttributes(String string, String string2) {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getParameterAttributes(string, string2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.scriptNum);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.scriptNum = objectInputStream.readInt();
    }

    public class ThreadHandler
    implements Runnable {
        private final File file;

        public ThreadHandler(File file) {
            this.file = file;
        }

        public void run() {
            ScriptManager.this.loadScript(this.file);
        }
    }
}

