/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class ScriptClusterSelectionInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 1000102010301020001L;
    private JComponent header = this.createHeader();
    private JTextPane content;
    private boolean clusterGenes;

    public ScriptClusterSelectionInfoViewer(AlgorithmData algorithmData) {
        this.clusterGenes = algorithmData.getParams().getBoolean("process-gene-clusters");
        this.content = this.createContent(algorithmData);
        this.setMaxWidth(this.content, this.header);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.clusterGenes);
        objectOutputStream.writeObject(this.content.getText());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.header = this.createHeader();
        this.clusterGenes = objectInputStream.readBoolean();
        String string = (String)objectInputStream.readObject();
        this.content = new JTextPane();
        this.content.setContentType("text/html");
        this.content.setEditable(false);
        this.content.setMargin(new Insets(0, 10, 0, 0));
        this.content.setText(string);
        this.content.setCaretPosition(0);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Selection Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextPane createContent(AlgorithmData algorithmData) {
        String string;
        String string2 = algorithmData.getParams().getString("name");
        int n = algorithmData.getParams().getInt("desired-cluster-count");
        String[] stringArray = algorithmData.getStringArray("diversity-value-array");
        String[] stringArray2 = algorithmData.getStringArray("cluster-population-array");
        int n2 = algorithmData.getParams().getInt("minimum-cluster-size");
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jTextPane.setMargin(new Insets(0, 10, 0, 0));
        if (string2.equals("Diversity Ranking Cluster Selection")) {
            boolean bl = algorithmData.getParams().getBoolean("use-centroid-based-variability");
            string = "<html><body bgcolor='#FFFFFF'><font face='serif' size='5'>";
            string = string + "<br>Number of Desired Clusters: " + n + "<br>";
            string = string + "Minimum Cluster Size (population): " + n2 + "<br>";
            string = bl ? string + "Diversity Measurement: Centroid Based Diversity (mean gene-to-centroid dist.)<br>" : string + "Diversity Measurement: Intra-gene Based Diversity (mean gene-to-gene dist.)<br>";
            string = string + "<br><br>Note: Clusters are sorted by diversity.  Selected clusters are in <b>bold</b> type.<br>";
            string = string + "<table cellpadding=10><th><u>Div. Rank</u></th><th><u>Diversity</u></th><th><u>Population</u></td>";
            int n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                int n4 = Integer.parseInt(stringArray2[i]);
                if (n4 >= n2 && n3 < n) {
                    string = string + "<tr align=center><td><b>" + (i + 1) + "</b></td><td><b>" + stringArray[i] + "</b></td><td><b>" + stringArray2[i] + "</b></td></tr>";
                    ++n3;
                    continue;
                }
                string = string + "<tr align=center><td>" + (i + 1) + "</td><td>" + stringArray[i] + "</td><td>" + stringArray2[i] + "</td></tr>";
            }
            string = string + "</table></body></html>";
        } else {
            boolean bl = algorithmData.getParams().getBoolean("use-centroid-variance");
            string = "<html><body bgcolor='#FFFFFF'><font face='serif' size='5'>";
            string = string + "<br>Number of Desired Clusters: " + n + "<br>";
            string = string + "Minimum Cluster Size (population): " + n2 + "<br>";
            if (bl) {
                string = string + "Selection Criteria: Centroid Variance<br>";
                string = string + "<br><br>Note: Clusters are sorted by decreasing variance.  Selected clusters are in <b>bold</b> type.<br>";
                string = string + "<table cellpadding=10><th><u>Var. Rank</u></th><th><u>Variance</u></th><th><u>Population</u></td>";
            } else {
                string = string + "Selection Criteria: Centroid Entropy<br>";
                string = string + "<br><br>Note: Clusters are sorted by decreasing entropy.  Selected clusters are in <b>bold</b> type.<br>";
                string = string + "<table cellpadding=10><th><u>Entropy Rank</u></th><th><u>Entropy</u></th><th><u>Population</u></td>";
            }
            int n5 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                int n6 = Integer.parseInt(stringArray2[i]);
                if (n6 >= n2 && n5 < n) {
                    string = string + "<tr align=center><td><b>" + (i + 1) + "</b></td><td><b>" + stringArray[i] + "</b></td><td><b>" + stringArray2[i] + "</b></td></tr>";
                    ++n5;
                    continue;
                }
                string = string + "<tr align=center><td>" + (i + 1) + "</td><td>" + stringArray[i] + "</td><td>" + stringArray2[i] + "</td></tr>";
            }
            string = string + "</table></body></html>";
        }
        jTextPane.setText(string);
        jTextPane.setCaretPosition(0);
        return jTextPane;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }
}

