/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class ScriptParser {
    Document doc;
    String lineSeparator = "\n\n";
    String indent = "   ";

    public void printValues(String string) throws Exception {
        File file = new File(string);
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(file.toURL().toString());
        this.doc = dOMParser.getDocument();
        Element element = this.doc.getDocumentElement();
        NodeList nodeList = element.getElementsByTagNameNS("", "alg_set");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Element element2 = (Element)nodeList.item(i);
            NodeIterator nodeIterator = ((DocumentTraversal)((Object)this.doc)).createNodeIterator(element2, -1, null, true);
            while ((node = nodeIterator.nextNode()) != null) {
                if (node.getNodeType() == 1) {
                    System.out.println("Node name = " + node.getNodeName());
                } else if (node.getNodeType() == 3) {
                    System.out.println("Value = " + node.getNodeValue());
                }
                System.out.println("=========================");
            }
        }
    }

    public void writeDocument(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        this.serialize(this.doc, fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    private void serialize(Document document, Writer writer) throws IOException {
        this.serializeNode(document, writer, "");
    }

    private void serializeNode(Node node, Writer writer, String string) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>");
                writer.write(this.lineSeparator);
                Document document = (Document)node;
                this.serializeNode(document.getDocumentElement(), writer, " ");
                break;
            }
            case 1: {
                String string2 = node.getNodeName();
                writer.write(string + "<" + string2);
                writer.write(">");
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    if (nodeList.item(0) != null && nodeList.item(0).getNodeType() == 1) {
                        writer.write(this.lineSeparator);
                    }
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.serializeNode(nodeList.item(i), writer, string + this.indent);
                    }
                    if (nodeList.item(0) != null && nodeList.item(nodeList.getLength() - 1).getNodeType() == 1) {
                        writer.write(string);
                    }
                }
                writer.write("</" + string2 + ">");
                writer.write(this.lineSeparator);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
        }
    }

    public static void main(String[] stringArray) {
        ScriptParser scriptParser = new ScriptParser();
        try {
            scriptParser.printValues("c:/Temp/script.xml");
            scriptParser.writeDocument("c:/Temp/result_script.xml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

