/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.tigr.remote.RemoteException;
import org.tigr.remote.protocol.communication.RequestMessage;
import org.tigr.remote.protocol.communication.ResponseMessage;
import org.tigr.remote.protocol.communication.Transport;
import org.tigr.remote.protocol.communication.http.HttpCommunicator2;
import org.tigr.util.ConfMap;

class HttpTransport
implements Transport {
    protected ConfMap m_config;
    protected HttpCommunicator2 m_communicator;

    public HttpTransport(ConfMap confMap) throws RemoteException {
        this.m_config = confMap;
        try {
            this.m_communicator = new HttpCommunicator2(confMap);
        }
        catch (Exception exception) {
            throw new RemoteException("HttpTransport: bad server URL ", exception);
        }
    }

    public RequestMessage sendRequest(RequestMessage requestMessage) throws RemoteException {
        try {
            OutputStream outputStream = this.m_communicator.send((Properties)requestMessage.getProperties());
            requestMessage.setStream(outputStream);
            return requestMessage;
        }
        catch (IOException iOException) {
            throw new RemoteException("HttpTransport: cannot send request: " + iOException.toString(), iOException);
        }
    }

    public ResponseMessage getResponse() throws RemoteException {
        try {
            InputStream inputStream = this.m_communicator.receive();
            ResponseMessage responseMessage = new ResponseMessage("Server", "TIGR-MEV", inputStream);
            return responseMessage;
        }
        catch (IOException iOException) {
            throw new RemoteException("HttpTransport: cannot receive response. " + iOException.toString(), iOException);
        }
    }

    public void finalizeSend() throws RemoteException {
        try {
            this.m_communicator.cleanupAfterSend();
        }
        catch (IOException iOException) {
            throw new RemoteException("HttpTransport: Server error. Cannot start job: " + iOException.toString(), iOException);
        }
    }

    public void finalizeReceive() throws RemoteException {
        try {
            this.m_communicator.cleanupAfterReceive();
        }
        catch (IOException iOException) {
            throw new RemoteException("HttpTransport: cannot finalize receiving: " + iOException.toString(), iOException);
        }
    }
}

