/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.serializer;

import java.io.OutputStream;
import java.io.PrintStream;
import org.tigr.remote.protocol.Request;
import org.tigr.remote.protocol.StartJob;
import org.tigr.remote.protocol.StartingJob;
import org.tigr.remote.protocol.StartingJobVisitor;
import org.tigr.remote.protocol.StopJob;
import org.tigr.remote.protocol.serializer.BreakFilterStream;
import org.tigr.remote.protocol.serializer.MAGESerializer;
import org.tigr.remote.protocol.serializer.RequestSerializer;
import org.tigr.remote.protocol.serializer.SerializerException;
import org.tigr.remote.protocol.serializer.Util;
import org.tigr.remote.protocol.serializer.XMLIndent;

class RequestSerializerImpl
extends RequestSerializer {
    public void serializeRequest(Request request, OutputStream outputStream) throws SerializerException {
        PrintStream printStream = new PrintStream(outputStream);
        XMLIndent xMLIndent = new XMLIndent();
        printStream.println("<?xml version=\"1.0\"?>");
        printStream.println("<request>");
        xMLIndent.inc();
        StartingJobSerializer startingJobSerializer = new StartingJobSerializer(printStream, xMLIndent);
        StartingJob startingJob = request.getJob();
        if (startingJob != null) {
            startingJob.accept(startingJobSerializer);
        }
        xMLIndent.dec();
        printStream.println("</request>");
    }

    class StartingJobSerializer
    implements StartingJobVisitor {
        private PrintStream m_out;
        private XMLIndent m_ind;

        public StartingJobSerializer(PrintStream printStream, XMLIndent xMLIndent) {
            this.m_out = printStream;
            this.m_ind = xMLIndent;
        }

        public void visitStartJob(StartJob startJob) {
            this.m_ind.print(this.m_out);
            this.m_out.println("<start-job id=\"" + Util.escape(startJob.getId()) + "\"  type=\"" + Util.escape(startJob.getType()) + "\"   >");
            this.m_ind.inc();
            this.m_ind.print(this.m_out);
            this.m_out.println("<job-data>");
            BreakFilterStream breakFilterStream = new BreakFilterStream(this.m_out);
            PrintStream printStream = new PrintStream(breakFilterStream);
            MAGESerializer mAGESerializer = new MAGESerializer(printStream);
            mAGESerializer.serialize(startJob.getData().getData());
            printStream.flush();
            printStream = null;
            this.m_out.println();
            this.m_out.println("</job-data>");
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</start-job>");
        }

        public void visitStopJob(StopJob stopJob) {
            this.m_ind.print(this.m_out);
            this.m_out.println("<stop-job id=\"" + Util.escape(stopJob.getId()) + "\"/>");
        }
    }
}

