/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.biolegato.gdesupport.canvas.GDECanvasObject;
import org.biolegato.gdesupport.canvas.GDECanvasProperties;
import org.biolegato.gdesupport.canvas.GDEList;
import org.biolegato.gdesupport.canvas.GDETextArea;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.files.DataFormat;
import org.biolegato.main.BLMain;
import org.biolegato.main.DataCanvas;

public final class GDECanvas
implements DataCanvas,
ListSelectionListener {
    public final AbstractAction openAction = new AbstractAction("Open..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent evt) {
            JFileChooser openDialog = new JFileChooser();
            openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
            openDialog.setAcceptAllFileFilterUsed(true);
            openDialog.setMultiSelectionEnabled(true);
            for (DataFormat currentFormat : DataFormat.FORMAT_LIST) {
                openDialog.addChoosableFileFilter(currentFormat);
            }
            if (openDialog.showOpenDialog(BLMain.getJFrame()) == 0) {
                if (openDialog.getSelectedFiles() != null) {
                    File[] openFiles = openDialog.getSelectedFiles();
                    for (File ofile : openFiles) {
                        if (!ofile.exists() || !ofile.isFile()) continue;
                        try {
                            if (openDialog.getFileFilter() != null && !openDialog.getFileFilter().equals(openDialog.getAcceptAllFileFilter())) {
                                DataFormat.readFile(GDECanvas.this.datamodel, (DataFormat)openDialog.getFileFilter(), ofile);
                                continue;
                            }
                            DataFormat.readFile(GDECanvas.this.datamodel, ofile);
                        }
                        catch (Throwable e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
                if (openDialog.getCurrentDirectory() != null) {
                    BLMain.setCurrentPWD((File)openDialog.getCurrentDirectory());
                }
            }
        }
    };
    public final AbstractAction saveAsAction = new AbstractAction("Save As..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            JFileChooser saveDialog = new JFileChooser();
            saveDialog.setCurrentDirectory(BLMain.getCurrentPWD());
            saveDialog.setAcceptAllFileFilterUsed(false);
            for (DataFormat currentFormat : DataFormat.FORMAT_LIST) {
                saveDialog.addChoosableFileFilter(currentFormat);
            }
            if (!(saveDialog.showSaveDialog(BLMain.getJFrame()) != 0 || saveDialog.getSelectedFile() == null || saveDialog.getSelectedFile().exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Overwrite", 2, 3) == 2)) {
                try {
                    DataFormat.writeAll(GDECanvas.this.datamodel, (DataFormat)saveDialog.getFileFilter(), saveDialog.getSelectedFile());
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                }
                if (saveDialog.getCurrentDirectory() != null) {
                    BLMain.setCurrentPWD((File)saveDialog.getCurrentDirectory());
                }
            }
        }
    };
    public final AbstractAction propertiesAction = new AbstractAction("Properties..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            new GDECanvasProperties(BLMain.getJFrame(), GDECanvas.this.canvasSelf);
        }
    };
    private final AbstractAction splitAction = new AbstractAction("Split"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            GDECanvas.this.altDataCollector = new GDETextArea(GDECanvas.this.canvasSelf, GDECanvas.this.datamodel);
            GDECanvas.this.canvasPane.remove(GDECanvas.this.dataPane);
            GDECanvas.this.altDataPane = new JScrollPane(GDECanvas.this.altDataCollector, 22, 32);
            GDECanvas.this.splitPane = new JSplitPane(1, GDECanvas.this.dataPane, GDECanvas.this.altDataPane);
            GDECanvas.this.splitPane.setAlignmentX(0.5f);
            GDECanvas.this.splitPane.setAlignmentY(0.5f);
            GDECanvas.this.canvasPane.add(GDECanvas.this.splitPane);
            ((GDECanvas)GDECanvas.this).dataCollector.popup.remove(GDECanvas.this.splitMenuItem);
            ((GDECanvas)GDECanvas.this).dataCollector.popup.add(GDECanvas.this.joinMenuItem);
            ((GDECanvas)GDECanvas.this).altDataCollector.popup.add(new JMenuItem(GDECanvas.this.joinAction));
        }
    };
    public final AbstractAction joinAction = new AbstractAction("Join"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            if (GDECanvas.this.currentPane == GDECanvas.this.altDataCollector) {
                GDECanvas.this.currentPane = GDECanvas.this.dataCollector;
            }
            if (GDECanvas.this.splitPane != null) {
                GDECanvas.this.canvasPane.remove(GDECanvas.this.splitPane);
                GDECanvas.this.splitPane = null;
                GDECanvas.this.altDataPane = null;
                GDECanvas.this.canvasPane.add(GDECanvas.this.dataPane);
            }
            ((GDECanvas)GDECanvas.this).dataCollector.popup.remove(GDECanvas.this.joinMenuItem);
            ((GDECanvas)GDECanvas.this).dataCollector.popup.add(GDECanvas.this.splitMenuItem);
        }
    };
    public final AbstractAction cutAction = new AbstractAction("Cut"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.currentPane.copyClipboard();
            GDECanvas.this.currentPane.deleteSelection();
        }
    };
    public final AbstractAction copyAction = new AbstractAction("Copy"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(89));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.currentPane.copyClipboard();
        }
    };
    public final AbstractAction pasteAction = new AbstractAction("Paste"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.currentPane.paste();
        }
    };
    public final AbstractAction changeCaseAction = new AbstractAction("Change case"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.currentPane.changeCase();
        }
    };
    Font currentFont = DEFAULT_FONT;
    public Box mainDisplay = new Box(3);
    private final Dataset datamodel = new Dataset();
    private GDEList nameList = new GDEList(this, this.datamodel);
    private GDETextArea dataCollector = null;
    private GDETextArea altDataCollector = null;
    private GDECanvasObject currentPane = this.nameList;
    private JScrollPane dataPane = null;
    private JScrollPane altDataPane = null;
    private Box canvasPane = new Box(2);
    private JSplitPane splitPane = null;
    private final GDECanvas canvasSelf = this;
    private final JLabel status = new JLabel("Row: 1 Col: 1");
    private final JLabel insertStatus = new JLabel("     ");
    private final JMenuItem selectByNameMenuItem;
    private final JMenuItem splitMenuItem;
    private final JMenuItem joinMenuItem;
    private final JMenuItem groupMenuItem;
    private final JMenuItem ungroupMenuItem;
    private final JMenuItem getInfoMenuItem;
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private static final long serialVersionUID = 7526472295622776154L;

    public GDECanvas() {
        this.selectByNameMenuItem = new JMenuItem(this.nameList.selectByNameAction);
        this.splitMenuItem = new JMenuItem(this.splitAction);
        this.joinMenuItem = new JMenuItem(this.joinAction);
        this.groupMenuItem = new JMenuItem(this.nameList.groupAction);
        this.ungroupMenuItem = new JMenuItem(this.nameList.ungroupAction);
        this.getInfoMenuItem = new JMenuItem(this.nameList.getInfoAction);
        int menuInsertCount = 0;
        BLMain.addMenuItem((int)0, (String)"File", (JMenuItem)new JMenuItem(this.openAction));
        BLMain.addMenuItem((int)1, (String)"File", (JMenuItem)new JMenuItem(this.saveAsAction));
        BLMain.addMenuItem((int)2, (String)"File", (JMenuItem)new JMenuItem(this.propertiesAction));
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(new JMenuItem(this.cutAction), menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(new JMenuItem(this.copyAction), menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(new JMenuItem(this.pasteAction), menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.groupMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.ungroupMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.getInfoMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(new JMenuItem(this.nameList.selectGroupAction), menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(new JMenuItem(this.nameList.selectAllAction), menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(new JMenuItem(this.changeCaseAction), menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.selectByNameMenuItem, menuInsertCount++);
        this.dataCollector = new GDETextArea(this.canvasSelf, this.datamodel);
        this.nameList.addListSelectionListener(this.canvasSelf);
        this.dataCollector.popup.add(this.splitMenuItem);
        this.dataPane = new JScrollPane(this.dataCollector, 22, 32);
        JScrollPane listPane = new JScrollPane(this.nameList, 21, 32);
        this.dataPane.setPreferredSize(new Dimension(200, 150));
        listPane.setPreferredSize(new Dimension(100, 150));
        this.dataPane.setVerticalScrollBar(listPane.getVerticalScrollBar());
        this.canvasPane.add(this.dataPane);
        JSplitPane mainPane = new JSplitPane(1, listPane, this.canvasPane);
        mainPane.setAlignmentX(0.5f);
        mainPane.setAlignmentY(0.5f);
        Box statusBar = new Box(2);
        statusBar.setAlignmentX(0.0f);
        statusBar.add(this.status);
        statusBar.add(this.insertStatus);
        this.mainDisplay.add((Component)mainPane, "First");
        this.mainDisplay.add(new JSeparator(0));
        this.mainDisplay.add((Component)statusBar, "Last");
        this.updateFont(12, false);
    }

    public String getName() {
        return "GDE";
    }

    public void cursorChange(int column, int row) {
        this.status.setText("Row: " + (row + 1) + " Col: " + (column + 1));
    }

    public void insertionMode(boolean mode) {
        if (mode) {
            this.insertStatus.setText("[INS]");
        } else {
            this.insertStatus.setText("     ");
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.currentPane != this.nameList) {
            this.currentPane = this.nameList;
            this.dataCollector.clearSelection();
            if (this.altDataCollector != null) {
                this.altDataCollector.clearSelection();
            }
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.groupMenuItem, 3);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.ungroupMenuItem, 4);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.getInfoMenuItem, 5);
        }
    }

    public void selectionMade(GDETextArea source) {
        if (source != null && this.currentPane != source) {
            this.currentPane = source;
            this.nameList.clearSelection();
            if (this.altDataCollector != null && source != this.altDataCollector) {
                this.altDataCollector.clearSelection();
            }
            if (source != this.dataCollector) {
                this.dataCollector.clearSelection();
            }
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.groupMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.ungroupMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.getInfoMenuItem);
        }
    }

    public final void updateFont(int size, boolean bold) {
        this.currentFont = this.currentFont.deriveFont(bold ? 1 : 0, size);
        this.dataCollector.setFont(this.currentFont);
        this.nameList.setFont(this.currentFont);
        if (this.altDataCollector != null) {
            this.altDataCollector.setFont(this.currentFont);
        }
    }

    public void writeFile(String formatString, File file) {
        DataFormat format = DataFormat.getFormat(formatString);
        FileWriter writer = null;
        try {
            if (format != null && this.currentPane != null) {
                writer = new FileWriter(file);
                this.currentPane.writeOut(format, writer);
                writer.flush();
                writer.close();
            } else {
                BLMain.error((String)"Unsupported file format", (String)"GDECanvas");
            }
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
    }

    public void readFile(String formatString, File file) {
        DataFormat.readFile(this.datamodel, DataFormat.getFormat(formatString), file);
    }

    public Component display() {
        return this.mainDisplay;
    }
}

