/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.data;

import java.awt.Color;
import java.awt.Graphics;

public final class ColourMask {
    public static final Color FOREG = Color.BLACK;
    public static final int HASH_SIZE = 36;
    MaskType type;
    Color[] colours;
    String name;

    public ColourMask(MaskType type, String name, Color[] colours) {
        this.type = type;
        this.colours = colours;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void drawString(Graphics gfx, char[] array, int xstart, int y, int start, int end) {
        boolean hashpos = false;
        int width = gfx.getFontMetrics().charWidth('G');
        end = Math.min(array.length - 1, end);
        int index = start;
        int x = xstart;
        while (index < end) {
            if (this.type == MaskType.CHARACTER) {
                gfx.setColor(this.get_hash(array[index]));
            } else if (index < this.colours.length) {
                gfx.setColor(this.colours[index]);
            } else {
                gfx.setColor(FOREG);
            }
            gfx.drawChars(array, index, 1, x, y);
            ++index;
            x += width;
        }
    }

    private Color get_hash(char test) {
        if (test >= 'a' && test <= 'z') {
            return this.colours[test - 97];
        }
        if (test >= 'A' && test <= 'Z') {
            return this.colours[test - 65];
        }
        if (test >= '0' && test <= '9') {
            return this.colours[test - 48 + 26];
        }
        return FOREG;
    }

    public static int hash(char test) {
        if (test >= 'a' && test <= 'z') {
            return test - 97;
        }
        if (test >= 'A' && test <= 'Z') {
            return test - 65;
        }
        if (test >= '0' && test <= '9') {
            return test - 48 + 26;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MaskType {
        POSITION,
        CHARACTER;

    }
}

