/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.DataFormat;

public class GDEFlatfile
extends DataFormat {
    public void translateTo(Appendable result, Seq seq, int offset, int length) throws IOException {
        int type = 35;
        if (seq != null) {
            type = GDEFlatfile.typeToFlatFile(seq.getType());
            if (type != 37 && type != 64 && type != 34) {
                type = 35;
            }
            result.append((char)type).append(seq.getName()).append("\n").append(seq.getSequence(), offset, length).append("\n");
        }
    }

    public void translateFrom(Dataset datamodel, BufferedReader data) throws IOException {
        int y = datamodel.getSize();
        String line = "";
        Seq.Type type = Seq.Type.DNA;
        String name = "";
        StringBuffer sequence = null;
        while ((line = data.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("%") || line.startsWith("@") || line.startsWith("\"")) {
                if (line.indexOf(32) > 0) {
                    line = line.substring(0, line.indexOf(32));
                }
                if (line.indexOf(9) > 0) {
                    line = line.substring(0, line.indexOf(9));
                }
                if (line.indexOf(10) > 0) {
                    line = line.substring(0, line.indexOf(10));
                }
                if (line.indexOf(13) > 0) {
                    line = line.substring(0, line.indexOf(13));
                }
                if (sequence != null) {
                    datamodel.addSequence(y, new Seq(type, name, sequence));
                    ++y;
                }
                type = GDEFlatfile.flatFileToType(line.trim().charAt(0));
                name = line.trim().substring(1);
                sequence = new StringBuffer();
                continue;
            }
            if (sequence == null) continue;
            sequence.append(line.trim());
        }
        if (sequence != null) {
            datamodel.addSequence(y, new Seq(type, name, sequence));
            ++y;
        }
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".flat");
    }

    public String getDescription() {
        return "GDE Flatfile (*.flat)";
    }

    private static Seq.Type flatFileToType(char test) {
        Seq.Type result = Seq.Type.DNA;
        switch (test) {
            case '%': {
                result = Seq.Type.PROTEIN;
                break;
            }
            case '@': {
                result = Seq.Type.MASK;
                break;
            }
            case '\"': {
                result = Seq.Type.TEXT;
            }
        }
        return result;
    }

    private static char typeToFlatFile(Seq.Type t) {
        char result = '#';
        switch (t) {
            case PROTEIN: {
                result = '%';
                break;
            }
            case MASK: {
                result = '@';
                break;
            }
            case TEXT: {
                result = '\"';
            }
        }
        return result;
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check != -1 && test.ready() && (check == 32 || check == 9 || check == 10 || check == 13)) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return check == 35 || check == 37 || check == 64 || check == 34;
    }
}

