/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.biolegato.gdesupport.canvas.data.CellListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends HashMap<String, Object>
implements Cloneable,
Serializable {
    private final List<CellListener> listeners = new LinkedList<CellListener>();
    private static final HashMap<String, Object> defaults = new HashMap<String, Object>(){
        private static final long serialVersionUID = 7526472295622777006L;
        {
            super.put("name", "New Sequence");
            super.put("direction", Direction.FROM5TO3);
            super.put("strandedness", Strandedness.SINGLE);
            super.put("topology", Topology.LINEAR);
            super.put("type", Type.DNA);
            super.put("protect_align", Boolean.FALSE);
            super.put("protect_ambig", Boolean.TRUE);
            super.put("protect_unambig", Boolean.TRUE);
        }
    };
    private static final long serialVersionUID = 7526472295622777024L;

    public Cell() {
        this("");
    }

    public Cell(String string) {
        if (string != null) {
            if ("".equals(string)) {
                this.put("protect_align", (Object)Boolean.FALSE);
                this.put("protect_ambig", (Object)Boolean.FALSE);
                this.put("protect_unambig", (Object)Boolean.FALSE);
            }
            this.put("sequence", (Object)string);
        }
        this.detectType();
        super.put("modified", Boolean.FALSE);
    }

    public Cell(Map<String, Object> data) {
        this(data.containsKey("sequence") ? data.get("sequence").toString() : "");
        for (String key : data.keySet()) {
            this.put(key, data.get(key));
        }
        super.put("modified", Boolean.FALSE);
    }

    public void addListener(CellListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CellListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Object get(Object key) {
        String skey = key.toString().toLowerCase();
        return this.containsKey(skey) ? super.get(skey) : Cell.getDefault(skey);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Cannot call Sequence.setField(" + key + "," + value + ")");
        }
        if (value == null) {
            value = Cell.getDefault(key);
        }
        key = key.toLowerCase();
        super.put("modified", Boolean.TRUE);
        super.put(key, value);
        for (CellListener listener : this.listeners) {
            listener.sequenceChanged(this, key);
        }
        return value;
    }

    public boolean insertField(String field, int column, String string) {
        String current = this.get(field).toString();
        if (column > 0 && column < current.length()) {
            this.put(field, (Object)(current.substring(0, column) + string + current.substring(column)));
        } else if (column >= current.length()) {
            this.put(field, (Object)(current + string));
        } else {
            this.put(field, (Object)(string + current));
        }
        return true;
    }

    public static Object getDefault(String key) {
        return defaults.containsKey(key = key.toLowerCase()) ? defaults.get(key) : "";
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("--- SEQUENCE DATA ---");
        for (String key : this.keySet()) {
            result.append("\t" + key + "=" + this.get(key) + "\n");
        }
        return result.toString();
    }

    @Override
    public Object clone() {
        return new Cell(this);
    }

    private void detectType() {
        Type result = Type.DNA;
        if (this.containsKey("sequence")) {
            String data = this.get("sequence").toString().toUpperCase().trim();
            if (data.indexOf(85) >= 0) {
                result = Type.RNA;
            } else if (data.indexOf(70) >= 0 || data.indexOf(69) >= 0 || data.indexOf(74) >= 0 || data.indexOf(76) >= 0 || data.indexOf(79) >= 0 || data.indexOf(81) >= 0 || data.indexOf(88) >= 0 || data.indexOf(90) >= 0) {
                result = Type.PROTEIN;
            }
            this.put("type", (Object)result);
        }
    }

    public CharacterClass charType(char test) {
        CharacterClass type = CharacterClass.ALIGNMENT;
        if (Type.DNA.equals(this.get("type")) || Type.RNA.equals(this.get("type"))) {
            switch (test) {
                case 'B': 
                case 'D': 
                case 'H': 
                case 'I': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'R': 
                case 'S': 
                case 'V': 
                case 'W': 
                case 'Y': 
                case 'b': 
                case 'd': 
                case 'h': 
                case 'i': 
                case 'k': 
                case 'm': 
                case 'n': 
                case 'r': 
                case 's': 
                case 'v': 
                case 'w': 
                case 'y': {
                    type = CharacterClass.AMBIGUOUS;
                    break;
                }
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': 
                case 'U': 
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': 
                case 'u': {
                    type = CharacterClass.UNAMBIGUOUS;
                    break;
                }
                default: {
                    type = CharacterClass.ALIGNMENT;
                    break;
                }
            }
        } else if (Type.PROTEIN.equals(this.get("type"))) {
            switch (test) {
                case '*': 
                case 'B': 
                case 'X': 
                case 'Z': 
                case 'b': 
                case 'x': 
                case 'z': {
                    type = CharacterClass.AMBIGUOUS;
                    break;
                }
                case 'A': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'W': 
                case 'Y': 
                case 'a': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'v': 
                case 'w': 
                case 'y': {
                    type = CharacterClass.UNAMBIGUOUS;
                    break;
                }
                default: {
                    type = CharacterClass.ALIGNMENT;
                }
            }
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterClass {
        ALIGNMENT,
        AMBIGUOUS,
        UNAMBIGUOUS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strandedness {
        SINGLE{

            public String toString() {
                return "Single stranded";
            }
        }
        ,
        DOUBLE{

            public String toString() {
                return "Double stranded";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "Mixed strandedness";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Topology {
        LINEAR{

            public String toString() {
                return "Linear";
            }
        }
        ,
        CIRCULAR{

            public String toString() {
                return "Circular";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FROM3TO5{

            public String toString() {
                return "From 3' to 5'";
            }
        }
        ,
        FROM5TO3{

            public String toString() {
                return "From 5' to 3'";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DNA{

            public String toString() {
                return "DNA";
            }
        }
        ,
        RNA{

            public String toString() {
                return "RNA";
            }
        }
        ,
        PROTEIN{

            public String toString() {
                return "Protein";
            }
        }
        ,
        MASK{

            public String toString() {
                return "Colour mask";
            }
        }
        ,
        TEXT{

            public String toString() {
                return "Text";
            }
        };

    }
}

