/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.data;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.CellListener;
import org.biolegato.gdesupport.canvas.data.DatasetListener;

public class Dataset
implements CellListener,
Transferable {
    private List<List<Cell>> data = new ArrayList<List<Cell>>();
    private final List<Cell> lines = new ArrayList<Cell>();
    private final List<DatasetListener> listeners = new LinkedList<DatasetListener>();
    public static final DataFlavor seqDocFlavour = new DataFlavor(Dataset.class, "BioLegato sequence document");

    public Dataset() {
    }

    public Dataset(Cell[] row) {
        for (Cell data : row) {
            this.addRow(this.getRowCount(), data);
        }
    }

    public boolean addRow(int y, Cell seq) {
        boolean result = false;
        if (y >= 0 && y <= this.getRowCount()) {
            if (seq != null) {
                this.lines.add(y, seq);
                seq.addListener(this);
                for (DatasetListener listener : this.listeners) {
                    listener.sequenceAdded(this, y, seq);
                }
            }
            result = true;
        }
        return result;
    }

    public void removeRows(int[] lineNumbers) {
        Arrays.sort(lineNumbers);
        if (!this.lines.isEmpty()) {
            for (int count = lineNumbers.length - 1; count >= 0; --count) {
                if (this.getRowCount() <= lineNumbers[count] || lineNumbers[count] < 0) continue;
                Cell removed = this.lines.remove(lineNumbers[count]);
                String text = (String)removed.get("sequence");
                int length = text.length();
                removed.removeListener(this);
                for (DatasetListener listener : this.listeners) {
                    listener.sequenceRemoved(this, lineNumbers[count], removed);
                }
            }
        }
    }

    public Cell get(int y) {
        return y >= 0 && y < this.getRowCount() ? this.lines.get(y) : null;
    }

    public void addListener(DatasetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DatasetListener listener) {
        this.listeners.remove(listener);
    }

    public void sequenceChanged(Cell sequence, String key) {
        for (DatasetListener listener : this.listeners) {
            listener.sequenceChanged(this, this.lines.indexOf(sequence), sequence, key);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{seqDocFlavour, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavour) {
        boolean result = false;
        DataFlavor[] test = this.getTransferDataFlavors();
        for (int count = 0; count < test.length && !result; ++count) {
            result = flavour.equals(test[count]);
        }
        return result;
    }

    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        Object result = this;
        if (!this.isDataFlavorSupported(flavour)) {
            throw new UnsupportedFlavorException(flavour);
        }
        if (DataFlavor.stringFlavor.equals(flavour)) {
            result = this.toString();
        }
        return result;
    }

    public String toString() {
        String result = "";
        for (Cell seq : this.lines) {
            if (!result.equals("")) {
                result = result + "\n";
            }
            result = result + seq.get("sequence");
        }
        return result;
    }

    public Cell[] toArray() {
        return this.lines.toArray(new Cell[0]);
    }

    protected void finalize() {
        for (Cell seq : this.lines) {
            seq.removeListener(this);
        }
        this.lines.clear();
    }

    public int getRowCount() {
        return this.lines.size();
    }
}

