/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.data;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.CellListener;
import org.biolegato.gdesupport.canvas.data.GDEModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDEModel
implements CellListener,
Transferable {
    private final List<Cell> lines = new ArrayList<Cell>();
    public static final DataFlavor seqDocFlavour = new DataFlavor(GDEModel.class, "BioLegato sequence document");
    private int maxGroup = 1;
    private final Hashtable<Integer, List<Integer>> group2seq = new Hashtable();
    private final List<GDEModelListener> listeners = new LinkedList<GDEModelListener>();

    public boolean addSequence(int y, Cell seq) {
        boolean result = false;
        if (y >= 0 && y <= this.getLineCount()) {
            if (seq != null) {
                this.lines.add(y, seq);
                seq.addListener(this);
                for (GDEModelListener listener : this.listeners) {
                    listener.sequenceAdded(this, y, seq);
                }
            }
            result = true;
        }
        return result;
    }

    public void removeSequences(int[] lineNumbers) {
        Arrays.sort(lineNumbers);
        if (!this.lines.isEmpty() && lineNumbers != null) {
            for (int count = lineNumbers.length - 1; count >= 0; --count) {
                if (this.getLineCount() <= lineNumbers[count] || lineNumbers[count] < 0) continue;
                Cell removed = this.lines.remove(lineNumbers[count]);
                String text = (String)removed.get("sequence");
                int length = text.length();
                removed.removeListener(this);
                for (GDEModelListener listener : this.listeners) {
                    listener.sequenceRemoved(this, lineNumbers[count], removed);
                }
            }
        }
    }

    public boolean insert(int col, int line, String string) {
        boolean result;
        boolean bl = result = string == null || "".equals(string);
        if (!result && line >= 0 && line < this.getLineCount() && col >= 0 && col <= this.getLineLength(line)) {
            result = this.get(line).insertField("sequence", col, string);
        }
        return result;
    }

    public boolean delete(int col, int line, int cols) {
        boolean result;
        boolean bl = result = this.getLineCount() == 0 && line == 0 && col == 0 && cols == 0;
        if (line >= 0 && line < this.getLineCount()) {
            String data = this.getText(line);
            if (col >= 0 && cols >= 0 && col + cols <= data.length()) {
                data = col + cols >= data.length() ? data.substring(0, col) : data.substring(0, col) + data.substring(col + cols);
                this.get(line).put("sequence", (Object)data);
                result = true;
            } else if (col == 0 && cols == 0 && data.length() == 0) {
                result = true;
            }
        }
        return result;
    }

    public boolean delete(int col, int line, int cols, int lines) {
        String data = "";
        boolean result = false;
        if (this.getLineCount() > 0 && line >= 0 && line + lines < this.getLineCount() && col >= 0) {
            for (int count = 0; count <= lines; ++count) {
                result |= this.delete(col, line + count, cols);
            }
        }
        return result;
    }

    public Cell get(int number) {
        return number >= 0 && number < this.getLineCount() ? this.lines.get(number) : null;
    }

    private String getText(int number) {
        Cell seq = this.get(number);
        return seq != null ? (String)seq.get("sequence") : "";
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public int getLineLength(int line) {
        return this.getText(line).length();
    }

    public int getLongestLine() {
        int lineLength = 0;
        for (int count = 0; count < this.getLineCount(); ++count) {
            lineLength = Math.max(lineLength, this.getLineLength(count));
        }
        return lineLength;
    }

    public void addListener(GDEModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GDEModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sequenceChanged(Cell sequence, String key) {
        for (GDEModelListener listener : this.listeners) {
            listener.sequenceChanged(this, this.lines.indexOf(sequence), sequence, key);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{seqDocFlavour, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavour) {
        boolean result = false;
        DataFlavor[] test = this.getTransferDataFlavors();
        for (int count = 0; count < test.length && !result; ++count) {
            result = flavour.equals(test[count]);
        }
        return result;
    }

    @Override
    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        Object result = this;
        if (!this.isDataFlavorSupported(flavour)) {
            throw new UnsupportedFlavorException(flavour);
        }
        if (DataFlavor.stringFlavor.equals(flavour)) {
            result = this.toString();
        }
        return result;
    }

    protected void finalize() {
        for (Cell seq : this.lines) {
            seq.removeListener(this);
        }
        this.lines.clear();
    }

    private void setgroup(Integer groupNumber, Cell sequence) {
    }

    public void group(int[] sequences) {
        Cell seq = null;
        Object group = null;
        Integer groupNumber = this.maxGroup;
        this.ungroup(sequences);
        for (int number : sequences) {
            seq = this.get(number);
            if (seq == null) continue;
            seq.put("group", (Object)groupNumber);
            if (!this.group2seq.containsKey(groupNumber)) {
                this.group2seq.put(groupNumber, new ArrayList());
            }
            this.group2seq.get(groupNumber).add(number);
            seq.put("group", (Object)groupNumber);
        }
        ++this.maxGroup;
    }

    public void ungroup(int[] sequences) {
        Cell seq = null;
        List<Integer> group = null;
        Integer groupNumber = null;
        for (int number : sequences) {
            seq = this.get(number);
            if (seq == null || !seq.containsKey("group") || !(seq.get("group") instanceof Integer)) continue;
            groupNumber = (Integer)seq.get("group");
            group = this.getgroup(groupNumber);
            group.remove(number);
            if (group.isEmpty()) {
                while (this.maxGroup > 1 && this.maxGroup < this.group2seq.size() && this.group2seq.get(this.maxGroup - 1).isEmpty()) {
                    --this.maxGroup;
                }
                this.group2seq.remove(groupNumber);
            }
            seq.remove("group");
        }
    }

    public List<Integer> getgroup(Integer groupNumber) {
        List<Integer> group = null;
        group = groupNumber != null && this.group2seq.containsKey(groupNumber) ? this.group2seq.get(groupNumber) : new LinkedList<Integer>();
        return group;
    }

    public void addSequences(Cell[] list) {
        int position = this.getLineCount();
        if (list != null) {
            for (Cell entry : list) {
                this.addSequence(position, entry);
                ++position;
            }
        }
    }

    public Cell[] toArray() {
        return this.lines.toArray(new Cell[0]);
    }
}

