/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.list;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.GDEModel;
import org.biolegato.gdesupport.canvas.data.GDEModelListener;

public class SequenceListModel
implements ListModel,
GDEModelListener {
    private GDEModel data;
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();

    public SequenceListModel(GDEModel data) {
        this.data = data;
        data.addListener(this);
    }

    public int getSize() {
        return this.data.getLineCount();
    }

    public Object getElementAt(int index) {
        String name = "";
        Cell seq = this.data.get(index);
        if (seq != null) {
            name = seq.get("group") != null && seq.get("group") instanceof Integer ? name + seq.get("group").toString() + " " : name + "_ ";
            name = name + seq.get("name").toString();
        }
        return name;
    }

    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void sequenceChanged(GDEModel source, int index, Cell sequence, String key) {
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, index, index));
        }
    }

    public void sequenceAdded(GDEModel source, int index, Cell sequence) {
        for (ListDataListener l : this.listeners) {
            l.intervalAdded(new ListDataEvent(this, 0, index, index));
        }
    }

    public void sequenceRemoved(GDEModel source, int index, Cell sequence) {
        for (ListDataListener l : this.listeners) {
            l.intervalRemoved(new ListDataEvent(this, 0, index, index));
        }
    }
}

