/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.textarea;

import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.undo.UndoChangePosition;
import org.biolegato.gdesupport.canvas.undo.UndoDelete;
import org.biolegato.gdesupport.canvas.undo.UndoInsert;
import org.biolegato.gdesupport.canvas.undo.UndoMulti;
import org.biolegato.gdesupport.canvas.undo.Undoable;

public class UndoableGDETextArea
extends GDETextArea {
    private GDECanvas canvas = null;
    public final UndoableGDETextArea ugdeTextAreaSelf = this;
    private static final long serialVersionUID = 7526472295622777017L;

    public UndoableGDETextArea(GDECanvas canvas) {
        super(canvas);
        this.canvas = canvas;
        this.addPopupMenuItem(new JMenuItem(canvas.undoAction));
        this.addPopupMenuItem(new JMenuItem(canvas.redoAction));
    }

    public void changeCase() {
        String data = null;
        Cell[] seqList = null;
        UndoMulti result = new UndoMulti();
        if (!this.isSelectionEmpty()) {
            for (Cell seq : seqList = this.getData()) {
                data = (String)seq.get("sequence");
                if (data.length() < 0) continue;
                if (Character.isUpperCase(data.charAt(0))) {
                    seq.put("sequence", (Object)data.toLowerCase());
                    continue;
                }
                seq.put("sequence", (Object)data.toUpperCase());
            }
            result.addUndo(this.udeleteSelection());
            result.addUndo(this.uinsert(this.column, this.row, seqList));
            this.canvas.addUndo(result);
        }
    }

    public void cut() {
        if (!this.isSelectionEmpty()) {
            this.copy();
            this.canvas.addUndo(this.updeleteSelection());
        }
    }

    public void paste() {
        UndoMulti paste = new UndoMulti();
        paste.addUndo(this.updeleteSelection());
        paste.addUndo(this.uinsert(this.column, this.row, GDECanvas.getClipboard()));
        this.canvas.addUndo(paste);
    }

    public void keyTyped(KeyEvent event) {
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            boolean canInsert = true;
            Undoable returnedUndo = null;
            UndoMulti resultUndo = new UndoMulti();
            try {
                switch (event.getKeyChar()) {
                    case '\b': 
                    case '\u007f': {
                        break;
                    }
                    case '\n': {
                        if (this.row + 1 < this.getDataModel().getLineCount()) {
                            this.changePosition(false, Math.min(this.getDataModel().getLineLength(this.row + 1), this.column), this.row + 1);
                        }
                        break;
                    }
                    default: {
                        if (!this.isSelectionEmpty()) {
                            resultUndo.addUndo(this.udeleteSelection());
                        } else if (this.insertMode && this.getDataModel().getLineCount() > 0 && this.getDataModel().getLineLength(0) > 0) {
                            returnedUndo = this.udelete(this.column, this.row, 1, 0);
                        }
                        if (this.isSelectionEmpty() || !this.insertMode || returnedUndo != null) {
                            resultUndo.addUndo(returnedUndo);
                            resultUndo.addUndo(this.uinsert(this.column, this.row, "" + event.getKeyChar()));
                            resultUndo.addUndo(this.uchangePosition(this.column + 1, this.row));
                        }
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (!resultUndo.isEmpty()) {
                this.canvas.addUndo(resultUndo);
            }
        } else {
            super.keyTyped(event);
        }
    }

    public void keyPressed(KeyEvent event) {
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            int backspacecol = 0;
            boolean moved = false;
            UndoMulti result = new UndoMulti();
            Undoable tempResult = null;
            try {
                switch (event.getKeyChar()) {
                    case '\b': {
                        if (!this.isSelectionEmpty()) {
                            result.addUndo(this.udeleteSelection());
                            break;
                        }
                        if (this.row > 0 || this.column > 0) {
                            if (this.column <= 0 && this.row > 0) {
                                backspacecol = this.getDataModel().getLineLength(this.row - 1);
                            }
                            if (this.column - 1 >= 0 && (tempResult = this.udelete(this.column - 1, this.row, 1, 0)) != null) {
                                result.addUndo(tempResult);
                                if (this.column <= 0 && this.row > 0) {
                                    result.addUndo(this.uchangePosition(backspacecol, this.row - 1));
                                    break;
                                }
                                result.addUndo(this.uchangePosition(this.column - 1, this.row));
                            }
                        }
                        break;
                    }
                    case '\u007f': {
                        if (!this.isSelectionEmpty()) {
                            result.addUndo(this.udeleteSelection());
                            break;
                        }
                        if (this.getDataModel().getLineCount() > 0 && this.getDataModel().getLineLength(0) > 0) {
                            result.addUndo(this.udelete(this.column, this.row, 1, 0));
                        }
                        break;
                    }
                    default: {
                        super.keyPressed(event);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (!result.isEmpty()) {
                this.canvas.addUndo(result);
            }
        } else {
            super.keyTyped(event);
        }
    }

    public Undoable uinsert(int x, int y, String text) {
        return this.insert(x, y, text) ? new UndoInsert(this, x, y, text.length()) : null;
    }

    public Undoable uinsert(int x, int y, Cell[] sequences) {
        UndoMulti result = null;
        if (this.insert(x, y, sequences)) {
            for (int count = 0; count < sequences.length; ++count) {
                result.addUndo(new UndoInsert(this, x, y + count, ((String)sequences[count].get("sequnce")).length()));
            }
        }
        return result;
    }

    public Undoable udelete(int x, int y, int w, int h) {
        UndoMulti result = new UndoMulti();
        Cell current = null;
        for (int count = y; count <= y + h; ++count) {
            List<Integer> group;
            if (current.get("group") instanceof Integer && (group = this.datamodel.getgroup((Integer)current.get("group"))) != null) {
                result = new UndoMulti();
                for (int gln : group) {
                    if ((gln < y || gln > y + h) && gln < this.getDataModel().getLineCount()) {
                        result.addUndo(this.updelete(x, gln, w, 0));
                        continue;
                    }
                    BLMain.error((String)("Invalid row number: " + y), (String)"boolean UndoableGDETextArea.insert (char)");
                }
                continue;
            }
            result.addUndo(this.updelete(x, y, w, 0));
        }
        return result;
    }

    public Undoable updelete(int x, int y, int w, int h) {
        String current = null;
        UndoMulti result = new UndoMulti();
        for (int count = 0; count <= h; ++count) {
            current = this.getDataModel().get(count).get("sequence").toString().substring(x, x + w);
            if (!this.pdelete(x, y + count, w, 0)) continue;
            result.addUndo(new UndoDelete(this, x, y + count, current));
        }
        return result;
    }

    public Undoable updeleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        Undoable resultDelete = null;
        UndoMulti resultFunction = new UndoMulti();
        if (!this.isSelectionEmpty() && (resultDelete = this.updelete(x, y, w, h)) != null) {
            resultFunction.addUndo(resultDelete);
            resultFunction.addUndo(this.uchangePosition(x, y));
        }
        return resultFunction;
    }

    public Undoable udeleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        Undoable resultDelete = null;
        UndoMulti resultFunction = new UndoMulti();
        if (!this.isSelectionEmpty() && (resultDelete = this.udelete(x, y, w, h)) != null) {
            resultFunction.addUndo(resultDelete);
            resultFunction.addUndo(this.uchangePosition(x, y));
        }
        return resultFunction;
    }

    public Undoable uchangePosition(int newColumn, int newRow) {
        int oldRow = this.row;
        int oldColumn = this.column;
        super.changePosition(false, newColumn, newRow);
        return new UndoChangePosition(this, oldColumn, oldRow);
    }
}

