/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.api.pub;

import com.zerog.ia.api.pub.I18NAccess;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.ProgressAccess;
import com.zerog.ia.api.pub.ReplayVariableService;
import com.zerog.ia.api.pub.ResourceAccess;
import com.zerog.ia.api.pub.ServiceAccess;
import com.zerog.ia.api.pub.SimpleRegistryManager;
import com.zerog.ia.api.pub.UninstallerAccess;
import com.zerog.ia.api.pub.VariableAccess;
import com.zerog.ia.api.pub.registry.ProductRegistryService;
import com.zerog.ia.installer.util.service.ServiceManagerFacade;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;

public class UninstallerProxy
implements ResourceAccess,
I18NAccess,
VariableAccess,
UninstallerAccess,
ServiceAccess,
IAProxy,
ProgressAccess {
    private ResourceAccess ra;
    private VariableAccess va;
    private I18NAccess i18na;
    private UninstallerAccess ua;
    private ProgressAccess progressAccess = null;

    public UninstallerProxy(ResourceAccess resourceAccess, VariableAccess variableAccess, I18NAccess i18NAccess, UninstallerAccess uninstallerAccess) {
        if (resourceAccess == null || variableAccess == null || i18NAccess == null || uninstallerAccess == null) {
            System.err.println("InstallerProxy: Some proxy component implementations were null");
            throw new IllegalArgumentException("Some proxy component implementations were null");
        }
        this.ra = resourceAccess;
        this.va = variableAccess;
        this.i18na = i18NAccess;
        this.ua = uninstallerAccess;
    }

    public void setProgressAccess(ProgressAccess progressAccess) {
        this.progressAccess = progressAccess;
    }

    public URL getResource(String string) {
        return this.ra.getResource(string);
    }

    public File getTempDirectory() throws IOException {
        return this.ra.getTempDirectory();
    }

    public File saveURLContentToFile(URL uRL) throws IOException {
        return this.ra.saveURLContentToFile(uRL);
    }

    public String getValue(String string, Locale locale) {
        return this.i18na.getValue(string, locale);
    }

    public String getValue(String string) {
        return this.i18na.getValue(string);
    }

    public DataInput getLogInput() {
        return this.ua.getLogInput();
    }

    public void setProgressPercentage(float f) {
        this.progressAccess.setProgressPercentage(f);
    }

    public void setProgressStatusText(String string) {
        this.progressAccess.setProgressStatusText(string);
    }

    public void setProgressTitle(String string) {
        this.progressAccess.setProgressTitle(string);
    }

    public void setProgressDescription(String string) {
        this.progressAccess.setProgressDescription(string);
    }

    public Object getService(Class clazz) {
        Object object = null;
        if (clazz.equals(SimpleRegistryManager.class)) {
            object = ZeroGr8.a();
        } else if (clazz.equals(ReplayVariableService.class)) {
            object = ZeroGsg.a();
        } else if (clazz.equals(ProductRegistryService.class)) {
            object = ZeroGtc.a();
            ((ZeroGtc)object).a(null, true);
        } else {
            object = ServiceManagerFacade.getInstance().getService(clazz);
        }
        return object;
    }

    public String substitute(String string) {
        return this.va.substitute(string);
    }

    public Object getVariable(String string) {
        return this.va.getVariable(string);
    }

    public Enumeration getVariables() {
        return this.va.getVariables();
    }

    public Object setVariable(String string, Object object) {
        return this.va.setVariable(string, object);
    }

    public Object getEncryptedVariable(String string) {
        return this.va.getEncryptedVariable(string);
    }
}

