/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DAMResultConfigDialog
extends AlgorithmDialog {
    private int result;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;
    private JTextField textField5;
    private float pointSize;
    private float selectedPointSize;
    private float scaleAxisX;
    float scaleAxisY;
    float scaleAxisZ;

    public DAMResultConfigDialog(Frame frame, float f, float f2, float f3, float f4, float f5) {
        super(new JFrame(), "DAM Result Configuration", true);
        this.pointSize = f;
        this.selectedPointSize = f2;
        this.scaleAxisX = f3;
        this.scaleAxisY = f4;
        this.scaleAxisZ = f5;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 10, 0));
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 10));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel("Scale axis X  "));
        this.textField1 = new JTextField(Float.toString(f3), 5);
        jPanel.add((Component)this.textField1, "East");
        jPanel.add(new JLabel("Scale axis Y  "));
        this.textField2 = new JTextField(Float.toString(f4), 5);
        jPanel.add((Component)this.textField2, "East");
        jPanel.add(new JLabel("Scale axis Z  "));
        this.textField3 = new JTextField(Float.toString(f5), 5);
        jPanel.add((Component)this.textField3, "East");
        jPanel.add(new JLabel("Pointsize  "));
        this.textField4 = new JTextField(Float.toString(f), 5);
        jPanel.add((Component)this.textField4, "East");
        jPanel.add(new JLabel("Selected "));
        this.textField5 = new JTextField(Float.toString(f2), 5);
        jPanel.add((Component)this.textField5, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setForeground(Color.white);
        jPanel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel3.setBackground(Color.white);
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)new JLabel(GUIFactory.getIcon("tigr_logo.gif")), "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "South");
        jPanel4.add((Component)jPanel3, "North");
        this.addContent(jPanel4);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getScaleAxisX() {
        return Float.parseFloat(this.textField1.getText());
    }

    public float getScaleAxisY() {
        return Float.parseFloat(this.textField2.getText());
    }

    public float getScaleAxisZ() {
        return Float.parseFloat(this.textField3.getText());
    }

    public float getPointSize() {
        return Float.parseFloat(this.textField4.getText());
    }

    public float getSelectedPointSize() {
        return Float.parseFloat(this.textField5.getText());
    }

    public static void main(String[] stringArray) {
        DAMResultConfigDialog dAMResultConfigDialog = new DAMResultConfigDialog(new Frame(), 1.0f, 1.0f, 5.0f, 5.0f, 5.0f);
        dAMResultConfigDialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    Float.parseFloat(DAMResultConfigDialog.this.textField1.getText());
                    Float.parseFloat(DAMResultConfigDialog.this.textField2.getText());
                    Float.parseFloat(DAMResultConfigDialog.this.textField3.getText());
                    Float.parseFloat(DAMResultConfigDialog.this.textField4.getText());
                    Float.parseFloat(DAMResultConfigDialog.this.textField5.getText());
                    DAMResultConfigDialog.this.result = 0;
                }
                catch (Exception exception) {
                    DAMResultConfigDialog.this.result = 2;
                }
                DAMResultConfigDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                DAMResultConfigDialog.this.result = 2;
                DAMResultConfigDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                DAMResultConfigDialog.this.textField1.setText(String.valueOf(DAMResultConfigDialog.this.scaleAxisX));
                DAMResultConfigDialog.this.textField2.setText(String.valueOf(DAMResultConfigDialog.this.scaleAxisY));
                DAMResultConfigDialog.this.textField3.setText(String.valueOf(DAMResultConfigDialog.this.scaleAxisZ));
                DAMResultConfigDialog.this.textField4.setText(String.valueOf(DAMResultConfigDialog.this.pointSize));
                DAMResultConfigDialog.this.textField5.setText(String.valueOf(DAMResultConfigDialog.this.selectedPointSize));
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(DAMResultConfigDialog.this, "DAM Result Configuration");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            DAMResultConfigDialog.this.result = -1;
            DAMResultConfigDialog.this.dispose();
        }
    }
}

