/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ease;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.TableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEURLFactory;
import org.tigr.util.BrowserLauncher;

public class EASETableViewer
extends TableViewer
implements Serializable {
    public static final long serialVersionUID = 202002010001L;
    private DefaultMutableTreeNode easeRoot;
    private JPopupMenu menu;
    private Experiment experiment;
    private int[][] clusters;
    private String[] headerNames;
    private boolean clusterAnalysis;
    private boolean haveAccessionNumbers;
    private JMenuItem launchMenuItem;

    public EASETableViewer(String[] stringArray, Object[][] objectArray, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, boolean bl, boolean bl2) {
        super(stringArray, objectArray);
        this.headerNames = stringArray;
        this.clusterAnalysis = bl2;
        this.haveAccessionNumbers = bl;
        this.setNumerical(0, true);
        if (bl2) {
            if (!bl) {
                this.setNumerical(3, true);
            }
            for (int i = 4; i < stringArray.length; ++i) {
                this.setNumerical(i, true);
            }
        } else {
            if (!bl) {
                this.setNumerical(3, true);
            } else {
                this.setNumerical(5, true);
            }
            this.setNumerical(4, true);
        }
        this.easeRoot = defaultMutableTreeNode;
        this.menu = this.createPopupMenu();
        this.experiment = experiment;
        this.clusters = nArray;
        this.table.addMouseListener(new Listener());
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.headerNames);
        objectOutputStream.writeBoolean(this.clusterAnalysis);
        objectOutputStream.writeBoolean(this.haveAccessionNumbers);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.headerNames = (String[])objectInputStream.readObject();
        this.clusterAnalysis = objectInputStream.readBoolean();
        this.haveAccessionNumbers = objectInputStream.readBoolean();
        this.setNumerical(0, true);
        if (this.clusterAnalysis) {
            if (!this.haveAccessionNumbers) {
                this.setNumerical(3, true);
            }
            for (int i = 4; i < this.headerNames.length; ++i) {
                this.setNumerical(i, true);
            }
        } else {
            if (!this.haveAccessionNumbers) {
                this.setNumerical(3, true);
            } else {
                this.setNumerical(5, true);
            }
            this.setNumerical(4, true);
        }
        this.menu = this.createPopupMenu();
        this.table.addMouseListener(new Listener());
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private JPopupMenu createPopupMenu() {
        Listener listener = new Listener();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Store Selection as Cluster");
        jMenuItem.setActionCommand("store-cluster-command");
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        JMenu jMenu = new JMenu("Open Viewer");
        jMenuItem = new JMenuItem("Expression Image");
        jMenuItem.setActionCommand("launch-expression-image-command");
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Centroid Graph");
        jMenuItem.setActionCommand("launch-centroid-graph-command");
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Expression Graph");
        jMenuItem.setActionCommand("launch-expression-graph-command");
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save EASE Table");
        jMenuItem.setActionCommand("save-ease-table-command");
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        if (this.haveAccessionNumbers) {
            this.launchMenuItem = new JMenuItem("Open Web Page");
            this.launchMenuItem.setActionCommand("launch-browser-command");
            this.launchMenuItem.addActionListener(listener);
            jPopupMenu.add(this.launchMenuItem);
        }
        return jPopupMenu;
    }

    public void onSelected(IFramework iFramework) {
        super.onSelected(iFramework);
        if (this.easeRoot == null) {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)iFramework.getCurrentNode().getParent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof String && ((String)object).indexOf("EASE") != -1) {
                    this.easeRoot = defaultMutableTreeNode;
                }
            }
            catch (Exception exception) {
                System.out.println("selection exception");
                exception.printStackTrace();
            }
        }
    }

    private void onOpenViewer(String string) {
        int n = this.getSelectedRow();
        if (n == -1 || this.easeRoot == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.easeRoot.getChildAt(1);
        if (defaultMutableTreeNode.getChildCount() < n) {
            return;
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        if (string.equals("expression image")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        } else if (string.equals("centroid graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        } else if (string.equals("expression graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(2);
        }
        if (this.framework != null) {
            this.framework.setTreeNode(defaultMutableTreeNode);
        }
    }

    private void onStoreCluster() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((TableViewer.DefaultViewerTableModel)this.model).getRow(nArray[i]);
        }
        int[] nArray2 = this.getGeneIndices(nArray);
        nArray2 = this.mapExperimentIndicesToIData(nArray2);
        this.framework.storeSubCluster(nArray2, this.experiment, 0);
    }

    private void onOpenBrowser() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray == null || nArray.length < 1) {
            return;
        }
        String string = (String)this.table.getValueAt(nArray[0], 1);
        String string2 = (String)this.table.getValueAt(nArray[0], 2);
        if (string2 == null || string2.equals("") || string2.equals(" ")) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "No accession exists for this entry.", "Web access denial", 1);
            return;
        }
        String string3 = EASEURLFactory.constructURL(string, string2);
        if (string3 == null) {
            return;
        }
        try {
            BrowserLauncher.openURL((String)string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void onSaveEaseTable() {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String string = "";
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            string = file.getName();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                int n = this.table.getRowCount();
                int n2 = this.table.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        printWriter.print((String)this.table.getValueAt(i, j) + "\t");
                    }
                    printWriter.print("\n");
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + string, "Output Error", 2);
            }
        }
    }

    private int[] getGeneIndices(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += this.clusters[nArray[i]].length;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.clusters[nArray[i]].length; ++j) {
                nArray2[n2] = this.clusters[nArray[i]][j];
                ++n2;
            }
        }
        return nArray2;
    }

    private int[] mapExperimentIndicesToIData(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    private void validateMenuOptions() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.launchMenuItem.setEnabled(this.table.getValueAt(n, 1) != null && !this.table.getValueAt(n, 1).equals(" "));
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("store-cluster-command")) {
                EASETableViewer.this.onStoreCluster();
            } else if (string.equals("launch-expression-image-command")) {
                EASETableViewer.this.onOpenViewer("expression image");
            } else if (string.equals("launch-centroid-graph-command")) {
                EASETableViewer.this.onOpenViewer("centroid graph");
            } else if (string.equals("launch-expression-graph-command")) {
                EASETableViewer.this.onOpenViewer("expression graph");
            } else if (string.equals("launch-browser-command")) {
                EASETableViewer.this.onOpenBrowser();
            } else if (string.equals("save-ease-table-command")) {
                EASETableViewer.this.onSaveEaseTable();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (EASETableViewer.this.launchMenuItem != null) {
                    EASETableViewer.this.validateMenuOptions();
                }
                EASETableViewer.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (EASETableViewer.this.launchMenuItem != null) {
                    EASETableViewer.this.validateMenuOptions();
                }
                EASETableViewer.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

