/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.IData;

public class GDMExpGradientLabelPanel
extends JScrollPane {
    private final int OFFSET = 2;
    private final int RECT_HEIGHT = 10;
    private final int RECT_WIDTH = 200;
    private IData expData;
    private Insets insets;
    private int contentWidth;
    private int contentHeight;
    private int elementWidth;
    private int elementHeight;
    private int tracespace;
    private int maxExpNameLength;
    private int num_experiments;
    private int[] indices;
    private int labelIndex;
    private boolean isAntiAliasing = false;
    private boolean isTracing = true;
    private boolean isColumnHeader;
    private int annotationSize;
    private GDMLabelPanel gdmLabelPanel;
    private GDMGradientPanel gdmGradientPanel;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private int maxTextWidth = 0;
    private int maxTextHeight = 0;

    public GDMExpGradientLabelPanel(Insets insets, int n, boolean bl, int n2, int n3, Dimension dimension, int n4, int n5, int[] nArray) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.insets = new Insets(0, 0, 0, 0);
        this.insets.left = insets.left;
        this.insets.right = insets.right;
        this.insets.top = insets.top;
        this.insets.bottom = insets.bottom;
        this.tracespace = n;
        this.elementWidth = dimension.width;
        this.elementHeight = dimension.height;
        this.isColumnHeader = bl;
        this.contentWidth = n2;
        this.contentHeight = n3;
        this.indices = nArray;
        this.num_experiments = n5;
        this.maxExpNameLength = n4 * this.elementWidth;
        this.gdmLabelPanel = new GDMLabelPanel();
        this.setViewportView(this.gdmLabelPanel);
        this.setViewport(this.getViewport());
        this.gdmGradientPanel = new GDMGradientPanel();
        if (this.isColumnHeader) {
            this.setColumnHeaderView(this.gdmGradientPanel);
            this.setColumnHeader(this.getColumnHeader());
        } else {
            this.setRowHeaderView(this.gdmGradientPanel);
            this.setRowHeader(this.getRowHeader());
        }
        this.updateSize();
        if (this.isColumnHeader) {
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(20);
        } else {
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(30);
        }
        this.getViewport().setScrollMode(0);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setValues(float f, float f2) {
        this.minValue = f;
        this.maxValue = f2;
    }

    public void setData(IData iData) {
        this.expData = iData;
    }

    public void setNumExperiments(int n) {
        this.num_experiments = n;
    }

    public void setLabelIndex(int n) {
        this.labelIndex = n;
    }

    public void setIndices(int[] nArray) {
        this.indices = nArray;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int getLabelIndex() {
        return this.labelIndex;
    }

    public Graphics getLabelPanelGraphics() {
        return this.gdmLabelPanel.getGraphics();
    }

    public JComponent getLabelPanel() {
        return this.gdmLabelPanel;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    void setElementWidth(int n) {
        this.elementWidth = n;
        this.setFontSize(n);
        this.gdmLabelPanel.setFontSize(n);
    }

    int getElementWidth() {
        return this.elementWidth;
    }

    void setAnnotationSize(int n) {
        this.annotationSize = n;
    }

    void setContentWidth(int n) {
        this.contentWidth = n;
    }

    void setElementHeight(int n) {
        this.elementHeight = n;
        this.setFontSize(n);
        this.gdmLabelPanel.setFontSize(n);
    }

    void setContentHeight(int n) {
        this.contentHeight = n;
    }

    void setTracing(boolean bl) {
        this.isTracing = bl;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int n) {
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monospaced", 0, n));
    }

    private void updateMaxExpNameLength() {
        Graphics2D graphics2D = (Graphics2D)this.getLabelPanelGraphics();
        if (graphics2D == null) {
            return;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = 0.0;
        int n = 0;
        for (n = 0; n < this.num_experiments; ++n) {
            String string = this.expData.getSampleName(n);
            d = Math.max(d, (double)fontMetrics.stringWidth(string));
        }
        this.maxExpNameLength = (int)d;
    }

    private int getMaxExpNameLength() {
        return this.maxExpNameLength;
    }

    private void setMaxExpNameLength(int n) {
        this.maxExpNameLength = n;
    }

    protected boolean areExperimentsColored() {
        if (this.indices == null) {
            return false;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getExperimentColor(this.indices[i]) == null) continue;
            return true;
        }
        return false;
    }

    public void updateSize() {
        this.updateMaxExpNameLength();
        this.gdmGradientPanel.updateSize();
        this.gdmLabelPanel.updateSize();
        if (this.isColumnHeader) {
            this.getVerticalScrollBar().setValues(190, 10, 100, 200);
        }
        if (this.isColumnHeader) {
            int n = this.contentWidth + this.elementWidth / 2;
            int n2 = 10 + this.maxTextHeight + this.annotationSize + 4 + 10;
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
        } else {
            int n = 10 + this.maxTextWidth + this.annotationSize + 4 + 10;
            int n3 = this.contentHeight + this.elementHeight / 2;
            this.setSize(n, n3);
            this.setPreferredSize(new Dimension(n, n3));
        }
        this.validate();
    }

    public void setPosColorImages(BufferedImage bufferedImage) {
        this.gdmGradientPanel.setPosColorImages(bufferedImage);
        this.gdmGradientPanel.repaint();
    }

    public void setLeftInset(int n) {
        this.insets.left = n;
    }

    public void setTopInset(int n) {
        this.insets.top = n;
    }

    public Graphics getColorScaleGraphics() {
        return this.gdmGradientPanel.getGraphics();
    }

    private class GDMGradientPanel
    extends JPanel {
        private boolean drawBorders = false;
        private Color missingColor = new Color(128, 128, 128);
        private BufferedImage posColorImage;
        private DecimalFormat decFormat;

        public GDMGradientPanel() {
            this.setBackground(Color.white);
            this.decFormat = new DecimalFormat();
            this.decFormat.setMinimumFractionDigits(1);
            this.decFormat.setMaximumFractionDigits(3);
        }

        private void setFontSize(int n) {
            if (n > 10) {
                n = 10;
            }
            this.setFont(new Font("monospaced", 0, n));
        }

        public void setPosColorImages(BufferedImage bufferedImage) {
            this.posColorImage = bufferedImage;
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setDrawBorders(boolean bl) {
            this.drawBorders = bl;
        }

        public void updateSize() {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            float f = (GDMExpGradientLabelPanel.this.minValue + GDMExpGradientLabelPanel.this.maxValue) / 2.0f;
            String string = this.decFormat.format(f);
            String string2 = this.decFormat.format(GDMExpGradientLabelPanel.this.maxValue);
            String string3 = this.decFormat.format(GDMExpGradientLabelPanel.this.minValue);
            if (graphics2D != null) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                GDMExpGradientLabelPanel.this.maxTextHeight = fontMetrics.getHeight();
                int n = fontMetrics.stringWidth(string);
                int n2 = fontMetrics.stringWidth(string2);
                int n3 = fontMetrics.stringWidth(string3);
                GDMExpGradientLabelPanel.this.maxTextWidth = Math.max(n, n2);
                GDMExpGradientLabelPanel.this.maxTextWidth = Math.max(GDMExpGradientLabelPanel.this.maxTextWidth, n3);
            } else {
                GDMExpGradientLabelPanel.this.maxTextHeight = 4;
                GDMExpGradientLabelPanel.this.maxTextWidth = 4;
            }
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                int n = GDMExpGradientLabelPanel.this.contentWidth + (int)((float)GDMExpGradientLabelPanel.this.elementWidth / 2.0f);
                int n4 = 14 + GDMExpGradientLabelPanel.this.maxTextHeight;
                this.setSize(n, n4);
                this.setPreferredSize(new Dimension(n, n4));
            } else {
                int n = 14 + GDMExpGradientLabelPanel.this.maxTextWidth;
                int n5 = GDMExpGradientLabelPanel.this.contentWidth + (int)((float)GDMExpGradientLabelPanel.this.elementWidth / 2.0f);
                this.setSize(n, n5);
                this.setPreferredSize(new Dimension(n, n5));
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (GDMExpGradientLabelPanel.this.expData == null || GDMExpGradientLabelPanel.this.expData.getFeaturesCount() == 0) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                graphics2D.drawImage(this.posColorImage, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top, 200, 10, null);
            } else {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.drawImage(this.posColorImage, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top, -10 - ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left, 200, 10, null);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getDescent();
            graphics2D.setColor(Color.black);
            if (GDMExpGradientLabelPanel.this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            float f = (GDMExpGradientLabelPanel.this.minValue + GDMExpGradientLabelPanel.this.maxValue) / 2.0f;
            String string = this.decFormat.format(f);
            String string2 = this.decFormat.format(GDMExpGradientLabelPanel.this.minValue);
            String string3 = this.decFormat.format(GDMExpGradientLabelPanel.this.maxValue);
            int n2 = fontMetrics.stringWidth(string2);
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.stringWidth(string3);
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                graphics2D.drawString(string2, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left, 10 + GDMExpGradientLabelPanel.this.maxTextHeight);
                graphics2D.drawString(string, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 100 - n2 / 2, 10 + GDMExpGradientLabelPanel.this.maxTextHeight);
                graphics2D.drawString(string3, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 200 - n3, 10 + GDMExpGradientLabelPanel.this.maxTextHeight);
            } else {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.drawString(string2, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 10, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + GDMExpGradientLabelPanel.this.maxTextHeight);
                graphics2D.drawString(string, (float)(((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 10), (float)(((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + 100) + (float)GDMExpGradientLabelPanel.this.maxTextHeight / 2.0f);
                graphics2D.drawString(string3, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 10, ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + 200);
            }
        }
    }

    private class GDMLabelPanel
    extends JPanel {
        public GDMLabelPanel() {
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        private void setFontSize(int n) {
            if (n > 12) {
                n = 12;
            }
            this.setFont(new Font("monospaced", 0, n));
        }

        public void updateSize() {
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                int n = GDMExpGradientLabelPanel.this.num_experiments * GDMExpGradientLabelPanel.this.elementWidth;
                int n2 = GDMExpGradientLabelPanel.this.maxExpNameLength + 10;
                this.setSize(n, n2);
                this.setPreferredSize(new Dimension(n, n2));
            } else {
                int n = GDMExpGradientLabelPanel.this.maxExpNameLength + 10;
                int n3 = GDMExpGradientLabelPanel.this.num_experiments * GDMExpGradientLabelPanel.this.elementHeight;
                this.setSize(n, n3);
                this.setPreferredSize(new Dimension(n, n3));
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (GDMExpGradientLabelPanel.this.expData == null || GDMExpGradientLabelPanel.this.getElementWidth() <= 2) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (GDMExpGradientLabelPanel.this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.drawLabelHeader(graphics2D);
        }

        private void drawLabelHeader(Graphics2D graphics2D) {
            if (GDMExpGradientLabelPanel.this.num_experiments == 0) {
                return;
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getDescent();
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                graphics2D.rotate(-1.5707963267948966);
            }
            String string = "";
            int n2 = 0;
            int n3 = GDMExpGradientLabelPanel.this.expData.getFeaturesCount();
            if (n3 == 0) {
                return;
            }
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5;
                string = GDMExpGradientLabelPanel.this.indices != null ? GDMExpGradientLabelPanel.this.expData.getSampleName(GDMExpGradientLabelPanel.this.indices[i]) : GDMExpGradientLabelPanel.this.expData.getSampleName(i);
                n2 = Math.max(n2, fontMetrics.stringWidth(string));
                if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                    n5 = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top - this.getSize().height + 1;
                    n4 = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + n + (GDMExpGradientLabelPanel.this.elementWidth + GDMExpGradientLabelPanel.this.getSpacing()) * i + GDMExpGradientLabelPanel.this.elementWidth / 2 + 1;
                } else {
                    n5 = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.left + 1;
                    n4 = ((GDMExpGradientLabelPanel)GDMExpGradientLabelPanel.this).insets.top + n + (GDMExpGradientLabelPanel.this.elementHeight + GDMExpGradientLabelPanel.this.getSpacing()) * i + GDMExpGradientLabelPanel.this.elementHeight / 2;
                }
                graphics2D.drawString(string, n5, n4);
            }
            if (GDMExpGradientLabelPanel.this.isColumnHeader) {
                graphics2D.rotate(1.5707963267948966);
            }
            GDMExpGradientLabelPanel.this.setMaxExpNameLength(n2);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
        }
    }
}

