/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class GDMMemberSelectionDialog
extends AlgorithmDialog {
    JTextField kField;
    JCheckBox allBox;
    JPanel selectPanel;
    JLabel label1;
    JLabel label2;
    JLabel label3;
    int k;
    int result = 2;

    public GDMMemberSelectionDialog(JFrame jFrame, int n) {
        super(jFrame, "Select number of neighbors", true);
        this.k = n;
        Listener listener = new Listener();
        this.allBox = new JCheckBox("Save all neighbors", true);
        this.allBox.setBackground(Color.white);
        this.allBox.setFocusPainted(false);
        this.allBox.setActionCommand("save-all-command");
        this.allBox.setHorizontalAlignment(0);
        this.allBox.addActionListener(listener);
        this.kField = new JTextField("20", 6);
        this.kField.setEnabled(false);
        this.label1 = new JLabel("Save the nearest ");
        this.label1.setEnabled(false);
        this.label2 = new JLabel(" neighbors");
        this.label2.setEnabled(false);
        this.label3 = new JLabel("( There are " + n + " elements in the matrix. )");
        this.label3.setEnabled(false);
        this.selectPanel = new JPanel(new GridBagLayout());
        this.selectPanel.setBackground(Color.white);
        this.selectPanel.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.kField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.label2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.label3, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add((Component)this.allBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 15, 0), 0, 0));
        jPanel.add((Component)this.selectPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    private void resetControls() {
        this.label1.setEnabled(false);
        this.label2.setEnabled(false);
        this.label3.setEnabled(false);
        this.kField.setText("20");
        this.allBox.setSelected(true);
    }

    private void setControls(boolean bl) {
        this.label1.setEnabled(bl);
        this.label2.setEnabled(bl);
        this.label3.setEnabled(bl);
        this.kField.setEnabled(bl);
    }

    public int getK() {
        if (this.allBox.isSelected()) {
            return this.k;
        }
        return Integer.parseInt(this.kField.getText());
    }

    private boolean validateInput() {
        try {
            int n = Integer.parseInt(this.kField.getText());
            if (n < 0) {
                JOptionPane.showMessageDialog(this, "Input must be > 0", "Input Warning", 2);
                return false;
            }
            if (n > this.k) {
                JOptionPane.showMessageDialog(this, "Input must be <= the number of matrix elements (" + this.k + ")", "Input Warning", 2);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid number format.", "Input Warning", 2);
            return false;
        }
        return true;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] stringArray) {
        GDMMemberSelectionDialog gDMMemberSelectionDialog = new GDMMemberSelectionDialog(new JFrame(), 1080);
        gDMMemberSelectionDialog.showModal();
        System.out.println("save " + gDMMemberSelectionDialog.getK() + " neighbors");
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (!GDMMemberSelectionDialog.this.allBox.isSelected()) {
                    if (!GDMMemberSelectionDialog.this.validateInput()) return;
                    GDMMemberSelectionDialog.this.result = 0;
                } else {
                    GDMMemberSelectionDialog.this.result = 0;
                }
            } else if (string.equals("cancel-command")) {
                GDMMemberSelectionDialog.this.result = 2;
                GDMMemberSelectionDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    GDMMemberSelectionDialog.this.resetControls();
                    GDMMemberSelectionDialog.this.result = 2;
                    return;
                }
                if (!string.equals("info-command") && string.equals("save-all-command")) {
                    GDMMemberSelectionDialog.this.setControls(!GDMMemberSelectionDialog.this.allBox.isSelected());
                    return;
                }
            }
            GDMMemberSelectionDialog.this.dispose();
        }
    }
}

