/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class HCLAnnotationBar
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 202006010001L;
    private IData data;
    private int[] rowsOrder;
    private boolean isAntiAliasing = true;
    private int elementHeight = 5;
    private int maxUniqueIDWidth;
    private int maxGeneNameWidth;

    public HCLAnnotationBar(int[] nArray) {
        this.rowsOrder = nArray;
        this.setBackground(Color.white);
        this.setSizes(10, 10);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.rowsOrder);
        objectOutputStream.writeBoolean(this.isAntiAliasing);
        objectOutputStream.writeInt(this.elementHeight);
        objectOutputStream.writeInt(this.maxUniqueIDWidth);
        objectOutputStream.writeInt(this.maxGeneNameWidth);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.rowsOrder = (int[])objectInputStream.readObject();
        this.isAntiAliasing = objectInputStream.readBoolean();
        this.elementHeight = objectInputStream.readInt();
        this.maxUniqueIDWidth = objectInputStream.readInt();
        this.maxGeneNameWidth = objectInputStream.readInt();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isAntiAliasing) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getTopIndex(rectangle.y);
        int n2 = this.getBottomIndex(rectangle.y + rectangle.height, this.rowsOrder.length);
        graphics.setColor(Color.black);
        int n3 = 10;
        int n4 = n3 + 10 + this.maxUniqueIDWidth;
        for (int i = n; i < n2; ++i) {
            int n5 = (i + 1) * this.elementHeight;
            graphics.drawString(this.data.getUniqueId(this.rowsOrder[i]), n3, n5);
            graphics.drawString(this.data.getGeneName(this.rowsOrder[i]), n4, n5);
        }
    }

    private int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementHeight;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementHeight + 1;
        return n3 > n2 ? n2 : n3;
    }

    public void onSelected(IFramework iFramework) {
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.setElementHeight(iDisplayMenu.getElementSize().height);
        this.updateSize();
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        if (this.elementHeight == iDisplayMenu.getElementSize().height && this.isAntiAliasing == iDisplayMenu.isAntiAliasing()) {
            return;
        }
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.setElementHeight(iDisplayMenu.getElementSize().height);
        this.updateSize();
    }

    private void setElementHeight(int n) {
        this.elementHeight = n;
        this.setFont(new Font("monospaced", 0, n));
    }

    private void updateSize() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        this.maxGeneNameWidth = this.getMaxWidth(graphics2D, true);
        this.maxUniqueIDWidth = this.getMaxWidth(graphics2D, false);
        int n = 20 + this.maxGeneNameWidth + this.maxUniqueIDWidth;
        int n2 = this.elementHeight * this.rowsOrder.length + 1;
        this.setSizes(n, n2);
    }

    private int getMaxWidth(Graphics2D graphics2D, boolean bl) {
        if (graphics2D == null || this.data == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        int n2 = this.data.getFeaturesSize();
        for (int i = 0; i < n2; ++i) {
            String string = bl ? this.data.getGeneName(i) : this.data.getUniqueId(i);
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        return n;
    }

    private void setSizes(int n, int n2) {
        this.setSize(n, n2);
        this.setPreferredSize(new Dimension(n, n2));
    }
}

