/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;

public class HCLNodeHeightGraph
extends JPanel
implements IViewer {
    GraphViewer viewer;
    HCLTreeData treeData;
    float minX;
    float maxX;
    float minY;
    float maxY;
    boolean firstView = true;
    DecimalFormat format;

    public HCLNodeHeightGraph(HCLTreeData hCLTreeData, boolean bl) {
        this.treeData = hCLTreeData;
        this.initializeViewer();
    }

    public HCLNodeHeightGraph() {
    }

    private void initializeViewer() {
        this.minX = this.findMinDistance();
        this.maxX = this.findMaxDistance();
        this.minY = 0.0f;
        this.maxY = this.treeData.node_order.length;
        this.viewer = new GraphViewer(null, (int)this.minX, (int)this.maxX, (int)this.minY, (int)this.maxY, (double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, 50, 50, 50, 50, "Node Heights", "Distance", "Number of Terminal Nodes");
        this.viewer.setYAxisValue((double)this.minX);
        this.viewer.setXAxisValue((double)this.minY);
        this.viewer.setShowCoordinates(true);
        this.enterGraphData();
    }

    private float findMinDistance() {
        float f = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.treeData.height.length; ++i) {
            f = Math.min(f, this.treeData.height[i]);
        }
        return f;
    }

    private float findMaxDistance() {
        float f = Float.MIN_VALUE;
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            f = Math.max(f, this.treeData.height[this.treeData.node_order[i]]);
        }
        return f;
    }

    private void enterGraphData() {
        int n;
        int[] nArray = this.treeData.node_order;
        float[] fArray = this.treeData.height;
        double d = 0.0;
        double d2 = nArray.length;
        int n2 = (int)d2;
        if (nArray.length > 1) {
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)this.minX, d2, (double)fArray[nArray[0]], d2, Color.black));
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)fArray[nArray[0]], d2, (double)fArray[nArray[0]], d2 - 1.0, Color.blue));
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] <= -1) continue;
            d = fArray[nArray[n]];
            this.viewer.addGraphElement((GraphElement)new GraphPoint(d, d2 -= 1.0, Color.blue, 2));
            if (n + 1 >= nArray.length || nArray[n + 1] <= -1) continue;
            this.viewer.addGraphElement((GraphElement)new GraphLine(d, d2, (double)fArray[nArray[n + 1]], d2, Color.black));
            this.viewer.addGraphElement((GraphElement)new GraphLine((double)fArray[nArray[n + 1]], d2, (double)fArray[nArray[n + 1]], d2 - 1.0, Color.blue));
        }
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(2);
        for (n = 0; n < 10; ++n) {
            if (this.minX >= 0.0f) {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)((this.maxX - this.minX) / 10.0f * (float)n), 5, Color.black, 0, 0, String.valueOf(this.format.format((this.maxX - this.minX) / 10.0f * (float)n)), Color.black));
            } else {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)(this.minX + (this.maxX - this.minX) / 10.0f * (float)n), 5, Color.black, 0, 0, String.valueOf(this.format.format(this.minX + (this.maxX - this.minX) / 10.0f * (float)n)), Color.black));
            }
            this.viewer.addGraphElement((GraphElement)new GraphTick((double)(nArray.length / 10 * n), 5, Color.black, 1, 0, String.valueOf(nArray.length / 10 * n), Color.black));
        }
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this.viewer;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        if (this.firstView && this.viewer.isVisible()) {
            Graphics graphics = this.viewer.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(new Font("SansSerif", 1, 10));
            int n = fontMetrics.stringWidth(String.valueOf(this.format.format(this.maxX)));
            int n2 = fontMetrics.stringWidth(String.valueOf(this.format.format(this.maxY)));
            fontMetrics = graphics.getFontMetrics(new Font("SansSerif", 1, 12));
            this.viewer.setPreXSpacing((n2 += fontMetrics.getHeight()) + 10);
            this.viewer.setPostYSpacing((n += fontMetrics.getHeight()) + 20);
            this.firstView = false;
        }
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public void setViewer(GraphViewer graphViewer) {
        this.viewer = graphViewer;
    }

    public GraphViewer getViewer() {
        return this.viewer;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }
}

