/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassificationEditor;

public class KNNCInitDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton genesButton;
    JRadioButton expsButton;
    JRadioButton createNewTrgSetButton;
    JRadioButton useExistTrgSetButton;
    JRadioButton trgSetFromCurrent;
    JRadioButton trgSetNotFromCurrent;
    JButton classEditorButton;
    JButton browseTrgFileButton;
    JButton previewTrgSetButton;
    JCheckBox useVarianceFilterBox;
    JCheckBox useCorrelFilterBox;
    JTextField numGenesField;
    JTextField pValueField;
    JTextField numClassesField;
    JTextField numNeighborsField;
    JTextField pathFileField;
    JComboBox annotSelectBox;
    JLabel varLabel;
    JLabel corrLabel;
    JLabel pathLabel;
    JLabel questionLabel;
    JPanel trgSetSpecPanel;
    JTabbedPane classifyOrValidatePane;
    HCLSelectionPanel hclOpsPanel;
    IFramework framework;
    Experiment experiment;
    KNNClassificationEditor knnEditor;
    int numExps;
    int numGenes;

    public KNNCInitDialog(JFrame jFrame, boolean bl, IFramework iFramework) {
        super(jFrame, "KNN Classification", bl);
        this.setBounds(0, 0, 550, 800);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.framework = iFramework;
        this.experiment = this.framework.getData().getExperiment();
        this.knnEditor = new KNNClassificationEditor(this.framework, true, 5);
        this.numExps = this.experiment.getNumberOfSamples();
        this.numGenes = this.experiment.getNumberOfGenes();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.setBorder(new TitledBorder("Classify genes or samples"));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        this.genesButton = new JRadioButton("Classify genes", true);
        this.genesButton.setBackground(Color.white);
        this.expsButton = new JRadioButton("Classify samples", false);
        this.expsButton.setBackground(Color.white);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.genesButton);
        buttonGroup.add(this.expsButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
        gridBagLayout3.setConstraints(this.genesButton, gridBagConstraints);
        jPanel3.add(this.genesButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagLayout3.setConstraints(this.expsButton, gridBagConstraints);
        jPanel3.add(this.expsButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        gridBagConstraints.fill = 0;
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        jPanel4.setBorder(new TitledBorder("Variance filter"));
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout4);
        this.useVarianceFilterBox = new JCheckBox("Use variance filter (if unchecked, use all vectors)", false);
        this.useVarianceFilterBox.setBackground(Color.white);
        this.varLabel = new JLabel("Use only the following number of highest-variance vectors: ");
        this.varLabel.setEnabled(false);
        this.numGenesField = new JTextField("1000", 7);
        this.numGenesField.setEnabled(false);
        this.numGenesField.setBackground(Color.gray);
        this.useVarianceFilterBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    KNNCInitDialog.this.varLabel.setEnabled(false);
                    KNNCInitDialog.this.numGenesField.setEnabled(false);
                    KNNCInitDialog.this.numGenesField.setBackground(Color.gray);
                } else {
                    KNNCInitDialog.this.varLabel.setEnabled(true);
                    KNNCInitDialog.this.numGenesField.setEnabled(true);
                    KNNCInitDialog.this.numGenesField.setBackground(Color.white);
                }
            }
        });
        gridBagConstraints.anchor = 17;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagLayout4.setConstraints(this.useVarianceFilterBox, gridBagConstraints);
        jPanel4.add(this.useVarianceFilterBox);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 70, 50);
        gridBagLayout4.setConstraints(this.varLabel, gridBagConstraints);
        jPanel4.add(this.varLabel);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 30, 0);
        gridBagLayout4.setConstraints(this.numGenesField, gridBagConstraints);
        jPanel4.add(this.numGenesField);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(jPanel4, gridBagConstraints);
        jPanel2.add(jPanel4);
        gridBagConstraints.fill = 0;
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(Color.white);
        jPanel5.setBorder(new TitledBorder("Correlation filter"));
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        jPanel5.setLayout(gridBagLayout5);
        this.useCorrelFilterBox = new JCheckBox("Use correlation filter", false);
        this.useCorrelFilterBox.setBackground(Color.white);
        this.corrLabel = new JLabel("Cutoff p-value for correlation: ");
        this.corrLabel.setEnabled(false);
        this.pValueField = new JTextField("0.01", 7);
        this.pValueField.setEnabled(false);
        this.pValueField.setBackground(Color.gray);
        this.useCorrelFilterBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    KNNCInitDialog.this.corrLabel.setEnabled(false);
                    KNNCInitDialog.this.pValueField.setEnabled(false);
                    KNNCInitDialog.this.pValueField.setBackground(Color.gray);
                } else {
                    KNNCInitDialog.this.corrLabel.setEnabled(true);
                    KNNCInitDialog.this.pValueField.setEnabled(true);
                    KNNCInitDialog.this.pValueField.setBackground(Color.white);
                }
            }
        });
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 50);
        gridBagLayout5.setConstraints(this.useCorrelFilterBox, gridBagConstraints);
        jPanel5.add(this.useCorrelFilterBox);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 70, 50);
        gridBagLayout5.setConstraints(this.corrLabel, gridBagConstraints);
        jPanel5.add(this.corrLabel);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 30, 0);
        gridBagLayout5.setConstraints(this.pValueField, gridBagConstraints);
        jPanel5.add(this.pValueField);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(jPanel5, gridBagConstraints);
        jPanel2.add(jPanel5);
        gridBagConstraints.fill = 0;
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.white);
        jPanel6.setBorder(new TitledBorder("KNN classification parameters"));
        GridBagLayout gridBagLayout6 = new GridBagLayout();
        jPanel6.setLayout(gridBagLayout6);
        JLabel jLabel = new JLabel("Number of classes");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 50);
        gridBagLayout6.setConstraints(jLabel, gridBagConstraints);
        jPanel6.add(jLabel);
        this.numClassesField = new JTextField("5", 7);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagLayout6.setConstraints(this.numClassesField, gridBagConstraints);
        jPanel6.add(this.numClassesField);
        JLabel jLabel2 = new JLabel("Number of neighbors");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 50);
        gridBagLayout6.setConstraints(jLabel2, gridBagConstraints);
        jPanel6.add(jLabel2);
        this.numNeighborsField = new JTextField("3", 7);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
        gridBagLayout6.setConstraints(this.numNeighborsField, gridBagConstraints);
        jPanel6.add(this.numNeighborsField);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(jPanel6, gridBagConstraints);
        jPanel2.add(jPanel6);
        gridBagConstraints.fill = 0;
        JPanel jPanel7 = new JPanel();
        jPanel7.setBackground(Color.white);
        jPanel7.setBorder(new TitledBorder("Create / import training set"));
        GridBagLayout gridBagLayout7 = new GridBagLayout();
        jPanel7.setLayout(gridBagLayout7);
        this.trgSetSpecPanel = new JPanel();
        this.trgSetSpecPanel.setBackground(Color.gray);
        this.trgSetSpecPanel.setBorder(new TitledBorder("Training file specifications"));
        GridBagLayout gridBagLayout8 = new GridBagLayout();
        this.trgSetSpecPanel.setLayout(gridBagLayout8);
        this.questionLabel = new JLabel("Was training file created from current data set?");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 25);
        gridBagLayout8.setConstraints(this.questionLabel, gridBagConstraints);
        this.trgSetSpecPanel.add(this.questionLabel);
        String[] stringArray = new String[]{"field1", "field2", "field3", "field4"};
        this.annotSelectBox = new JComboBox<String>(stringArray);
        this.annotSelectBox.setEnabled(false);
        this.trgSetFromCurrent = new JRadioButton("Yes", true);
        this.trgSetFromCurrent.setBackground(Color.gray);
        this.trgSetNotFromCurrent = new JRadioButton("No - select annotation column of current data set to match to: ", false);
        this.trgSetNotFromCurrent.setBackground(Color.gray);
        this.trgSetFromCurrent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    KNNCInitDialog.this.annotSelectBox.setEnabled(false);
                } else {
                    KNNCInitDialog.this.annotSelectBox.setEnabled(true);
                }
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.trgSetFromCurrent);
        buttonGroup2.add(this.trgSetNotFromCurrent);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 25);
        gridBagLayout8.setConstraints(this.trgSetFromCurrent, gridBagConstraints);
        this.trgSetSpecPanel.add(this.trgSetFromCurrent);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 80, 25);
        gridBagLayout8.setConstraints(this.trgSetNotFromCurrent, gridBagConstraints);
        this.trgSetSpecPanel.add(this.trgSetNotFromCurrent);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 20, 0);
        gridBagLayout8.setConstraints(this.annotSelectBox, gridBagConstraints);
        this.trgSetSpecPanel.add(this.annotSelectBox);
        this.previewTrgSetButton = new JButton("View / modify training set assignments from file");
        gridBagConstraints.anchor = 10;
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 25);
        gridBagLayout8.setConstraints(this.previewTrgSetButton, gridBagConstraints);
        this.trgSetSpecPanel.add(this.previewTrgSetButton);
        this.createNewTrgSetButton = new JRadioButton("Create new training set from data   >>", true);
        this.createNewTrgSetButton.setBackground(Color.white);
        this.useExistTrgSetButton = new JRadioButton("Use previously created training set from file   >>", false);
        this.useExistTrgSetButton.setBackground(Color.white);
        this.classEditorButton = new JButton("Classificaton editor ...");
        this.classEditorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KNNCInitDialog.this.knnEditor = new KNNClassificationEditor(KNNCInitDialog.this.framework, KNNCInitDialog.this.classifyGenes(), KNNCInitDialog.this.getNumClasses());
                KNNCInitDialog.this.knnEditor.setVisible(true);
            }
        });
        this.browseTrgFileButton = new JButton("Browse files ...");
        this.pathLabel = new JLabel("Selected file: ");
        this.pathFileField = new JTextField(80);
        this.browseTrgFileButton.setEnabled(false);
        this.pathLabel.setEnabled(false);
        this.pathFileField.setEnabled(false);
        this.questionLabel.setEnabled(false);
        this.trgSetFromCurrent.setEnabled(false);
        this.trgSetNotFromCurrent.setEnabled(false);
        this.annotSelectBox.setEnabled(false);
        this.previewTrgSetButton.setEnabled(false);
        this.createNewTrgSetButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    KNNCInitDialog.this.trgSetSpecPanel.setBackground(Color.gray);
                    KNNCInitDialog.this.browseTrgFileButton.setEnabled(false);
                    KNNCInitDialog.this.pathLabel.setEnabled(false);
                    KNNCInitDialog.this.pathFileField.setEnabled(false);
                    KNNCInitDialog.this.questionLabel.setEnabled(false);
                    KNNCInitDialog.this.trgSetFromCurrent.setEnabled(false);
                    KNNCInitDialog.this.trgSetFromCurrent.setBackground(Color.gray);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setEnabled(false);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setBackground(Color.gray);
                    KNNCInitDialog.this.annotSelectBox.setEnabled(false);
                    KNNCInitDialog.this.previewTrgSetButton.setEnabled(false);
                } else {
                    KNNCInitDialog.this.trgSetSpecPanel.setBackground(Color.white);
                    KNNCInitDialog.this.browseTrgFileButton.setEnabled(true);
                    KNNCInitDialog.this.pathLabel.setEnabled(true);
                    KNNCInitDialog.this.pathFileField.setEnabled(true);
                    KNNCInitDialog.this.questionLabel.setEnabled(true);
                    KNNCInitDialog.this.trgSetFromCurrent.setEnabled(true);
                    KNNCInitDialog.this.trgSetFromCurrent.setBackground(Color.white);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setEnabled(true);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setBackground(Color.white);
                    if (KNNCInitDialog.this.trgSetFromCurrent.isSelected()) {
                        KNNCInitDialog.this.annotSelectBox.setEnabled(false);
                    } else {
                        KNNCInitDialog.this.annotSelectBox.setEnabled(true);
                    }
                    KNNCInitDialog.this.previewTrgSetButton.setEnabled(true);
                }
            }
        });
        this.useExistTrgSetButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    KNNCInitDialog.this.classEditorButton.setEnabled(false);
                } else {
                    KNNCInitDialog.this.classEditorButton.setEnabled(true);
                }
            }
        });
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.createNewTrgSetButton);
        buttonGroup3.add(this.useExistTrgSetButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 10);
        gridBagLayout7.setConstraints(this.createNewTrgSetButton, gridBagConstraints);
        jPanel7.add(this.createNewTrgSetButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagLayout7.setConstraints(this.classEditorButton, gridBagConstraints);
        jPanel7.add(this.classEditorButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 10);
        gridBagLayout7.setConstraints(this.useExistTrgSetButton, gridBagConstraints);
        jPanel7.add(this.useExistTrgSetButton);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
        gridBagLayout7.setConstraints(this.browseTrgFileButton, gridBagConstraints);
        jPanel7.add(this.browseTrgFileButton);
        gridBagConstraints.anchor = 17;
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 5);
        gridBagLayout7.setConstraints(this.pathLabel, gridBagConstraints);
        jPanel7.add(this.pathLabel);
        this.pathFileField.setBackground(Color.lightGray);
        this.pathFileField.setEditable(false);
        this.pathFileField.setText("No file currently selected");
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.buildConstraints(gridBagConstraints, 0, 3, 2, 1, 100, 5);
        gridBagLayout7.setConstraints(this.pathFileField, gridBagConstraints);
        jPanel7.add(this.pathFileField);
        gridBagConstraints.fill = 0;
        this.buildConstraints(gridBagConstraints, 0, 4, 2, 1, 100, 70);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout7.setConstraints(this.trgSetSpecPanel, gridBagConstraints);
        jPanel7.add(this.trgSetSpecPanel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 100, 50);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(jPanel7, gridBagConstraints);
        jPanel2.add(jPanel7);
        gridBagConstraints.fill = 0;
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 100, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel2.add(this.hclOpsPanel);
        gridBagConstraints.fill = 0;
        this.classifyOrValidatePane = new JTabbedPane();
        this.classifyOrValidatePane.add("Classify", jPanel2);
        gridBagConstraints.fill = 1;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.classifyOrValidatePane, gridBagConstraints);
        jPanel.add(this.classifyOrValidatePane);
        gridBagConstraints.fill = 0;
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean classifyGenes() {
        return this.genesButton.isSelected();
    }

    public int getNumClasses() {
        String string = this.numClassesField.getText();
        return Integer.parseInt(string);
    }

    public static void main(String[] stringArray) {
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                KNNCInitDialog.this.okPressed = true;
                KNNCInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                KNNCInitDialog.this.okPressed = false;
                KNNCInitDialog.this.genesButton.setSelected(true);
                KNNCInitDialog.this.expsButton.setSelected(false);
                KNNCInitDialog.this.useVarianceFilterBox.setSelected(false);
                KNNCInitDialog.this.useCorrelFilterBox.setSelected(false);
                KNNCInitDialog.this.numClassesField.setText("5");
                KNNCInitDialog.this.numNeighborsField.setText("3");
                KNNCInitDialog.this.trgSetFromCurrent.setSelected(true);
                KNNCInitDialog.this.createNewTrgSetButton.setSelected(true);
                KNNCInitDialog.this.annotSelectBox.setSelectedIndex(0);
                KNNCInitDialog.this.hclOpsPanel.setHCLSelected(false);
            } else if (string.equals("cancel-command")) {
                KNNCInitDialog.this.okPressed = false;
                KNNCInitDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(KNNCInitDialog.this, "KNNC Parameter Selections");
                KNNCInitDialog.this.okPressed = false;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
                return;
            }
        }
    }
}

