/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class OneWayANOVAInitBox
extends AlgorithmDialog {
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 9;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    boolean okPressed = false;
    Vector exptNames;
    MultiClassPanel mPanel;
    PermOrFDistPanel permPanel;
    PValuePanel pPanel;
    HCLSigOnlyPanel hclOpsPanel;

    public OneWayANOVAInitBox(JFrame jFrame, boolean bl, Vector vector) {
        super(jFrame, "One-way ANOVA Initialization", bl);
        this.exptNames = vector;
        this.setBounds(0, 0, 800, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.mPanel = new MultiClassPanel();
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 80);
        gridBagLayout.setConstraints(this.mPanel, gridBagConstraints);
        jPanel.add(this.mPanel);
        this.permPanel = new PermOrFDistPanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
        gridBagLayout.setConstraints(this.permPanel, gridBagConstraints);
        jPanel.add(this.permPanel);
        this.pPanel = new PValuePanel();
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 10);
        gridBagLayout.setConstraints(this.pPanel, gridBagConstraints);
        jPanel.add(this.pPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 5);
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public int[] getGroupAssignments() {
        int[] nArray = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.mPanel.mulgPanel.notInGroupRadioButtons[i].isSelected()) {
                nArray[i] = 0;
                continue;
            }
            for (int j = 0; j < this.mPanel.mulgPanel.exptGroupRadioButtons.length; ++j) {
                if (!this.mPanel.mulgPanel.exptGroupRadioButtons[j][i].isSelected()) continue;
                nArray[i] = j + 1;
                continue block0;
            }
        }
        return nArray;
    }

    public int getNumGroups() {
        return this.mPanel.numGroups;
    }

    public boolean usePerms() {
        return this.permPanel.permutButton.isSelected();
    }

    public int getNumPerms() {
        return Integer.parseInt(this.permPanel.timesField.getText());
    }

    public double getPValue() {
        return Double.parseDouble(this.pPanel.pValueInputField.getText());
    }

    public int getFalseNum() {
        return Integer.parseInt(this.pPanel.falseNumField.getText());
    }

    public double getFalseProp() {
        return Double.parseDouble(this.pPanel.falsePropField.getText());
    }

    public boolean validateFalseNum() {
        int n;
        try {
            String string = this.pPanel.falseNumField.getText();
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        if (n < 0) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseProp() {
        float f;
        try {
            String string = this.pPanel.falsePropField.getText();
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        if (f <= 0.0f || f > 1.0f) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        return true;
    }

    public int getCorrectionMethod() {
        int n = 1;
        if (this.pPanel.justAlphaButton.isSelected()) {
            n = 1;
        } else if (this.pPanel.stdBonfButton.isSelected()) {
            n = 2;
        } else if (this.pPanel.adjBonfButton.isSelected()) {
            n = 3;
        } else if (this.pPanel.maxTButton.isSelected()) {
            n = 9;
        } else if (this.pPanel.falseNumButton.isSelected()) {
            n = 12;
        } else if (this.pPanel.falsePropButton.isSelected()) {
            n = 13;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 100; ++i) {
            vector.add("Expt " + i);
        }
        OneWayANOVAInitBox oneWayANOVAInitBox = new OneWayANOVAInitBox(jFrame, true, vector);
        oneWayANOVAInitBox.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            block17: {
                String string = actionEvent.getActionCommand();
                if (string.equals("ok-command")) {
                    int n;
                    boolean bl = false;
                    int[] nArray = OneWayANOVAInitBox.this.getGroupAssignments();
                    int n2 = OneWayANOVAInitBox.this.getNumGroups();
                    int[] nArray2 = new int[n2];
                    for (n = 0; n < nArray2.length; ++n) {
                        nArray2[n] = 0;
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        int n3 = nArray[n];
                        if (n3 == 0) continue;
                        int n4 = n3 - 1;
                        nArray2[n4] = nArray2[n4] + 1;
                    }
                    for (n = 0; n < nArray2.length; ++n) {
                        if (nArray2[n] > 1) continue;
                        JOptionPane.showMessageDialog(null, "Each group must contain more than one sample.", "Error", 2);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        try {
                            if (OneWayANOVAInitBox.this.pPanel.falseNumButton.isSelected() && !OneWayANOVAInitBox.this.validateFalseNum()) {
                                OneWayANOVAInitBox.this.okPressed = false;
                                return;
                            }
                            if (OneWayANOVAInitBox.this.pPanel.falsePropButton.isSelected() && !OneWayANOVAInitBox.this.validateFalseProp()) {
                                OneWayANOVAInitBox.this.okPressed = false;
                                return;
                            }
                            double d = Double.parseDouble(OneWayANOVAInitBox.this.pPanel.pValueInputField.getText());
                            if (d <= 0.0 || d > 1.0 || OneWayANOVAInitBox.this.usePerms() && OneWayANOVAInitBox.this.getNumPerms() <= 1) {
                                JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                                break block17;
                            }
                            OneWayANOVAInitBox.this.okPressed = true;
                            OneWayANOVAInitBox.this.dispose();
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                        }
                    }
                } else if (string.equals("reset-command")) {
                    OneWayANOVAInitBox.this.mPanel.reset();
                    OneWayANOVAInitBox.this.pPanel.reset();
                } else if (string.equals("cancel-command")) {
                    OneWayANOVAInitBox.this.okPressed = false;
                    OneWayANOVAInitBox.this.dispose();
                } else if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(OneWayANOVAInitBox.this, "One Way ANOVA Initialization Dialog");
                    OneWayANOVAInitBox.this.okPressed = false;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
        }
    }

    class PValuePanel
    extends JPanel {
        JTextField pValueInputField;
        JTextField falseNumField;
        JTextField falsePropField;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;
        JRadioButton maxTButton;
        JRadioButton falseNumButton;
        JRadioButton falsePropButton;

        public PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "P-value / false discovery parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setBackground(Color.white);
            this.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel("Enter alpha (critical p-value): ");
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 25);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.pValueInputField = new JTextField("0.01", 7);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.pValueInputField, gridBagConstraints);
            this.add(this.pValueInputField);
            gridBagConstraints.anchor = 10;
            this.justAlphaButton = new JRadioButton("Just alpha (no correction)", true);
            this.justAlphaButton.setBackground(Color.white);
            this.stdBonfButton = new JRadioButton("Standard Bonferroni", false);
            this.stdBonfButton.setBackground(Color.white);
            this.adjBonfButton = new JRadioButton("Adjusted Bonferroni", false);
            this.adjBonfButton.setBackground(Color.white);
            this.maxTButton = new JRadioButton("Westfall-Young step-down maxT", false);
            this.maxTButton.setBackground(Color.white);
            this.maxTButton.setEnabled(false);
            this.falseNumButton = new JRadioButton("EITHER, The number of false significant genes should not exceed", false);
            this.falseNumButton.setEnabled(false);
            this.falseNumButton.setFocusPainted(false);
            this.falseNumButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falseNumButton.setBackground(Color.white);
            this.falsePropButton = new JRadioButton("OR, The proportion of false significant genes should not exceed", false);
            this.falsePropButton.setEnabled(false);
            this.falsePropButton.setFocusPainted(false);
            this.falsePropButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falsePropButton.setBackground(Color.white);
            this.falseNumField = new JTextField(10);
            this.falseNumField.setText("10");
            this.falseNumField.setEnabled(false);
            this.falsePropField = new JTextField(10);
            this.falsePropField.setText("0.05");
            this.falsePropField.setEnabled(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.justAlphaButton);
            buttonGroup.add(this.stdBonfButton);
            buttonGroup.add(this.adjBonfButton);
            buttonGroup.add(this.maxTButton);
            buttonGroup.add(this.falseNumButton);
            buttonGroup.add(this.falsePropButton);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "False discovery control (permutations only)", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            JLabel jLabel2 = new JLabel("With confidence of [1 - alpha] : ");
            gridBagConstraints.anchor = 17;
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 34);
            gridBagLayout2.setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            gridBagConstraints.anchor = 10;
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 33);
            gridBagConstraints.anchor = 13;
            gridBagLayout2.setConstraints(this.falseNumButton, gridBagConstraints);
            jPanel.add(this.falseNumButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(this.falseNumField, gridBagConstraints);
            jPanel.add(this.falseNumField);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 50, 33);
            gridBagConstraints.anchor = 13;
            gridBagLayout2.setConstraints(this.falsePropButton, gridBagConstraints);
            jPanel.add(this.falsePropButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(this.falsePropField, gridBagConstraints);
            jPanel.add(this.falsePropField);
            gridBagConstraints.anchor = 10;
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 25, 25);
            gridBagLayout.setConstraints(this.justAlphaButton, gridBagConstraints);
            this.add(this.justAlphaButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 25, 0);
            gridBagLayout.setConstraints(this.stdBonfButton, gridBagConstraints);
            this.add(this.stdBonfButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 25, 0);
            gridBagLayout.setConstraints(this.adjBonfButton, gridBagConstraints);
            this.add(this.adjBonfButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 25, 0);
            gridBagLayout.setConstraints(this.maxTButton, gridBagConstraints);
            this.add(this.maxTButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 2, 4, 1, 100, 50);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
        }

        private void reset() {
            this.pValueInputField.setText("0.01");
            this.justAlphaButton.setSelected(true);
        }
    }

    class PermOrFDistPanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JLabel numPermsLabel;
        JTextField timesField;

        PermOrFDistPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Permutations or F-distribution", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on F-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations");
            this.numPermsLabel.setEnabled(false);
            this.timesField = new JTextField("1000", 7);
            this.timesField.setEnabled(false);
            this.timesField.setBackground(Color.darkGray);
            this.tDistButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PermOrFDistPanel this$1;
                {
                    this.this$1 = permOrFDistPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.numPermsLabel.setEnabled(false);
                    this.this$1.timesField.setEnabled(false);
                    this.this$1.timesField.setBackground(Color.darkGray);
                    if (PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.maxTButton.isSelected() || PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falseNumButton.isSelected() || PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falsePropButton.isSelected()) {
                        PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.justAlphaButton.setSelected(true);
                    }
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.maxTButton.setEnabled(false);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falseNumButton.setEnabled(false);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falsePropButton.setEnabled(false);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falseNumField.setEnabled(false);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falsePropField.setEnabled(false);
                }
            });
            buttonGroup.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            this.permutButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PermOrFDistPanel this$1;
                {
                    this.this$1 = permOrFDistPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.numPermsLabel.setEnabled(true);
                    this.this$1.timesField.setEnabled(true);
                    this.this$1.timesField.setBackground(Color.white);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.maxTButton.setEnabled(true);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falseNumButton.setEnabled(true);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falsePropButton.setEnabled(true);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falseNumField.setEnabled(true);
                    PermOrFDistPanel.access$300((PermOrFDistPanel)this.this$1).pPanel.falsePropField.setEnabled(true);
                }
            });
            buttonGroup.add(this.permutButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 3, 1, 100, 50);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.tDistButton, gridBagConstraints);
            this.add(this.tDistButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 30, 50);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.permutButton, gridBagConstraints);
            this.add(this.permutButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 30, 0);
            gridBagLayout.setConstraints(this.numPermsLabel, gridBagConstraints);
            this.add(this.numPermsLabel);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 40, 0);
            gridBagLayout.setConstraints(this.timesField, gridBagConstraints);
            this.add(this.timesField);
        }

        static /* synthetic */ OneWayANOVAInitBox access$300(PermOrFDistPanel permOrFDistPanel) {
            return permOrFDistPanel.OneWayANOVAInitBox.this;
        }
    }

    class MultiClassPanel
    extends JPanel {
        NumGroupsPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        MultiGroupExperimentsPanel mulgPanel;
        int numGroups;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new NumGroupsPanel();
            OneWayANOVAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            this.ngPanel.okButton.addActionListener(new ActionListener(this, OneWayANOVAInitBox.this){
                private final /* synthetic */ OneWayANOVAInitBox val$this$0;
                private final /* synthetic */ MultiClassPanel this$1;
                {
                    this.this$1 = multiClassPanel;
                    this.val$this$0 = oneWayANOVAInitBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ngPanel.okPressed = true;
                    try {
                        this.this$1.numGroups = Integer.parseInt(this.this$1.ngPanel.numGroupsField.getText());
                        if (this.this$1.numGroups <= 2) {
                            JOptionPane.showMessageDialog(null, "Please enter a positive integer > 2!", "Error", 0);
                        } else {
                            this.this$1.mulgPanel = this.this$1.new MultiGroupExperimentsPanel(MultiClassPanel.access$000((MultiClassPanel)this.this$1).exptNames, this.this$1.numGroups);
                            MultiClassPanel.access$000(this.this$1).buildConstraints(this.this$1.constraints, 0, 1, 1, 1, 0, 90);
                            this.this$1.constraints.fill = 1;
                            this.this$1.gridbag.setConstraints(this.this$1.mulgPanel, this.this$1.constraints);
                            this.this$1.remove(this.this$1.dummyPanel);
                            this.this$1.add(this.this$1.mulgPanel);
                            this.this$1.validate();
                            this.this$1.ngPanel.okButton.setEnabled(false);
                            this.this$1.ngPanel.numGroupsField.setEnabled(false);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Please enter a positive integer > 2!", "Error", 0);
                    }
                }
            });
            this.add(this.ngPanel);
            OneWayANOVAInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        private void reset() {
            this.mulgPanel.reset();
        }

        class MultiGroupExperimentsPanel
        extends JPanel {
            int numPanels = 0;
            JLabel[] expLabels;
            JRadioButton[][] exptGroupRadioButtons;
            JRadioButton[] notInGroupRadioButtons;

            MultiGroupExperimentsPanel(Vector vector, int n) {
                int n2;
                int n3;
                int n4;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.expLabels = new JLabel[vector.size()];
                this.exptGroupRadioButtons = new JRadioButton[n][vector.size()];
                this.numPanels = vector.size() / 512 + 1;
                this.notInGroupRadioButtons = new JRadioButton[vector.size()];
                ButtonGroup[] buttonGroupArray = new ButtonGroup[vector.size()];
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagLayout gridBagLayout2 = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout2);
                JPanel[] jPanelArray = new JPanel[this.numPanels];
                int n5 = 0;
                for (n4 = 0; n4 < jPanelArray.length; ++n4) {
                    jPanelArray[n4] = new JPanel(gridBagLayout);
                }
                for (n4 = 0; n4 < vector.size(); ++n4) {
                    String string = (String)vector.get(n4);
                    this.expLabels[n4] = new JLabel(string);
                    buttonGroupArray[n4] = new ButtonGroup();
                    for (n3 = 0; n3 < n; ++n3) {
                        this.exptGroupRadioButtons[n3][n4] = new JRadioButton("Group " + (n3 + 1) + "     ", n3 == 0);
                        buttonGroupArray[n4].add(this.exptGroupRadioButtons[n3][n4]);
                    }
                    n5 = n4 / 512;
                    this.notInGroupRadioButtons[n4] = new JRadioButton("Not in groups", false);
                    buttonGroupArray[n4].add(this.notInGroupRadioButtons[n4]);
                    for (n3 = 0; n3 < n; ++n3) {
                        OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, n3, n4 % 512, 1, 1, 100, 100);
                        gridBagLayout.setConstraints(this.exptGroupRadioButtons[n3][n4], gridBagConstraints);
                        jPanelArray[n5].add(this.exptGroupRadioButtons[n3][n4]);
                    }
                    OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, n + 1, n4 % 512, 1, 1, 100, 100);
                    gridBagLayout.setConstraints(this.notInGroupRadioButtons[n4], gridBagConstraints);
                    jPanelArray[n5].add(this.notInGroupRadioButtons[n4]);
                }
                n4 = 0;
                for (int i = 0; i < this.expLabels.length; ++i) {
                    if (!(this.expLabels[i].getPreferredSize().getWidth() > (double)n4)) continue;
                    n4 = (int)Math.ceil(this.expLabels[i].getPreferredSize().getWidth());
                }
                JPanel jPanel = new JPanel(new GridBagLayout());
                for (n3 = 0; n3 < this.numPanels; ++n3) {
                    jPanel.add((Component)jPanelArray[n3], new GridBagConstraints(0, n3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane jScrollPane = new JScrollPane(jPanel);
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jScrollPane.setVerticalScrollBarPolicy(22);
                JPanel[] jPanelArray2 = new JPanel[this.numPanels];
                GridBagLayout gridBagLayout3 = new GridBagLayout();
                for (n2 = 0; n2 < jPanelArray2.length; ++n2) {
                    jPanelArray2[n2] = new JPanel();
                    jPanelArray2[n2].setSize(50, jPanelArray[n2].getPreferredSize().height);
                    jPanelArray2[n2].setPreferredSize(new Dimension(n4 + 10, jPanelArray[n2].getPreferredSize().height));
                    jPanelArray2[n2].setLayout(gridBagLayout3);
                }
                for (n2 = 0; n2 < this.expLabels.length; ++n2) {
                    n5 = n2 / 512;
                    OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, n2 % 512, 1, 1, 100, 100);
                    gridBagConstraints.fill = 1;
                    gridBagLayout3.setConstraints(this.expLabels[n2], gridBagConstraints);
                    jPanelArray2[n5].add(this.expLabels[n2]);
                }
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                for (int i = 0; i < jPanelArray2.length; ++i) {
                    jPanel2.add((Component)jPanelArray2[i], new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                jScrollPane.setRowHeaderView(jPanel2);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
                gridBagConstraints.fill = 1;
                gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
                this.add(jScrollPane);
                JLabel jLabel = new JLabel("Note: Each group MUST each contain more than one sample.");
                jLabel.setHorizontalAlignment(0);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
                gridBagConstraints.anchor = 13;
                gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                JPanel jPanel3 = new JPanel();
                GridBagLayout gridBagLayout4 = new GridBagLayout();
                jPanel3.setLayout(gridBagLayout4);
                jPanel3.setBackground(Color.white);
                JButton jButton = new JButton("  Save settings  ");
                jButton.setFocusPainted(false);
                jButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton jButton2 = new JButton("  Load settings  ");
                jButton2.setFocusPainted(false);
                jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton jButton3 = new JButton("  Reset  ");
                jButton3.setFocusPainted(false);
                jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                int n6 = vector.size();
                jButton3.addActionListener(new ActionListener(this, n6){
                    private final /* synthetic */ int val$finNum;
                    private final /* synthetic */ MultiGroupExperimentsPanel this$2;
                    {
                        this.this$2 = multiGroupExperimentsPanel;
                        this.val$finNum = n;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        for (int i = 0; i < this.val$finNum; ++i) {
                            this.this$2.exptGroupRadioButtons[0][i].setSelected(true);
                        }
                    }
                });
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("Data"));
                jButton.addActionListener(new ActionListener(this, jFileChooser, MultiClassPanel.this){
                    private final /* synthetic */ JFileChooser val$fc;
                    private final /* synthetic */ MultiClassPanel val$this$1;
                    private final /* synthetic */ MultiGroupExperimentsPanel this$2;
                    {
                        this.this$2 = multiGroupExperimentsPanel;
                        this.val$fc = jFileChooser;
                        this.val$this$1 = multiClassPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = this.val$fc.showSaveDialog(this.this$2);
                        if (n == 0) {
                            File file = this.val$fc.getSelectedFile();
                            try {
                                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                                int[] nArray = MultiClassPanel.access$000(MultiGroupExperimentsPanel.access$100(this.this$2)).getGroupAssignments();
                                for (int i = 0; i < nArray.length; ++i) {
                                    printWriter.print(nArray[i]);
                                    if (i >= nArray.length - 1) continue;
                                    printWriter.print("\n");
                                }
                                printWriter.println();
                                printWriter.flush();
                                printWriter.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                jButton2.addActionListener(new ActionListener(this, jFileChooser, MultiClassPanel.this, n6){
                    private final /* synthetic */ JFileChooser val$fc;
                    private final /* synthetic */ MultiClassPanel val$this$1;
                    private final /* synthetic */ int val$finNum;
                    private final /* synthetic */ MultiGroupExperimentsPanel this$2;
                    {
                        this.this$2 = multiGroupExperimentsPanel;
                        this.val$fc = jFileChooser;
                        this.val$this$1 = multiClassPanel;
                        this.val$finNum = n;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = this.val$fc.showOpenDialog(this.this$2);
                        if (n == 0) {
                            try {
                                String string;
                                FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                Vector<Integer> vector = new Vector<Integer>();
                                while ((string = bufferedReader.readLine()) != null) {
                                    vector.add(new Integer(string));
                                }
                                bufferedReader.close();
                                int[] nArray = MultiClassPanel.access$000(MultiGroupExperimentsPanel.access$100(this.this$2)).getGroupAssignments();
                                if (vector.size() != nArray.length) {
                                    JOptionPane.showMessageDialog(MultiClassPanel.access$000((MultiClassPanel)MultiGroupExperimentsPanel.access$100((MultiGroupExperimentsPanel)this.this$2)).mPanel, "Incompatible file!", "Error", 2);
                                } else {
                                    for (int i = 0; i < vector.size(); ++i) {
                                        int n2 = (Integer)vector.get(i);
                                        if (n2 != 0) {
                                            this.this$2.exptGroupRadioButtons[n2 - 1][i].setSelected(true);
                                            continue;
                                        }
                                        this.this$2.notInGroupRadioButtons[i].setSelected(true);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(MultiClassPanel.access$000((MultiClassPanel)MultiGroupExperimentsPanel.access$100((MultiGroupExperimentsPanel)this.this$2)).mPanel, "Incompatible file!", "Error", 2);
                                for (int i = 0; i < this.val$finNum; ++i) {
                                    this.this$2.exptGroupRadioButtons[0][i].setSelected(true);
                                }
                            }
                        }
                    }
                });
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
                gridBagLayout4.setConstraints(jButton, gridBagConstraints);
                jPanel3.add(jButton);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
                gridBagLayout4.setConstraints(jButton2, gridBagConstraints);
                jPanel3.add(jButton2);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
                gridBagLayout4.setConstraints(jButton3, gridBagConstraints);
                jPanel3.add(jButton3);
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 5);
                gridBagConstraints.anchor = 10;
                gridBagLayout2.setConstraints(jPanel3, gridBagConstraints);
                this.add(jPanel3);
            }

            private void reset() {
                for (int i = 0; i < ((MultiClassPanel)MultiClassPanel.this).OneWayANOVAInitBox.this.exptNames.size(); ++i) {
                    this.exptGroupRadioButtons[0][i].setSelected(true);
                }
            }

            static /* synthetic */ MultiClassPanel access$100(MultiGroupExperimentsPanel multiGroupExperimentsPanel) {
                return multiGroupExperimentsPanel.MultiClassPanel.this;
            }
        }

        class NumGroupsPanel
        extends JPanel {
            JTextField numGroupsField;
            JButton okButton;
            boolean okPressed = false;

            public NumGroupsPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                JLabel jLabel = new JLabel("Number of groups ");
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 100);
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                this.numGroupsField = new JTextField("", 7);
                gridBagConstraints.anchor = 17;
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 30, 0);
                gridBagLayout.setConstraints(this.numGroupsField, gridBagConstraints);
                this.add(this.numGroupsField);
                this.okButton = new JButton("OK");
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 40, 0);
                gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
                this.add(this.okButton);
            }

            public void setVisible(boolean bl) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(bl);
                if (bl) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }
}

