/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.pca.Content3D;

public class PCASelectionAreaDialog
extends AlgorithmDialog {
    private int result;
    private Content3D content;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;
    private JTextField textField5;
    private JTextField textField6;
    private float positionX;
    private float positionY;
    private float positionZ;
    private float sizeX;
    private float sizeY;
    private float sizeZ;
    private int initSizePos;
    private float initSize;
    private final float maxPos;
    private JSlider posXSlider;
    private JSlider posYSlider;
    private JSlider posZSlider;
    private JSlider sizeXSlider;
    private JSlider sizeYSlider;
    private JSlider sizeZSlider;

    public PCASelectionAreaDialog(Frame frame, float f, float f2, float f3, float f4, float f5, float f6) {
        super(frame, "PCA selection area configuration", true);
        this.positionX = f;
        this.positionY = f2;
        this.positionZ = f3;
        this.sizeX = f4;
        this.sizeY = f5;
        this.sizeZ = f6;
        this.maxPos = f;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 10, 0));
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 10));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel("Position X  "));
        this.textField1 = new JTextField(Float.toString(f), 5);
        jPanel.add((Component)this.textField1, "East");
        jPanel.add(new JLabel("Position Y  "));
        this.textField2 = new JTextField(Float.toString(f2), 5);
        jPanel.add((Component)this.textField2, "East");
        jPanel.add(new JLabel("Position Z  "));
        this.textField3 = new JTextField(Float.toString(f3), 5);
        jPanel.add((Component)this.textField3, "East");
        jPanel.add(new JLabel("Size X  "));
        this.textField4 = new JTextField(Float.toString(f4), 5);
        jPanel.add((Component)this.textField4, "East");
        jPanel.add(new JLabel("Size Y "));
        this.textField5 = new JTextField(Float.toString(f5), 5);
        jPanel.add((Component)this.textField5, "East");
        jPanel.add(new JLabel("Size Z "));
        this.textField6 = new JTextField(Float.toString(f6), 5);
        jPanel.add((Component)this.textField6, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setForeground(Color.white);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)new JLabel(GUIFactory.getIcon("tigr_logo.gif")), "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        this.addContent(jPanel3);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public PCASelectionAreaDialog(Content3D content3D, Frame frame, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        super(frame, "PCA selection area configuration", false);
        this.positionX = f;
        this.positionY = f2;
        this.positionZ = f3;
        this.sizeX = f4;
        this.sizeY = f5;
        this.sizeZ = f6;
        this.content = content3D;
        this.maxPos = f7;
        this.posXSlider = new JSlider(-1000, 1000, 0);
        this.posYSlider = new JSlider(-1000, 1000, 0);
        this.posZSlider = new JSlider(-1000, 1000, 0);
        this.initSizePos = this.getSliderPos(f4);
        this.initSize = f4;
        this.sizeXSlider = new JSlider(0, 2000, this.initSizePos);
        this.sizeYSlider = new JSlider(0, 2000, this.initSizePos);
        this.sizeZSlider = new JSlider(0, 2000, this.initSizePos);
        this.posXSlider.setBackground(Color.white);
        this.posYSlider.setBackground(Color.white);
        this.posZSlider.setBackground(Color.white);
        this.sizeXSlider.setBackground(Color.white);
        this.sizeYSlider.setBackground(Color.white);
        this.sizeZSlider.setBackground(Color.white);
        this.textField1 = new JTextField(Float.toString(f), 5);
        this.textField2 = new JTextField(Float.toString(f2), 5);
        this.textField3 = new JTextField(Float.toString(f3), 5);
        this.textField4 = new JTextField(Float.toString(f4), 5);
        this.textField5 = new JTextField(Float.toString(f5), 5);
        this.textField6 = new JTextField(Float.toString(f5), 5);
        this.textField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField1.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (n <= -1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posXSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField1.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.posXSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField1.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionX(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField1.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionX(f);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField1.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField1.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (n <= -1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posXSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField1.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.posXSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField1.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionX(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField1.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionX(f);
                PCASelectionAreaDialog.this.updateContent();
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.posXSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                float f = PCASelectionAreaDialog.this.getCoord(n);
                if (n == -1000) {
                    f = -1.0f * PCASelectionAreaDialog.this.maxPos;
                }
                if (n == 1000) {
                    f = PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField1.setText("" + f);
                String string = PCASelectionAreaDialog.this.textField1.getText();
                float f2 = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionX(f2);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField2.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (n <= -1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posYSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField2.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.posYSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField2.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionY(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField2.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionY(f);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField2.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField2.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (n <= -1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posYSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField2.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.posYSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField2.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionY(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField2.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionY(f);
                PCASelectionAreaDialog.this.updateContent();
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.posYSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                float f = PCASelectionAreaDialog.this.getCoord(n);
                if (n == -1000) {
                    f = -1.0f * PCASelectionAreaDialog.this.maxPos;
                }
                if (n == 1000) {
                    f = PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField2.setText("" + f);
                String string = PCASelectionAreaDialog.this.textField2.getText();
                float f2 = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionY(f2);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField3.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (n <= -1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posZSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField3.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.posZSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField3.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionZ(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField3.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionZ(f);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField3.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField3.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (n <= -1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posZSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField3.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.posZSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField3.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionZ(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField3.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionZ(f);
                PCASelectionAreaDialog.this.updateContent();
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.posZSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                float f = PCASelectionAreaDialog.this.getCoord(n);
                if (n == -1000) {
                    f = -1.0f * PCASelectionAreaDialog.this.maxPos;
                }
                if (n == 1000) {
                    f = PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField3.setText("" + f);
                String string = PCASelectionAreaDialog.this.textField3.getText();
                float f2 = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setPositionZ(f2);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField4.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 2000) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField4.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (n == 0) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField4.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField4.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.sizeXSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField4.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeX(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField4.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeX(f);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField4.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField4.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 2000) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField4.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (n == 0) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField4.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField4.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.sizeXSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField4.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeX(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField4.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeX(f);
                PCASelectionAreaDialog.this.updateContent();
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.sizeXSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                float f = PCASelectionAreaDialog.this.getCoord(n);
                if (n == 0) {
                    f = 0.0f;
                }
                if (n == 2000) {
                    f = 2.0f * PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField4.setText("" + f);
                String string = PCASelectionAreaDialog.this.textField4.getText();
                float f2 = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeX(f2);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField5.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 2000) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField5.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (n == 0) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField5.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField5.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.sizeYSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField5.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeY(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField5.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeY(f);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField5.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField5.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 2000) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField5.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (n == 0) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField5.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField5.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.sizeYSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField5.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeY(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField5.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeY(f);
                PCASelectionAreaDialog.this.updateContent();
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.sizeYSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                float f = PCASelectionAreaDialog.this.getCoord(n);
                if (n == 0) {
                    f = 0.0f;
                }
                if (n == 2000) {
                    f = 2.0f * PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField5.setText("" + f);
                String string = PCASelectionAreaDialog.this.textField5.getText();
                float f2 = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeY(f2);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField6.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 2000) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField6.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (n == 0) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField6.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField6.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.sizeZSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField6.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeZ(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField6.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeZ(f);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField6.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                float f;
                String string;
                try {
                    string = PCASelectionAreaDialog.this.textField6.getText();
                    f = Float.parseFloat(string);
                    int n = PCASelectionAreaDialog.this.getSliderPos(f);
                    if (n >= 2000) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField6.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (n == 0) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField6.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(n);
                        PCASelectionAreaDialog.this.textField6.setText("" + f);
                    }
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.sizeZSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField6.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeZ(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                string = PCASelectionAreaDialog.this.textField6.getText();
                f = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeZ(f);
                PCASelectionAreaDialog.this.updateContent();
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.sizeZSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                float f = PCASelectionAreaDialog.this.getCoord(n);
                if (n == 0) {
                    f = 0.0f;
                }
                if (n == 2000) {
                    f = 2.0f * PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField6.setText("" + f);
                String string = PCASelectionAreaDialog.this.textField6.getText();
                float f2 = Float.parseFloat(string);
                PCASelectionAreaDialog.this.setSizeZ(f2);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Position X  ");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 25, 16);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.textField1, gridBagConstraints);
        jPanel.add(this.textField1);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.posXSlider, gridBagConstraints);
        jPanel.add(this.posXSlider);
        JLabel jLabel2 = new JLabel("Position Y  ");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 25, 16);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.textField2, gridBagConstraints);
        jPanel.add(this.textField2);
        this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.posYSlider, gridBagConstraints);
        jPanel.add(this.posYSlider);
        JLabel jLabel3 = new JLabel("Position Z  ");
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 25, 17);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.textField3, gridBagConstraints);
        jPanel.add(this.textField3);
        this.buildConstraints(gridBagConstraints, 2, 2, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.posZSlider, gridBagConstraints);
        jPanel.add(this.posZSlider);
        JLabel jLabel4 = new JLabel("Size X  ");
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 25, 17);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.textField4, gridBagConstraints);
        jPanel.add(this.textField4);
        this.buildConstraints(gridBagConstraints, 2, 3, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.sizeXSlider, gridBagConstraints);
        jPanel.add(this.sizeXSlider);
        JLabel jLabel5 = new JLabel("Size Y  ");
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 25, 17);
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel.add(jLabel5);
        this.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.textField5, gridBagConstraints);
        jPanel.add(this.textField5);
        this.buildConstraints(gridBagConstraints, 2, 4, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.sizeYSlider, gridBagConstraints);
        jPanel.add(this.sizeYSlider);
        JLabel jLabel6 = new JLabel("Size Z  ");
        this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 25, 17);
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        jPanel.add(jLabel6);
        this.buildConstraints(gridBagConstraints, 1, 5, 1, 1, 25, 0);
        gridBagLayout.setConstraints(this.textField6, gridBagConstraints);
        jPanel.add(this.textField6);
        this.buildConstraints(gridBagConstraints, 2, 5, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.sizeZSlider, gridBagConstraints);
        jPanel.add(this.sizeZSlider);
        this.addContent(jPanel);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.setActionListeners(listener);
        this.pack();
    }

    private int getSliderPos(float f) {
        return Math.round(1000.0f / this.maxPos * f);
    }

    private float getCoord(int n) {
        return this.maxPos * (float)n / 1000.0f;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getPositionX() {
        return Float.parseFloat(this.textField1.getText());
    }

    private void setPositionX(float f) {
        this.positionX = f;
    }

    public float getPositionY() {
        return Float.parseFloat(this.textField2.getText());
    }

    private void setPositionY(float f) {
        this.positionY = f;
    }

    public float getPositionZ() {
        return Float.parseFloat(this.textField3.getText());
    }

    private void setPositionZ(float f) {
        this.positionZ = f;
    }

    public float getSizeX() {
        return Float.parseFloat(this.textField4.getText());
    }

    private void setSizeX(float f) {
        this.sizeX = f;
    }

    public float getSizeY() {
        return Float.parseFloat(this.textField5.getText());
    }

    private void setSizeY(float f) {
        this.sizeY = f;
    }

    public float getSizeZ() {
        return Float.parseFloat(this.textField6.getText());
    }

    private void setSizeZ(float f) {
        this.sizeZ = f;
    }

    private void updateContent() {
        this.content.setBoxPosition(this.getPositionX(), this.getPositionY(), this.getPositionZ());
        this.content.setBoxSize(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        this.content.updateScene();
    }

    private void updateContentToInit() {
        this.content.setBoxPosition(0.0f, 0.0f, 0.0f);
        this.content.setBoxSize(this.initSize, this.initSize, this.initSize);
        this.content.updateScene();
    }

    private void resetValues() {
        this.posXSlider.setValue(0);
        this.posYSlider.setValue(0);
        this.posZSlider.setValue(0);
        this.sizeXSlider.setValue(this.initSizePos);
        this.sizeYSlider.setValue(this.initSizePos);
        this.sizeZSlider.setValue(this.initSizePos);
        this.textField1.setText("0.0");
        this.textField2.setText("0.0");
        this.textField3.setText("0.0");
        this.textField4.setText("" + this.initSize);
        this.textField5.setText("" + this.initSize);
        this.textField6.setText("" + this.initSize);
    }

    public static void main(String[] stringArray) {
        PCASelectionAreaDialog pCASelectionAreaDialog = new PCASelectionAreaDialog(new Frame(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f);
        pCASelectionAreaDialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    Float.parseFloat(PCASelectionAreaDialog.this.textField1.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField2.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField3.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField4.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField5.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField6.getText());
                    PCASelectionAreaDialog.this.result = 0;
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.result = 2;
                }
                PCASelectionAreaDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                PCASelectionAreaDialog.this.result = 2;
                PCASelectionAreaDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                PCASelectionAreaDialog.this.resetValues();
                PCASelectionAreaDialog.this.updateContentToInit();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(PCASelectionAreaDialog.this, "PCA Selection Area Configuration");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            PCASelectionAreaDialog.this.result = -1;
            PCASelectionAreaDialog.this.dispose();
        }
    }
}

